/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.io.FileUtils;
import org.apache.maven.settings.Proxy;

public class AllureCommandline {
    public static final String ALLURE_DEFAULT_VERSION = "2.0.1";
    private final String version;
    private final Path installationDirectory;

    public AllureCommandline(Path installationDirectory, String version) {
        this.installationDirectory = installationDirectory;
        this.version = version;
    }

    public int generateReport(List<Path> resultsPaths, Path reportPath) throws IOException {
        this.checkAllureExists();
        FileUtils.deleteQuietly((File)reportPath.toFile());
        CommandLine commandLine = new CommandLine(this.getAllureExecutablePath().toAbsolutePath().toFile());
        commandLine.addArgument("generate");
        commandLine.addArgument("--clean");
        for (Path resultsPath : resultsPaths) {
            commandLine.addArgument(resultsPath.toAbsolutePath().toString(), true);
        }
        commandLine.addArgument("-o");
        commandLine.addArgument(reportPath.toAbsolutePath().toString(), true);
        return this.execute(commandLine);
    }

    public int serve(List<Path> resultsPaths, Path reportPath) throws IOException {
        this.checkAllureExists();
        FileUtils.deleteQuietly((File)reportPath.toFile());
        CommandLine commandLine = new CommandLine(this.getAllureExecutablePath().toAbsolutePath().toFile());
        commandLine.addArgument("serve");
        for (Path resultsPath : resultsPaths) {
            commandLine.addArgument(resultsPath.toAbsolutePath().toString(), true);
        }
        return this.execute(commandLine);
    }

    private void checkAllureExists() throws FileNotFoundException {
        if (this.allureNotExists()) {
            throw new FileNotFoundException("There is no valid allure installation. Make sure you're using allure version not less then 2.x.");
        }
    }

    private int execute(CommandLine commandLine) throws IOException {
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        executor.setWatchdog(watchdog);
        executor.setExitValue(0);
        return executor.execute(commandLine);
    }

    private Path getAllureExecutablePath() {
        String allureExecutable = this.isWindows() ? "allure.bat" : "allure";
        return this.getAllureHome().resolve("bin").resolve(allureExecutable);
    }

    private Path getAllureHome() {
        return this.installationDirectory.resolve(String.format("allure-%s", this.version != null ? this.version : ALLURE_DEFAULT_VERSION));
    }

    private boolean allureExists() {
        Path allureExecutablePath = this.getAllureExecutablePath();
        return Files.exists(allureExecutablePath, new LinkOption[0]) && Files.isExecutable(allureExecutablePath);
    }

    boolean allureNotExists() {
        return !this.allureExists();
    }

    public void download(String allureDownloadUrl, Proxy mavenProxy) throws IOException {
        URL url;
        Path allureZip;
        if (this.allureExists()) {
            return;
        }
        if (this.version != null) {
            allureZip = Files.createTempFile("allure", this.version, new FileAttribute[0]);
            String allureUrl = String.format(allureDownloadUrl, this.version, this.version);
            url = new URL(allureUrl);
        } else {
            allureZip = Files.createTempFile("allure", ALLURE_DEFAULT_VERSION, new FileAttribute[0]);
            String allureUrl = String.format("/allure-%s.zip", ALLURE_DEFAULT_VERSION);
            url = AllureCommandline.class.getResource(allureUrl);
        }
        if (mavenProxy != null && this.version != null) {
            InetSocketAddress proxyAddress = new InetSocketAddress(mavenProxy.getHost(), mavenProxy.getPort());
            java.net.Proxy proxy = new java.net.Proxy(Proxy.Type.HTTP, proxyAddress);
            InputStream inputStream = url.openConnection(proxy).getInputStream();
            Files.copy(inputStream, allureZip, StandardCopyOption.REPLACE_EXISTING);
        } else {
            FileUtils.copyURLToFile((URL)url, (File)allureZip.toFile());
        }
        try {
            ZipFile zipFile = new ZipFile(allureZip.toFile());
            zipFile.extractAll(this.getInstallationDirectory().toAbsolutePath().toString());
        }
        catch (ZipException e) {
            throw new IOException(e);
        }
        Path allureExecutable = this.getAllureExecutablePath();
        if (Files.exists(allureExecutable, new LinkOption[0])) {
            allureExecutable.toFile().setExecutable(true);
        }
    }

    public Path getInstallationDirectory() {
        return this.installationDirectory;
    }

    public String getVersion() {
        return this.version;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }
}

