/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import io.qameta.allure.maven.AllureCommandline;
import io.qameta.allure.maven.AllureGenerateMojo;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="serve", defaultPhase=LifecyclePhase.SITE)
public class AllureServeMojo
extends AllureGenerateMojo {
    @Parameter(property="allure.serve.timeout", defaultValue="3600")
    private int serveTimeout;
    @Parameter(property="allure.serve.host")
    private String serveHost;
    @Parameter(property="allure.serve.port", defaultValue="0")
    private Integer servePort;

    @Override
    protected List<Path> getInputDirectories() {
        Path path = this.getInputDirectoryAbsolutePath();
        if (this.isDirectoryExists(path)) {
            this.getLog().info((CharSequence)("Found results directory " + path));
            return Collections.singletonList(path);
        }
        this.getLog().error((CharSequence)("Directory " + path + " not found."));
        return Collections.emptyList();
    }

    private Path getInputDirectoryAbsolutePath() {
        Path path = Paths.get(this.resultsDirectory, new String[0]);
        return path.isAbsolute() ? path : Paths.get(this.buildDirectory, new String[0]).resolve(path);
    }

    @Override
    protected void generateReport(List<Path> resultsPaths) throws MavenReportException {
        try {
            Path reportPath = Paths.get(this.getReportDirectory(), new String[0]);
            AllureCommandline commandline = new AllureCommandline(Paths.get(this.getInstallDirectory(), new String[0]), this.reportVersion, this.serveTimeout);
            this.getLog().info((CharSequence)("Generate report to " + reportPath));
            commandline.serve(resultsPaths, reportPath, this.serveHost, this.servePort);
            this.getLog().info((CharSequence)"Report generated successfully.");
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Can't generate allure report data", (Throwable)e);
            throw new MavenReportException("Can't generate allure report data", e);
        }
    }

    @Override
    protected String getMojoName() {
        return "serve";
    }
}

