/*
 * Decompiled with CFR 0.152.
 */
package io.provis;

import com.google.common.io.ByteStreams;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SimpleProvisioner {
    protected File resolveFromRepository(String repositoryUrl, String coordinate) throws IOException {
        String path = this.coordinateToPath(coordinate);
        String url = String.format("%s/%s", repositoryUrl, path);
        return this.resolveFromServer(url, coordinate);
    }

    protected File resolveFromServer(String archiveUrl, String coordinate) throws IOException {
        Request request;
        OkHttpClient client;
        Response response;
        String path;
        File localRepository = new File(System.getProperty("user.home"), ".m2/repository");
        File file = new File(localRepository, path = this.coordinateToPath(coordinate));
        if (file.exists()) {
            return file;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!(response = (client = new OkHttpClient()).newCall(request = new Request.Builder().url(archiveUrl).build()).execute()).isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            ByteStreams.copy((InputStream)response.body().byteStream(), (OutputStream)os);
        }
        return file;
    }

    protected String coordinateToPath(String coords) {
        Pattern p = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
        Matcher m = p.matcher(coords);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coords + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String extension = this.get(m.group(4), "jar");
        String classifier = this.get(m.group(6), "");
        String version = m.group(7);
        return this.repositoryPathOf(groupId, artifactId, extension, classifier, version);
    }

    protected String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }

    public String repositoryPathOf(String groupId, String artifactId, String extension, String classifier, String version) {
        StringBuffer path = new StringBuffer().append(groupId.replace('.', '/')).append('/').append(artifactId).append('/').append(version).append('/').append(artifactId).append('-').append(version);
        if (classifier != null && !classifier.isEmpty() && !classifier.equals("jar")) {
            path.append("-").append(classifier);
        }
        path.append('.').append(extension);
        return path.toString();
    }
}

