/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.net.SocketAddress;
import reactor.netty.Metrics;
import reactor.netty.http.client.Http2Pool;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;

final class MicrometerHttp2ConnectionProviderMeterRegistrar {
    static final String ACTIVE_CONNECTIONS_DESCRIPTION = "The number of the connections that have been successfully acquired and are in active use";
    static final String ACTIVE_STREAMS_DESCRIPTION = "The number of the active HTTP/2 streams";
    static final String IDLE_CONNECTIONS_DESCRIPTION = "The number of the idle connections";
    static final String PENDING_STREAMS_DESCRIPTION = "The number of requests that are waiting for opening HTTP/2 stream";
    static final MicrometerHttp2ConnectionProviderMeterRegistrar INSTANCE = new MicrometerHttp2ConnectionProviderMeterRegistrar();

    private MicrometerHttp2ConnectionProviderMeterRegistrar() {
    }

    void registerMetrics(String poolName, String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        Tags tags = Tags.of((String[])new String[]{"id", id, "remote.address", addressAsString, "name", poolName});
        Gauge.builder((String)"reactor.netty.connection.provider.active.connections", (Object)metrics, InstrumentedPool.PoolMetrics::acquiredSize).description(ACTIVE_CONNECTIONS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.active.streams", (Object)metrics, poolMetrics -> ((Http2Pool)poolMetrics).activeStreams()).description(ACTIVE_STREAMS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.idle.connections", (Object)metrics, InstrumentedPool.PoolMetrics::idleSize).description(IDLE_CONNECTIONS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.pending.streams", (Object)metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).description(PENDING_STREAMS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
    }

    void deRegisterMetrics(String poolName, String id, SocketAddress remoteAddress) {
        String addressAsString = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        Tags tags = Tags.of((String[])new String[]{"id", id, "remote.address", addressAsString, "name", poolName});
        Metrics.REGISTRY.remove(new Meter.Id("reactor.netty.connection.provider.active.connections", tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id("reactor.netty.connection.provider.active.streams", tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id("reactor.netty.connection.provider.idle.connections", tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id("reactor.netty.connection.provider.pending.streams", tags, null, null, Meter.Type.GAUGE));
    }
}

