/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigClientAutoConfiguration;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration(after={ConfigClientAutoConfiguration.class})
@ConditionalOnBean(value={ConfigClientProperties.class})
@ConditionalOnProperty(name={"spring.cloud.config.token"})
@EnableConfigurationProperties
@EnableScheduling
public class VaultTokenRenewalAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultTokenRenewalAutoConfiguration.class);
    private static final String VAULT_TOKEN_HEADER = "X-Vault-Token";
    private static final String REFRESH_PATH = "/vault/v1/auth/token/renew-self";
    @Value(value="${vault.token.ttl:300000}")
    long ttl;

    @Bean
    @ConditionalOnBean(value={RestTemplate.class}, name={"configClientRestTemplate"})
    public VaultTokenRefresher vaultTokenRefresher(@Qualifier(value="configClientRestTemplate") RestTemplate configClientRestTemplate, ConfigClientProperties configClientProperties) {
        String refreshUri = configClientProperties.getUri()[0] + REFRESH_PATH;
        String vaultToken = configClientProperties.getToken();
        String obscuredToken = vaultToken.substring(0, 4) + "[*]" + vaultToken.substring(vaultToken.length() - 4);
        return new VaultTokenRefresher(configClientRestTemplate, obscuredToken, this.ttl, refreshUri, this.buildTokenRenewRequest(vaultToken));
    }

    private HttpEntity<Map<String, Long>> buildTokenRenewRequest(String vaultToken) {
        long ttlInSeconds = this.ttl / 1000L;
        Map<String, Long> requestBody = Map.of("increment", ttlInSeconds);
        HttpHeaders headers = new HttpHeaders();
        headers.set(VAULT_TOKEN_HEADER, vaultToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity(requestBody, (MultiValueMap)headers);
    }

    public static class VaultTokenRefresher {
        private final String obscuredToken;
        private final long ttl;
        private final String refreshUri;
        private final HttpEntity<Map<String, Long>> request;
        private final RestTemplate restTemplate;

        VaultTokenRefresher(RestTemplate restTemplate, String obscuredToken, long ttl, String refreshUri, HttpEntity<Map<String, Long>> request) {
            this.restTemplate = restTemplate;
            this.obscuredToken = obscuredToken;
            this.ttl = ttl;
            this.refreshUri = refreshUri;
            this.request = request;
        }

        @Scheduled(fixedRateString="${vault.token.renew.rate:60000}")
        public void refreshVaultToken() {
            try {
                LOGGER.debug("Renewing Vault token " + this.obscuredToken + " for " + this.ttl + " milliseconds.");
                this.restTemplate.postForObject(this.refreshUri, this.request, String.class, new Object[0]);
            }
            catch (RestClientException e) {
                LOGGER.error("Unable to renew Vault token " + this.obscuredToken + ". Is the token invalid or expired?");
            }
        }
    }
}

