/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.redis;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.RedisSpanNameProvider;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisClusterConnection;
import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisConnection;
import io.opentracing.contrib.spring.cloud.redis.RedisTracingProperties;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;

@Aspect
public class RedisAspect {
    private final Tracer tracer;
    private final RedisTracingProperties properties;

    RedisAspect(Tracer tracer, RedisTracingProperties properties) {
        this.tracer = tracer;
        this.properties = properties;
    }

    @Pointcut(value="target(org.springframework.data.redis.connection.RedisConnectionFactory)")
    public void connectionFactory() {
    }

    @Pointcut(value="execution(org.springframework.data.redis.connection.RedisConnection *.getConnection(..))")
    public void getConnection() {
    }

    @Pointcut(value="execution(org.springframework.data.redis.connection.RedisClusterConnection *.getClusterConnection(..))")
    public void getClusterConnection() {
    }

    @Around(value="getConnection() && connectionFactory()")
    public Object aroundGetConnection(ProceedingJoinPoint pjp) throws Throwable {
        RedisConnection connection = (RedisConnection)pjp.proceed();
        String prefixOperationName = this.properties.getPrefixOperationName();
        TracingConfiguration tracingConfiguration = new TracingConfiguration.Builder(this.tracer).withSpanNameProvider(RedisSpanNameProvider.PREFIX_OPERATION_NAME((String)prefixOperationName)).build();
        return new TracingRedisConnection(connection, tracingConfiguration);
    }

    @Around(value="getClusterConnection() && connectionFactory()")
    public Object aroundGetClusterConnection(ProceedingJoinPoint pjp) throws Throwable {
        RedisClusterConnection clusterConnection = (RedisClusterConnection)pjp.proceed();
        String prefixOperationName = this.properties.getPrefixOperationName();
        TracingConfiguration tracingConfiguration = new TracingConfiguration.Builder(this.tracer).withSpanNameProvider(RedisSpanNameProvider.PREFIX_OPERATION_NAME((String)prefixOperationName)).build();
        return new TracingRedisClusterConnection(clusterConnection, tracingConfiguration);
    }
}

