/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc.parser;

import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.parser.AbstractURLParser;
import io.opentracing.contrib.jdbc.parser.URLLocation;

public class H2URLParser
extends AbstractURLParser {
    private static final String LOCALHOST = "localhost";
    private static final int DEFAULT_PORT = 8084;
    private static final String FILE_MODE_FLAG = "file";
    private static final String MEMORY_MODE_FLAG = "mem";
    private static final String H2_DB_TYPE = "h2";

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange(String url) {
        int hostLabelStartIndex = url.indexOf("//");
        int hostLabelEndIndex = url.indexOf("/", hostLabelStartIndex + 2);
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange(String url) {
        int databaseStartTag = url.lastIndexOf("/");
        int databaseEndTag = url.indexOf(";");
        if (databaseEndTag == -1) {
            databaseEndTag = url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse(String url) {
        int[] databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexFromURLForH2FileMode(url);
        if (databaseNameRangeIndex != null) {
            return new ConnectionInfo.Builder(LOCALHOST, -1).dbType(H2_DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url, databaseNameRangeIndex)).build();
        }
        databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexFromURLForH2MemMode(url);
        if (databaseNameRangeIndex != null) {
            return new ConnectionInfo.Builder(LOCALHOST, -1).dbType(H2_DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url, databaseNameRangeIndex)).build();
        }
        String[] hostAndPort = this.fetchDatabaseHostsFromURL(url).split(":");
        if (hostAndPort.length == 1) {
            return new ConnectionInfo.Builder(hostAndPort[0], 8084).dbType(H2_DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url)).build();
        }
        return new ConnectionInfo.Builder(hostAndPort[0], Integer.valueOf(hostAndPort[1])).dbType(H2_DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url)).build();
    }

    private int[] fetchDatabaseNameRangeIndexFromURLForH2FileMode(String url) {
        int fileLabelIndex = url.indexOf(FILE_MODE_FLAG);
        int parameterLabelIndex = url.indexOf(";", fileLabelIndex);
        if (parameterLabelIndex == -1) {
            parameterLabelIndex = url.length();
        }
        if (fileLabelIndex != -1) {
            return new int[]{fileLabelIndex + FILE_MODE_FLAG.length() + 1, parameterLabelIndex};
        }
        return null;
    }

    private int[] fetchDatabaseNameRangeIndexFromURLForH2MemMode(String url) {
        int fileLabelIndex = url.indexOf(MEMORY_MODE_FLAG);
        int parameterLabelIndex = url.indexOf(";", fileLabelIndex);
        if (parameterLabelIndex == -1) {
            parameterLabelIndex = url.length();
        }
        if (fileLabelIndex != -1) {
            return new int[]{fileLabelIndex + MEMORY_MODE_FLAG.length() + 1, parameterLabelIndex};
        }
        return null;
    }
}

