/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class JdbcTracingUtils {
    static final String COMPONENT_NAME = "java-jdbc";
    static final StringTag PEER_ADDRESS = new StringTag("peer.address");

    JdbcTracingUtils() {
    }

    static Span buildSpan(String operationName, String sql, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoredStatements, Tracer tracer) {
        Tracer currentTracer = JdbcTracingUtils.getNullsafeTracer(tracer);
        if (withActiveSpanOnly && currentTracer.activeSpan() == null) {
            return NoopSpan.INSTANCE;
        }
        if (ignoredStatements != null && ignoredStatements.contains(sql)) {
            return NoopSpan.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = currentTracer.buildSpan(operationName).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        JdbcTracingUtils.decorate(span, sql, connectionInfo);
        return span;
    }

    static Tracer getNullsafeTracer(Tracer tracer) {
        if (tracer == null) {
            return GlobalTracer.get();
        }
        return tracer;
    }

    private static void decorate(Span span, String sql, ConnectionInfo connectionInfo) {
        Tags.COMPONENT.set(span, COMPONENT_NAME);
        Tags.DB_STATEMENT.set(span, sql);
        if (connectionInfo.getDbType() != null) {
            Tags.DB_TYPE.set(span, connectionInfo.getDbType());
        }
        if (connectionInfo.getDbPeer() != null) {
            PEER_ADDRESS.set(span, connectionInfo.getDbPeer());
        }
        if (connectionInfo.getDbInstance() != null) {
            Tags.DB_INSTANCE.set(span, connectionInfo.getDbInstance());
        }
        if (connectionInfo.getDbUser() != null) {
            Tags.DB_USER.set(span, connectionInfo.getDbUser());
        }
    }

    static void onError(Throwable throwable, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        if (throwable != null) {
            span.log(JdbcTracingUtils.errorLogs(throwable));
        }
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(3);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", throwable);
        return errorLogs;
    }
}

