/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ComposableSampler;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ImmutableSamplingIntent;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.OtelTraceState;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.SamplingIntent;
import io.opentelemetry.sdk.internal.RandomSupplier;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.Random;

public final class CompositeSampler
implements Sampler {
    private final ComposableSampler delegate;

    public static Sampler wrap(ComposableSampler delegate) {
        return new CompositeSampler(delegate);
    }

    private CompositeSampler(ComposableSampler delegate) {
        this.delegate = delegate;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        final TraceState traceState = Span.fromContext((Context)parentContext).getSpanContext().getTraceState();
        OtelTraceState otelTraceState = OtelTraceState.parse(traceState);
        final SamplingIntent intent = this.delegate.getSamplingIntent(parentContext, traceId, name, spanKind, attributes, parentLinks);
        boolean thresholdReliable = false;
        boolean sampled = false;
        if (ImmutableSamplingIntent.isValidThreshold(intent.getThreshold())) {
            thresholdReliable = intent.isThresholdReliable();
            long randomValue = thresholdReliable ? (ImmutableSamplingIntent.isValidRandomValue(otelTraceState.getRandomValue()) ? otelTraceState.getRandomValue() : OtelEncodingUtils.longFromBase16String((CharSequence)traceId, (int)16) & 0xFFFFFFFFFFFFFFL) : ((Random)RandomSupplier.platformDefault().get()).nextLong() & 0xFFFFFFFFFFFFFFL;
            sampled = intent.getThreshold() <= randomValue;
        }
        final SamplingDecision decision = sampled ? SamplingDecision.RECORD_AND_SAMPLE : SamplingDecision.DROP;
        otelTraceState = sampled && thresholdReliable ? new OtelTraceState(otelTraceState.getRandomValue(), intent.getThreshold(), otelTraceState.getRest()) : new OtelTraceState(otelTraceState.getRandomValue(), -1L, otelTraceState.getRest());
        final String serializedState = otelTraceState.serialize();
        return new SamplingResult(){

            public SamplingDecision getDecision() {
                return decision;
            }

            public Attributes getAttributes() {
                return intent.getAttributes();
            }

            public TraceState getUpdatedTraceState(TraceState parentTraceState) {
                TraceState newTraceState = intent.getTraceStateUpdater().apply(traceState);
                if (!serializedState.isEmpty()) {
                    newTraceState = newTraceState.toBuilder().put("ot", serializedState).build();
                }
                return newTraceState;
            }
        };
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String toString() {
        return this.getDescription();
    }
}

