/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalMeterConfiguratorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MetricReaderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ViewModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"readers", "views", "exemplar_filter", "meter_configurator/development"})
public class MeterProviderModel {
    @JsonProperty(value="readers")
    @Nonnull
    private List<MetricReaderModel> readers = new ArrayList<MetricReaderModel>();
    @Nullable
    @JsonProperty(value="views")
    private List<ViewModel> views = new ArrayList<ViewModel>();
    @Nullable
    @JsonProperty(value="exemplar_filter")
    private ExemplarFilter exemplarFilter;
    @Nullable
    @JsonProperty(value="meter_configurator/development")
    private ExperimentalMeterConfiguratorModel meterConfiguratorDevelopment;

    @JsonProperty(value="readers")
    public List<MetricReaderModel> getReaders() {
        return this.readers;
    }

    public MeterProviderModel withReaders(List<MetricReaderModel> readers) {
        this.readers = readers;
        return this;
    }

    @JsonProperty(value="views")
    public List<ViewModel> getViews() {
        return this.views;
    }

    public MeterProviderModel withViews(List<ViewModel> views) {
        this.views = views;
        return this;
    }

    @JsonProperty(value="exemplar_filter")
    public ExemplarFilter getExemplarFilter() {
        return this.exemplarFilter;
    }

    public MeterProviderModel withExemplarFilter(ExemplarFilter exemplarFilter) {
        this.exemplarFilter = exemplarFilter;
        return this;
    }

    @JsonProperty(value="meter_configurator/development")
    @Nullable
    public ExperimentalMeterConfiguratorModel getMeterConfiguratorDevelopment() {
        return this.meterConfiguratorDevelopment;
    }

    public MeterProviderModel withMeterConfiguratorDevelopment(ExperimentalMeterConfiguratorModel meterConfiguratorDevelopment) {
        this.meterConfiguratorDevelopment = meterConfiguratorDevelopment;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MeterProviderModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("readers");
        sb.append('=');
        sb.append(this.readers == null ? "<null>" : this.readers);
        sb.append(',');
        sb.append("views");
        sb.append('=');
        sb.append(this.views == null ? "<null>" : this.views);
        sb.append(',');
        sb.append("exemplarFilter");
        sb.append('=');
        sb.append(this.exemplarFilter == null ? "<null>" : this.exemplarFilter);
        sb.append(',');
        sb.append("meterConfiguratorDevelopment");
        sb.append('=');
        sb.append(this.meterConfiguratorDevelopment == null ? "<null>" : this.meterConfiguratorDevelopment);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.exemplarFilter == null ? 0 : this.exemplarFilter.hashCode());
        result = result * 31 + (this.meterConfiguratorDevelopment == null ? 0 : this.meterConfiguratorDevelopment.hashCode());
        result = result * 31 + (this.readers == null ? 0 : this.readers.hashCode());
        result = result * 31 + (this.views == null ? 0 : this.views.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MeterProviderModel)) {
            return false;
        }
        MeterProviderModel rhs = (MeterProviderModel)other;
        return (this.exemplarFilter == rhs.exemplarFilter || this.exemplarFilter != null && this.exemplarFilter.equals((Object)rhs.exemplarFilter)) && (this.meterConfiguratorDevelopment == rhs.meterConfiguratorDevelopment || this.meterConfiguratorDevelopment != null && this.meterConfiguratorDevelopment.equals(rhs.meterConfiguratorDevelopment)) && (this.readers == rhs.readers || this.readers != null && this.readers.equals(rhs.readers)) && (this.views == rhs.views || this.views != null && this.views.equals(rhs.views));
    }

    public static enum ExemplarFilter {
        ALWAYS_ON("always_on"),
        ALWAYS_OFF("always_off"),
        TRACE_BASED("trace_based");

        private final String value;
        private static final Map<String, ExemplarFilter> CONSTANTS;

        private ExemplarFilter(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExemplarFilter fromValue(String value) {
            ExemplarFilter constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ExemplarFilter>();
            for (ExemplarFilter c : ExemplarFilter.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

