/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.AttributeNameValueModel;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class AttributeListFactory
implements Factory<List<AttributeNameValueModel>, Attributes> {
    private static final AttributeListFactory INSTANCE = new AttributeListFactory();

    private AttributeListFactory() {
    }

    static AttributeListFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Attributes create(List<AttributeNameValueModel> model, DeclarativeConfigContext context) {
        AttributesBuilder builder = Attributes.builder();
        for (AttributeNameValueModel nameValueModel : model) {
            AttributeListFactory.addToBuilder(nameValueModel, builder);
        }
        return builder.build();
    }

    private static void addToBuilder(AttributeNameValueModel nameValueModel, AttributesBuilder builder) {
        String name = FileConfigUtil.requireNonNull(nameValueModel.getName(), "attribute name");
        Object value = FileConfigUtil.requireNonNull(nameValueModel.getValue(), "attribute value");
        AttributeNameValueModel.AttributeType type = nameValueModel.getType();
        if (type == null) {
            type = AttributeNameValueModel.AttributeType.STRING;
        }
        switch (type) {
            case STRING: {
                if (!(value instanceof String)) break;
                builder.put(name, (String)value);
                return;
            }
            case BOOL: {
                if (!(value instanceof Boolean)) break;
                builder.put(name, ((Boolean)value).booleanValue());
                return;
            }
            case INT: {
                if (!(value instanceof Integer) && !(value instanceof Long)) break;
                builder.put(name, ((Number)value).longValue());
                return;
            }
            case DOUBLE: {
                if (!(value instanceof Number)) break;
                builder.put(name, ((Number)value).doubleValue());
                return;
            }
            case STRING_ARRAY: {
                List<String> stringList = AttributeListFactory.checkListOfType(value, String.class);
                if (stringList == null) break;
                builder.put(AttributeKey.stringArrayKey((String)name), stringList);
                return;
            }
            case BOOL_ARRAY: {
                List<Boolean> boolList = AttributeListFactory.checkListOfType(value, Boolean.class);
                if (boolList == null) break;
                builder.put(AttributeKey.booleanArrayKey((String)name), boolList);
                return;
            }
            case INT_ARRAY: {
                List<Long> longList = AttributeListFactory.checkListOfType(value, Long.class);
                if (longList != null) {
                    builder.put(AttributeKey.longArrayKey((String)name), longList);
                    return;
                }
                List<Integer> intList = AttributeListFactory.checkListOfType(value, Integer.class);
                if (intList == null) break;
                builder.put(AttributeKey.longArrayKey((String)name), intList.stream().map(i -> (long)i).collect(Collectors.toList()));
                return;
            }
            case DOUBLE_ARRAY: {
                List<Double> doubleList = AttributeListFactory.checkListOfType(value, Double.class);
                if (doubleList != null) {
                    builder.put(AttributeKey.doubleArrayKey((String)name), doubleList);
                    return;
                }
                List<Float> floatList = AttributeListFactory.checkListOfType(value, Float.class);
                if (floatList == null) break;
                builder.put(AttributeKey.doubleArrayKey((String)name), floatList.stream().map(i -> i.floatValue()).collect(Collectors.toList()));
                return;
            }
        }
        throw new DeclarativeConfigException("Error processing attribute with name \"" + name + "\": value did not match type " + type.name());
    }

    @Nullable
    private static <T> List<T> checkListOfType(Object value, Class<T> expectedType) {
        if (!(value instanceof List)) {
            return null;
        }
        List list = (List)value;
        if (list.isEmpty()) {
            return null;
        }
        if (!list.stream().allMatch(entry -> expectedType.isAssignableFrom(entry.getClass()))) {
            return null;
        }
        return (List)value;
    }
}

