
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Nullable;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "interval",
    "timeout",
    "exporter",
    "producers",
    "cardinality_limits"
})
@Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
public class PeriodicMetricReaderModel {

    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("interval")
    private Integer interval;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("timeout")
    private Integer timeout;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("exporter")
    @Nonnull
    private PushMetricExporterModel exporter;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("producers")
    private List<MetricProducerModel> producers = new ArrayList<MetricProducerModel>();
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("cardinality_limits")
    private CardinalityLimitsModel cardinalityLimits;

    @JsonProperty("interval")
    @Nullable
    public Integer getInterval() {
        return interval;
    }

    public PeriodicMetricReaderModel withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    @JsonProperty("timeout")
    @Nullable
    public Integer getTimeout() {
        return timeout;
    }

    public PeriodicMetricReaderModel withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("exporter")
    @Nullable
    public PushMetricExporterModel getExporter() {
        return exporter;
    }

    public PeriodicMetricReaderModel withExporter(PushMetricExporterModel exporter) {
        this.exporter = exporter;
        return this;
    }

    @JsonProperty("producers")
    public List<MetricProducerModel> getProducers() {
        return producers;
    }

    public PeriodicMetricReaderModel withProducers(List<MetricProducerModel> producers) {
        this.producers = producers;
        return this;
    }

    @JsonProperty("cardinality_limits")
    @Nullable
    public CardinalityLimitsModel getCardinalityLimits() {
        return cardinalityLimits;
    }

    public PeriodicMetricReaderModel withCardinalityLimits(CardinalityLimitsModel cardinalityLimits) {
        this.cardinalityLimits = cardinalityLimits;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PeriodicMetricReaderModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("interval");
        sb.append('=');
        sb.append(((this.interval == null)?"<null>":this.interval));
        sb.append(',');
        sb.append("timeout");
        sb.append('=');
        sb.append(((this.timeout == null)?"<null>":this.timeout));
        sb.append(',');
        sb.append("exporter");
        sb.append('=');
        sb.append(((this.exporter == null)?"<null>":this.exporter));
        sb.append(',');
        sb.append("producers");
        sb.append('=');
        sb.append(((this.producers == null)?"<null>":this.producers));
        sb.append(',');
        sb.append("cardinalityLimits");
        sb.append('=');
        sb.append(((this.cardinalityLimits == null)?"<null>":this.cardinalityLimits));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.interval == null)? 0 :this.interval.hashCode()));
        result = ((result* 31)+((this.exporter == null)? 0 :this.exporter.hashCode()));
        result = ((result* 31)+((this.cardinalityLimits == null)? 0 :this.cardinalityLimits.hashCode()));
        result = ((result* 31)+((this.timeout == null)? 0 :this.timeout.hashCode()));
        result = ((result* 31)+((this.producers == null)? 0 :this.producers.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PeriodicMetricReaderModel) == false) {
            return false;
        }
        PeriodicMetricReaderModel rhs = ((PeriodicMetricReaderModel) other);
        return ((((((this.interval == rhs.interval)||((this.interval!= null)&&this.interval.equals(rhs.interval)))&&((this.exporter == rhs.exporter)||((this.exporter!= null)&&this.exporter.equals(rhs.exporter))))&&((this.cardinalityLimits == rhs.cardinalityLimits)||((this.cardinalityLimits!= null)&&this.cardinalityLimits.equals(rhs.cardinalityLimits))))&&((this.timeout == rhs.timeout)||((this.timeout!= null)&&this.timeout.equals(rhs.timeout))))&&((this.producers == rhs.producers)||((this.producers!= null)&&this.producers.equals(rhs.producers))));
    }

}
