
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.Nullable;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "endpoint",
    "certificate_file",
    "client_key_file",
    "client_certificate_file",
    "headers",
    "headers_list",
    "compression",
    "timeout",
    "encoding",
    "temporality_preference",
    "default_histogram_aggregation"
})
@Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
public class OtlpHttpMetricExporterModel {

    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("endpoint")
    private String endpoint;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("certificate_file")
    private String certificateFile;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("client_key_file")
    private String clientKeyFile;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("client_certificate_file")
    private String clientCertificateFile;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("headers")
    private List<NameStringValuePairModel> headers = new ArrayList<NameStringValuePairModel>();
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("headers_list")
    private String headersList;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("compression")
    private String compression;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("timeout")
    private Integer timeout;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("encoding")
    private io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OtlpHttpExporterModel.OtlpHttpEncoding encoding;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("temporality_preference")
    private OtlpHttpMetricExporterModel.ExporterTemporalityPreference temporalityPreference;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("default_histogram_aggregation")
    private OtlpHttpMetricExporterModel.ExporterDefaultHistogramAggregation defaultHistogramAggregation;

    @JsonProperty("endpoint")
    @Nullable
    public String getEndpoint() {
        return endpoint;
    }

    public OtlpHttpMetricExporterModel withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonProperty("certificate_file")
    @Nullable
    public String getCertificateFile() {
        return certificateFile;
    }

    public OtlpHttpMetricExporterModel withCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
        return this;
    }

    @JsonProperty("client_key_file")
    @Nullable
    public String getClientKeyFile() {
        return clientKeyFile;
    }

    public OtlpHttpMetricExporterModel withClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
        return this;
    }

    @JsonProperty("client_certificate_file")
    @Nullable
    public String getClientCertificateFile() {
        return clientCertificateFile;
    }

    public OtlpHttpMetricExporterModel withClientCertificateFile(String clientCertificateFile) {
        this.clientCertificateFile = clientCertificateFile;
        return this;
    }

    @JsonProperty("headers")
    public List<NameStringValuePairModel> getHeaders() {
        return headers;
    }

    public OtlpHttpMetricExporterModel withHeaders(List<NameStringValuePairModel> headers) {
        this.headers = headers;
        return this;
    }

    @JsonProperty("headers_list")
    @Nullable
    public String getHeadersList() {
        return headersList;
    }

    public OtlpHttpMetricExporterModel withHeadersList(String headersList) {
        this.headersList = headersList;
        return this;
    }

    @JsonProperty("compression")
    @Nullable
    public String getCompression() {
        return compression;
    }

    public OtlpHttpMetricExporterModel withCompression(String compression) {
        this.compression = compression;
        return this;
    }

    @JsonProperty("timeout")
    @Nullable
    public Integer getTimeout() {
        return timeout;
    }

    public OtlpHttpMetricExporterModel withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty("encoding")
    public io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OtlpHttpExporterModel.OtlpHttpEncoding getEncoding() {
        return encoding;
    }

    public OtlpHttpMetricExporterModel withEncoding(io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OtlpHttpExporterModel.OtlpHttpEncoding encoding) {
        this.encoding = encoding;
        return this;
    }

    @JsonProperty("temporality_preference")
    public OtlpHttpMetricExporterModel.ExporterTemporalityPreference getTemporalityPreference() {
        return temporalityPreference;
    }

    public OtlpHttpMetricExporterModel withTemporalityPreference(OtlpHttpMetricExporterModel.ExporterTemporalityPreference temporalityPreference) {
        this.temporalityPreference = temporalityPreference;
        return this;
    }

    @JsonProperty("default_histogram_aggregation")
    public OtlpHttpMetricExporterModel.ExporterDefaultHistogramAggregation getDefaultHistogramAggregation() {
        return defaultHistogramAggregation;
    }

    public OtlpHttpMetricExporterModel withDefaultHistogramAggregation(OtlpHttpMetricExporterModel.ExporterDefaultHistogramAggregation defaultHistogramAggregation) {
        this.defaultHistogramAggregation = defaultHistogramAggregation;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OtlpHttpMetricExporterModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("endpoint");
        sb.append('=');
        sb.append(((this.endpoint == null)?"<null>":this.endpoint));
        sb.append(',');
        sb.append("certificateFile");
        sb.append('=');
        sb.append(((this.certificateFile == null)?"<null>":this.certificateFile));
        sb.append(',');
        sb.append("clientKeyFile");
        sb.append('=');
        sb.append(((this.clientKeyFile == null)?"<null>":this.clientKeyFile));
        sb.append(',');
        sb.append("clientCertificateFile");
        sb.append('=');
        sb.append(((this.clientCertificateFile == null)?"<null>":this.clientCertificateFile));
        sb.append(',');
        sb.append("headers");
        sb.append('=');
        sb.append(((this.headers == null)?"<null>":this.headers));
        sb.append(',');
        sb.append("headersList");
        sb.append('=');
        sb.append(((this.headersList == null)?"<null>":this.headersList));
        sb.append(',');
        sb.append("compression");
        sb.append('=');
        sb.append(((this.compression == null)?"<null>":this.compression));
        sb.append(',');
        sb.append("timeout");
        sb.append('=');
        sb.append(((this.timeout == null)?"<null>":this.timeout));
        sb.append(',');
        sb.append("encoding");
        sb.append('=');
        sb.append(((this.encoding == null)?"<null>":this.encoding));
        sb.append(',');
        sb.append("temporalityPreference");
        sb.append('=');
        sb.append(((this.temporalityPreference == null)?"<null>":this.temporalityPreference));
        sb.append(',');
        sb.append("defaultHistogramAggregation");
        sb.append('=');
        sb.append(((this.defaultHistogramAggregation == null)?"<null>":this.defaultHistogramAggregation));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.headers == null)? 0 :this.headers.hashCode()));
        result = ((result* 31)+((this.endpoint == null)? 0 :this.endpoint.hashCode()));
        result = ((result* 31)+((this.clientCertificateFile == null)? 0 :this.clientCertificateFile.hashCode()));
        result = ((result* 31)+((this.headersList == null)? 0 :this.headersList.hashCode()));
        result = ((result* 31)+((this.certificateFile == null)? 0 :this.certificateFile.hashCode()));
        result = ((result* 31)+((this.clientKeyFile == null)? 0 :this.clientKeyFile.hashCode()));
        result = ((result* 31)+((this.compression == null)? 0 :this.compression.hashCode()));
        result = ((result* 31)+((this.encoding == null)? 0 :this.encoding.hashCode()));
        result = ((result* 31)+((this.temporalityPreference == null)? 0 :this.temporalityPreference.hashCode()));
        result = ((result* 31)+((this.timeout == null)? 0 :this.timeout.hashCode()));
        result = ((result* 31)+((this.defaultHistogramAggregation == null)? 0 :this.defaultHistogramAggregation.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OtlpHttpMetricExporterModel) == false) {
            return false;
        }
        OtlpHttpMetricExporterModel rhs = ((OtlpHttpMetricExporterModel) other);
        return ((((((((((((this.headers == rhs.headers)||((this.headers!= null)&&this.headers.equals(rhs.headers)))&&((this.endpoint == rhs.endpoint)||((this.endpoint!= null)&&this.endpoint.equals(rhs.endpoint))))&&((this.clientCertificateFile == rhs.clientCertificateFile)||((this.clientCertificateFile!= null)&&this.clientCertificateFile.equals(rhs.clientCertificateFile))))&&((this.headersList == rhs.headersList)||((this.headersList!= null)&&this.headersList.equals(rhs.headersList))))&&((this.certificateFile == rhs.certificateFile)||((this.certificateFile!= null)&&this.certificateFile.equals(rhs.certificateFile))))&&((this.clientKeyFile == rhs.clientKeyFile)||((this.clientKeyFile!= null)&&this.clientKeyFile.equals(rhs.clientKeyFile))))&&((this.compression == rhs.compression)||((this.compression!= null)&&this.compression.equals(rhs.compression))))&&((this.encoding == rhs.encoding)||((this.encoding!= null)&&this.encoding.equals(rhs.encoding))))&&((this.temporalityPreference == rhs.temporalityPreference)||((this.temporalityPreference!= null)&&this.temporalityPreference.equals(rhs.temporalityPreference))))&&((this.timeout == rhs.timeout)||((this.timeout!= null)&&this.timeout.equals(rhs.timeout))))&&((this.defaultHistogramAggregation == rhs.defaultHistogramAggregation)||((this.defaultHistogramAggregation!= null)&&this.defaultHistogramAggregation.equals(rhs.defaultHistogramAggregation))));
    }

    @Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
    public enum ExporterDefaultHistogramAggregation {

        EXPLICIT_BUCKET_HISTOGRAM("explicit_bucket_histogram"),
        BASE_2_EXPONENTIAL_BUCKET_HISTOGRAM("base2_exponential_bucket_histogram");
        private final String value;
        private final static Map<String, OtlpHttpMetricExporterModel.ExporterDefaultHistogramAggregation> CONSTANTS = new HashMap<String, OtlpHttpMetricExporterModel.ExporterDefaultHistogramAggregation>();

        static {
            for (OtlpHttpMetricExporterModel.ExporterDefaultHistogramAggregation c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ExporterDefaultHistogramAggregation(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OtlpHttpMetricExporterModel.ExporterDefaultHistogramAggregation fromValue(String value) {
            OtlpHttpMetricExporterModel.ExporterDefaultHistogramAggregation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
    public enum ExporterTemporalityPreference {

        CUMULATIVE("cumulative"),
        DELTA("delta"),
        LOW_MEMORY("low_memory");
        private final String value;
        private final static Map<String, OtlpHttpMetricExporterModel.ExporterTemporalityPreference> CONSTANTS = new HashMap<String, OtlpHttpMetricExporterModel.ExporterTemporalityPreference>();

        static {
            for (OtlpHttpMetricExporterModel.ExporterTemporalityPreference c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ExporterTemporalityPreference(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OtlpHttpMetricExporterModel.ExporterTemporalityPreference fromValue(String value) {
            OtlpHttpMetricExporterModel.ExporterTemporalityPreference constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
