/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordExporterFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.BatchLogRecordProcessor;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordProcessor;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SimpleLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessorBuilder;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class LogRecordProcessorFactory
implements Factory<LogRecordProcessor, io.opentelemetry.sdk.logs.LogRecordProcessor> {
    private static final LogRecordProcessorFactory INSTANCE = new LogRecordProcessorFactory();

    private LogRecordProcessorFactory() {
    }

    static LogRecordProcessorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.logs.LogRecordProcessor create(@Nullable LogRecordProcessor model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model == null) {
            return io.opentelemetry.sdk.logs.LogRecordProcessor.composite((io.opentelemetry.sdk.logs.LogRecordProcessor[])new io.opentelemetry.sdk.logs.LogRecordProcessor[0]);
        }
        BatchLogRecordProcessor batchModel = model.getBatch();
        if (batchModel != null) {
            LogRecordExporter exporterModel = batchModel.getExporter();
            if (exporterModel == null) {
                return io.opentelemetry.sdk.logs.LogRecordProcessor.composite((io.opentelemetry.sdk.logs.LogRecordProcessor[])new io.opentelemetry.sdk.logs.LogRecordProcessor[0]);
            }
            BatchLogRecordProcessorBuilder builder = io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor.builder((io.opentelemetry.sdk.logs.export.LogRecordExporter)LogRecordExporterFactory.getInstance().create(exporterModel, spiHelper, closeables));
            if (batchModel.getExportTimeout() != null) {
                builder.setExporterTimeout(Duration.ofMillis(batchModel.getExportTimeout().intValue()));
            }
            if (batchModel.getMaxExportBatchSize() != null) {
                builder.setMaxExportBatchSize(batchModel.getMaxExportBatchSize().intValue());
            }
            if (batchModel.getMaxQueueSize() != null) {
                builder.setMaxQueueSize(batchModel.getMaxQueueSize().intValue());
            }
            if (batchModel.getScheduleDelay() != null) {
                builder.setScheduleDelay(Duration.ofMillis(batchModel.getScheduleDelay().intValue()));
            }
            return (io.opentelemetry.sdk.logs.LogRecordProcessor)FileConfigUtil.addAndReturn(closeables, builder.build());
        }
        SimpleLogRecordProcessor simpleModel = model.getSimple();
        if (simpleModel != null) {
            LogRecordExporter exporterModel = simpleModel.getExporter();
            if (exporterModel == null) {
                return io.opentelemetry.sdk.logs.LogRecordProcessor.composite((io.opentelemetry.sdk.logs.LogRecordProcessor[])new io.opentelemetry.sdk.logs.LogRecordProcessor[0]);
            }
            return FileConfigUtil.addAndReturn(closeables, io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor.create((io.opentelemetry.sdk.logs.export.LogRecordExporter)LogRecordExporterFactory.getInstance().create(exporterModel, spiHelper, closeables)));
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            throw new ConfigurationException("Unrecognized log record processor(s): " + model.getAdditionalProperties().keySet().stream().collect(Collectors.joining(",", "[", "]")));
        }
        return io.opentelemetry.sdk.logs.LogRecordProcessor.composite((io.opentelemetry.sdk.logs.LogRecordProcessor[])new io.opentelemetry.sdk.logs.LogRecordProcessor[0]);
    }
}

