/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.jaeger;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.exporters.jaeger.Adapter;
import io.opentelemetry.exporters.jaeger.proto.api_v2.Collector;
import io.opentelemetry.exporters.jaeger.proto.api_v2.CollectorServiceGrpc;
import io.opentelemetry.exporters.jaeger.proto.api_v2.Model;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdkProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.BatchSpansProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JaegerGrpcSpanExporter
implements SpanExporter {
    private static final Logger logger = Logger.getLogger(JaegerGrpcSpanExporter.class.getName());
    private static final String JAEGER_SERVICE_NAME = "JAEGER_SERVICE_NAME";
    private static final String JAEGER_ENDPOINT = "JAEGER_ENDPOINT";
    private static final String CLIENT_VERSION_KEY = "jaeger.version";
    private static final String CLIENT_VERSION_VALUE = "opentelemetry-java";
    private static final String DEFAULT_JAEGER_ENDPOINT = "localhost:14250";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String UNKNOWN = "unknown";
    private static final String IP_KEY = "ip";
    private static final String IP_DEFAULT = "0.0.0.0";
    private final CollectorServiceGrpc.CollectorServiceBlockingStub blockingStub;
    private final Model.Process process;
    private final ManagedChannel managedChannel;
    private final long deadlineMs;

    private JaegerGrpcSpanExporter(String serviceName, ManagedChannel channel, long deadlineMs) {
        String ipv4;
        String hostname;
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new IllegalArgumentException("Service name must not be null or empty");
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            ipv4 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostname = UNKNOWN;
            ipv4 = IP_DEFAULT;
        }
        Model.KeyValue clientTag = Model.KeyValue.newBuilder().setKey(CLIENT_VERSION_KEY).setVStr(CLIENT_VERSION_VALUE).build();
        Model.KeyValue ipv4Tag = Model.KeyValue.newBuilder().setKey(IP_KEY).setVStr(ipv4).build();
        Model.KeyValue hostnameTag = Model.KeyValue.newBuilder().setKey(HOSTNAME_KEY).setVStr(hostname).build();
        this.process = Model.Process.newBuilder().setServiceName(serviceName).addTags(clientTag).addTags(ipv4Tag).addTags(hostnameTag).build();
        this.managedChannel = channel;
        this.blockingStub = CollectorServiceGrpc.newBlockingStub((Channel)channel);
        this.deadlineMs = deadlineMs;
    }

    public SpanExporter.ResultCode export(Collection<SpanData> spans) {
        Collector.PostSpansRequest request = Collector.PostSpansRequest.newBuilder().setBatch(Model.Batch.newBuilder().addAllSpans(Adapter.toJaeger(spans)).setProcess(this.process).build()).build();
        try {
            CollectorServiceGrpc.CollectorServiceBlockingStub stub = this.blockingStub;
            if (this.deadlineMs > 0L) {
                stub = (CollectorServiceGrpc.CollectorServiceBlockingStub)stub.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS);
            }
            stub.postSpans(request);
            return SpanExporter.ResultCode.SUCCESS;
        }
        catch (Throwable e) {
            return SpanExporter.ResultCode.FAILURE;
        }
    }

    public SpanExporter.ResultCode flush() {
        return SpanExporter.ResultCode.SUCCESS;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void shutdown() {
        try {
            this.managedChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Failed to shutdown the gRPC channel", e);
        }
    }

    private static String getProperty(String name, String defaultValue) {
        String val = System.getProperty(name, System.getenv(name));
        if (val == null || val.isEmpty()) {
            return defaultValue;
        }
        return val;
    }

    public static class Builder {
        private String serviceName;
        private ManagedChannel channel;
        private long deadlineMs = 1000L;

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setChannel(ManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setDeadlineMs(long deadlineMs) {
            this.deadlineMs = deadlineMs;
            return this;
        }

        public static Builder fromEnv() {
            Builder builder = new Builder();
            String host = JaegerGrpcSpanExporter.getProperty(JaegerGrpcSpanExporter.JAEGER_ENDPOINT, JaegerGrpcSpanExporter.DEFAULT_JAEGER_ENDPOINT);
            builder.channel = ManagedChannelBuilder.forTarget((String)host).usePlaintext().build();
            builder.serviceName = JaegerGrpcSpanExporter.getProperty(JaegerGrpcSpanExporter.JAEGER_SERVICE_NAME, JaegerGrpcSpanExporter.UNKNOWN);
            return builder;
        }

        public JaegerGrpcSpanExporter build() {
            return new JaegerGrpcSpanExporter(this.serviceName, this.channel, this.deadlineMs);
        }

        public void install(TracerSdkProvider tracerSdkProvider) {
            BatchSpansProcessor spansProcessor = BatchSpansProcessor.create((SpanExporter)this.build());
            tracerSdkProvider.addSpanProcessor((SpanProcessor)spansProcessor);
        }

        private Builder() {
        }
    }
}

