/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Subscriber;

class TracingSubscriber<T>
extends BasicFuseableSubscriber<T, T> {
    private final Context context;

    TracingSubscriber(Subscriber<? super T> downstream, Context context) {
        super(downstream);
        this.context = context;
    }

    public void onNext(T t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onNext(t);
        }
    }

    public void onError(Throwable t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onError(t);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.context.makeCurrent();){
            this.downstream.onComplete();
        }
    }

    public int requestFusion(int mode) {
        QueueSubscription qs = this.qs;
        if (qs != null) {
            int m;
            this.sourceMode = m = qs.requestFusion(mode);
            return m;
        }
        return 0;
    }

    public T poll() throws Throwable {
        return (T)this.qs.poll();
    }
}

