/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava.v2_0;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndSupport;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.rxjava.v2_0.RxJava2AsyncOperationEndStrategyBuilder;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import io.reactivex.parallel.ParallelFlowable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;

public final class RxJava2AsyncOperationEndStrategy
implements AsyncOperationEndStrategy {
    private static final AttributeKey<Boolean> CANCELED_ATTRIBUTE_KEY = AttributeKey.booleanKey((String)"rxjava.canceled");
    private final boolean captureExperimentalSpanAttributes;

    public static RxJava2AsyncOperationEndStrategy create() {
        return RxJava2AsyncOperationEndStrategy.builder().build();
    }

    public static RxJava2AsyncOperationEndStrategyBuilder builder() {
        return new RxJava2AsyncOperationEndStrategyBuilder();
    }

    RxJava2AsyncOperationEndStrategy(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    public boolean supports(Class<?> returnType) {
        return returnType == Publisher.class || returnType == Completable.class || returnType == Maybe.class || returnType == Single.class || returnType == Observable.class || returnType == Flowable.class || returnType == ParallelFlowable.class;
    }

    public <REQUEST, RESPONSE> Object end(final Instrumenter<REQUEST, RESPONSE> instrumenter, final Context context, final REQUEST request, Object asyncValue, final Class<RESPONSE> responseType) {
        EndOnFirstNotificationConsumer<Object> notificationConsumer = new EndOnFirstNotificationConsumer<Object>(context){

            @Override
            protected void end(Object response, Throwable error) {
                instrumenter.end(context, request, AsyncOperationEndSupport.tryToGetResponse((Class)responseType, (Object)response), error);
            }
        };
        if (asyncValue instanceof Completable) {
            return RxJava2AsyncOperationEndStrategy.endWhenComplete((Completable)asyncValue, notificationConsumer);
        }
        if (asyncValue instanceof Maybe) {
            return RxJava2AsyncOperationEndStrategy.endWhenMaybeComplete((Maybe)asyncValue, notificationConsumer);
        }
        if (asyncValue instanceof Single) {
            return RxJava2AsyncOperationEndStrategy.endWhenSingleComplete((Single)asyncValue, notificationConsumer);
        }
        if (asyncValue instanceof Observable) {
            return RxJava2AsyncOperationEndStrategy.endWhenObservableComplete((Observable)asyncValue, notificationConsumer);
        }
        if (asyncValue instanceof ParallelFlowable) {
            return RxJava2AsyncOperationEndStrategy.endWhenFirstComplete((ParallelFlowable)asyncValue, notificationConsumer);
        }
        return RxJava2AsyncOperationEndStrategy.endWhenPublisherComplete((Publisher)asyncValue, notificationConsumer);
    }

    private static Completable endWhenComplete(Completable completable, EndOnFirstNotificationConsumer<?> notificationConsumer) {
        return completable.doOnEvent(notificationConsumer).doOnDispose(notificationConsumer::onCancelOrDispose);
    }

    private static <T> Maybe<T> endWhenMaybeComplete(Maybe<T> maybe, EndOnFirstNotificationConsumer<?> notificationConsumer) {
        EndOnFirstNotificationConsumer<?> typedConsumer = notificationConsumer;
        return maybe.doOnEvent(typedConsumer).doOnDispose(notificationConsumer::onCancelOrDispose);
    }

    private static <T> Single<T> endWhenSingleComplete(Single<T> single, EndOnFirstNotificationConsumer<?> notificationConsumer) {
        EndOnFirstNotificationConsumer<?> typedConsumer = notificationConsumer;
        return single.doOnEvent(typedConsumer).doOnDispose(notificationConsumer::onCancelOrDispose);
    }

    private static Observable<?> endWhenObservableComplete(Observable<?> observable, EndOnFirstNotificationConsumer<?> notificationConsumer) {
        return observable.doOnComplete(notificationConsumer).doOnError(notificationConsumer).doOnDispose(notificationConsumer::onCancelOrDispose);
    }

    private static ParallelFlowable<?> endWhenFirstComplete(ParallelFlowable<?> parallelFlowable, EndOnFirstNotificationConsumer<?> notificationConsumer) {
        return parallelFlowable.doOnComplete(notificationConsumer).doOnError(notificationConsumer).doOnCancel(notificationConsumer::onCancelOrDispose);
    }

    private static Flowable<?> endWhenPublisherComplete(Publisher<?> publisher, EndOnFirstNotificationConsumer<?> notificationConsumer) {
        return Flowable.fromPublisher(publisher).doOnComplete(notificationConsumer).doOnError(notificationConsumer).doOnCancel(notificationConsumer::onCancelOrDispose);
    }

    private abstract class EndOnFirstNotificationConsumer<T>
    extends AtomicBoolean
    implements Action,
    Consumer<Throwable>,
    BiConsumer<T, Throwable> {
        private static final long serialVersionUID = 1L;
        private final Context context;

        protected EndOnFirstNotificationConsumer(Context context) {
            this.context = context;
        }

        public void run() {
            this.accept(null, null);
        }

        public void onCancelOrDispose() {
            if (this.compareAndSet(false, true)) {
                if (RxJava2AsyncOperationEndStrategy.this.captureExperimentalSpanAttributes) {
                    Span.fromContext((Context)this.context).setAttribute(CANCELED_ATTRIBUTE_KEY, (Object)true);
                }
                this.end(null, null);
            }
        }

        public void accept(Throwable exception) {
            this.accept(null, exception);
        }

        public void accept(T value, Throwable exception) {
            if (this.compareAndSet(false, true)) {
                this.end(value, exception);
            }
        }

        protected abstract void end(Object var1, Throwable var2);
    }
}

