/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.NameAliases;
import java.util.Map;

public class FFDCData
extends GenericData {
    public static final String[] NAMES_LC = new String[]{"datetime", "message", "className", "exceptionName", "probeID", "threadId", "stackTrace", "objectDetails", "sequence", "hostName", "wlpUserDir", "serverName", "type"};
    public static final String[] NAMES_JSON = new String[]{"ibm_datetime", "message", "ibm_className", "ibm_exceptionName", "ibm_probeID", "ibm_threadId", "ibm_stackTrace", "ibm_objectDetails", "ibm_sequence", "host", "ibm_userDir", "ibm_serverName", "type"};
    private static NameAliases jsonLoggingNameAliases = new NameAliases(NAMES_JSON);
    private static NameAliases logstashNameAliases = new NameAliases(NAMES_LC);
    private static NameAliases[] nameAliases = new NameAliases[]{jsonLoggingNameAliases, logstashNameAliases};

    public FFDCData() {
        super(13);
    }

    public static void newJsonLoggingNameAliases(Map<String, String> newAliases) {
        jsonLoggingNameAliases.newAliases(newAliases);
    }

    public static void resetJsonLoggingNameAliases() {
        jsonLoggingNameAliases.resetAliases();
    }

    private void setPair(int index, String s) {
        this.setPair(index, NAMES_JSON[index], s);
    }

    private void setPair(int index, long l) {
        this.setPair(index, NAMES_JSON[index], l);
    }

    public void setDatetime(long l) {
        this.setPair(0, l);
    }

    public void setMessage(String s) {
        this.setPair(1, s);
    }

    public void setClassName(String s) {
        this.setPair(2, s);
    }

    public void setExceptionName(String s) {
        this.setPair(3, s);
    }

    public void setProbeId(String s) {
        this.setPair(4, s);
    }

    public void setThreadId(long l) {
        this.setPair(5, l);
    }

    public void setStacktrace(String s) {
        this.setPair(6, s);
    }

    public void setObjectDetails(String s) {
        this.setPair(7, s);
    }

    public void setSequence(String s) {
        this.setPair(8, s);
    }

    public long getDatetime() {
        return this.getLongValue(0);
    }

    public String getMessage() {
        return this.getStringValue(1);
    }

    public String getClassName() {
        return this.getStringValue(2);
    }

    public String getExceptionName() {
        return this.getStringValue(3);
    }

    public String getProbeId() {
        return this.getStringValue(4);
    }

    public long getThreadId() {
        return this.getLongValue(5);
    }

    public String getStacktrace() {
        return this.getStringValue(6);
    }

    public String getObjectDetails() {
        return this.getStringValue(7);
    }

    public String getSequence() {
        return this.getStringValue(8);
    }

    public static String getDatetimeKey(int format) {
        return FFDCData.nameAliases[format].aliases[0];
    }

    public static String getMessageKey(int format) {
        return FFDCData.nameAliases[format].aliases[1];
    }

    public static String getClassNameKey(int format) {
        return FFDCData.nameAliases[format].aliases[2];
    }

    public static String getExceptionNameKey(int format) {
        return FFDCData.nameAliases[format].aliases[3];
    }

    public static String getProbeIdKey(int format) {
        return FFDCData.nameAliases[format].aliases[4];
    }

    public static String getThreadIdKey(int format) {
        return FFDCData.nameAliases[format].aliases[5];
    }

    public static String getStacktraceKey(int format) {
        return FFDCData.nameAliases[format].aliases[6];
    }

    public static String getObjectDetailsKey(int format) {
        return FFDCData.nameAliases[format].aliases[7];
    }

    public static String getSequenceKey(int format) {
        return FFDCData.nameAliases[format].aliases[8];
    }

    public static String getHostKey(int format) {
        return FFDCData.nameAliases[format].aliases[9];
    }

    public static String getUserDirKey(int format) {
        return FFDCData.nameAliases[format].aliases[10];
    }

    public static String getServerNameKey(int format) {
        return FFDCData.nameAliases[format].aliases[11];
    }

    public static String getTypeKey(int format) {
        return FFDCData.nameAliases[format].aliases[12];
    }
}

