/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.archive;

import com.ibm.ws.kernel.boot.archive.Archive;
import com.ibm.ws.kernel.boot.archive.ArchiveEntryConfig;
import com.ibm.ws.kernel.boot.archive.DirPattern;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DirEntryConfig
implements ArchiveEntryConfig {
    protected final String entryPath;
    protected final File source;
    protected final DirPattern dirPattern;

    public DirEntryConfig(String entryPath, File source, boolean includeByDefault, DirPattern.PatternStrategy strategy) throws IOException {
        entryPath = FileUtils.normalizeEntryPath(entryPath);
        this.entryPath = FileUtils.normalizeDirPath(entryPath);
        if (!source.exists()) {
            throw new FileNotFoundException(source.getAbsolutePath());
        }
        if (!source.isDirectory()) {
            throw new IllegalArgumentException("The source is not a directory.");
        }
        this.source = source;
        this.dirPattern = new DirPattern(includeByDefault, strategy);
    }

    @Override
    public String getEntryPath() {
        return this.entryPath;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    public void include(Pattern pattern) {
        this.dirPattern.getIncludePatterns().add(pattern);
    }

    public void exclude(Pattern pattern) {
        this.dirPattern.getExcludePatterns().add(pattern);
    }

    @Override
    public void configure(Archive archive) throws IOException {
        ArrayList<String> dirContent = new ArrayList<String>();
        this.filterDirectory(dirContent, this.dirPattern, "");
        archive.addDirEntry(this.entryPath, this.source, dirContent);
    }

    protected void filterDirectory(List<String> dirContent, DirPattern dirPattern, String parentPath) throws IOException {
        File[] dirListing;
        File workingDirectory = new File(this.source, parentPath);
        if (workingDirectory.exists() && (dirListing = workingDirectory.listFiles()) != null) {
            for (int i = 0; i < dirListing.length; ++i) {
                File file = dirListing[i];
                boolean includeFileInArchive = dirPattern.getStrategy() == DirPattern.PatternStrategy.IncludePreference ? DirPattern.includePreference(file, dirPattern.getExcludePatterns(), dirPattern.getIncludePatterns(), dirPattern.includeByDefault) : DirPattern.excludePreference(file, dirPattern.getExcludePatterns(), dirPattern.getIncludePatterns(), dirPattern.includeByDefault);
                if (includeFileInArchive) {
                    dirContent.add(parentPath + file.getName());
                }
                if (!file.isDirectory()) continue;
                this.filterDirectory(dirContent, dirPattern, parentPath + file.getName() + "/");
            }
        }
    }
}

