/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.tasks;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.crypto.util.PasswordCipherUtil;
import com.ibm.ws.crypto.util.UnsupportedConfigurationException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.security.utility.SecurityUtilityReturnCodes;
import com.ibm.ws.security.utility.tasks.BaseCommandTask;
import com.ibm.ws.security.utility.utils.ConsoleWrapper;
import com.ibm.ws.security.utility.utils.SAFEncryptionKey;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EncodeTask
extends BaseCommandTask {
    private static final String ATTR_NAME = "name";
    private static final List<Set<String>> EXCLUSIVE_ARGUMENTS = Arrays.asList(new HashSet<String>(Arrays.asList("--key", "--base64Key", "--aesConfigFile")));
    private static final List<String> ARG_TABLE = Arrays.asList("--encoding", "--key", "--listCustom", "--password", "--salt", "--iteration", "--algorithm", "--encoded", "--keyring", "--keyringType", "--keyLabel");
    private static final List<String> BETA_ARG_TABLE = Arrays.asList("--base64Key", "--aesConfigFile");
    private static final List<String> BETA_OPTS = BETA_ARG_TABLE.stream().map(s -> s.startsWith("--") ? s.substring(2) : s).collect(Collectors.toList());

    public EncodeTask(String scriptName) {
        super(scriptName);
    }

    @Override
    public String getTaskName() {
        return "encode";
    }

    @Override
    public String getTaskHelp() {
        String customJSON = null;
        String customAlgorithm = "";
        String customDescription = "";
        try {
            customJSON = PasswordCipherUtil.listCustom();
            if (customJSON != null) {
                JSONArray customInfoArray = (JSONArray)JSON.parse((String)customJSON);
                customAlgorithm = this.getAlgorithm(customInfoArray);
                customDescription = this.getDescription(customInfoArray);
            }
        }
        catch (UnsupportedConfigurationException unsupportedConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getTaskHelp("encode.desc", "encode.usage.options", null, null, "encode.option-key.", "encode.option-desc.", null, null, this.scriptName, customAlgorithm, customDescription);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("encode.desc", true, new Object[0]);
    }

    private String encode(PrintStream stderr, String plaintext, String encodingType, Map<String, String> properties) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        String ret = null;
        try {
            ret = PasswordUtil.encode((String)plaintext, (String)(encodingType == null ? PasswordUtil.getDefaultEncoding() : encodingType), properties);
        }
        catch (InvalidPasswordEncodingException e) {
            e.printStackTrace(stderr);
            throw e;
        }
        catch (UnsupportedCryptoAlgorithmException e) {
            e.printStackTrace(stderr);
            throw e;
        }
        return ret;
    }

    @Override
    public SecurityUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        Map<String, String> argMap = this.parseArgumentList(args);
        if (argMap.containsKey("--listCustom")) {
            String output = PasswordCipherUtil.listCustom();
            if (output == null) {
                output = EncodeTask.getMessage("no.custom.encyption", new Object[0]);
            }
            stdout.println(output);
        } else {
            String encoding = argMap.get("--encoding");
            Map<String, String> props = BaseCommandTask.convertToProperties(argMap, stdout);
            if (this.isZOS()) {
                props = this.getKeyIfSAF(encoding, props);
            } else {
                this.checkForZArgs(props);
            }
            if (!argMap.containsKey("--password")) {
                stdout.println(this.encode(stderr, this.promptForText(stdin, stdout), encoding, props));
            } else {
                stdout.println(this.encode(stderr, argMap.get("--password"), encoding, props));
            }
        }
        return SecurityUtilityReturnCodes.OK;
    }

    private void checkForZArgs(Map<String, String> props) throws IllegalArgumentException {
        String keyring = props.get("keyring");
        String type = props.get("keyring.type");
        String label = props.get("key.label");
        if (keyring != null || type != null || label != null) {
            throw new IllegalArgumentException(EncodeTask.getMessage("saf.arg.not.onZ", new Object[0]));
        }
    }

    private boolean isZOS() {
        boolean isZSeries = false;
        String _osName = System.getProperty("os.name");
        isZSeries = _osName.indexOf("OS/390") != -1 || _osName.indexOf("z/OS") != -1;
        return isZSeries;
    }

    private Map<String, String> getKeyIfSAF(String encoding, Map<String, String> props) throws Exception {
        Map<String, String> p = props;
        String cryptoKey = null;
        String keyring = props.get("keyring");
        String type = props.get("keyring.type");
        String label = props.get("key.label");
        if (encoding != null && encoding.trim().equalsIgnoreCase("aes")) {
            if (!(keyring == null || keyring.isEmpty() || type == null || type.isEmpty() || label == null || label.isEmpty())) {
                SAFEncryptionKey ek = new SAFEncryptionKey(keyring, type, label);
                cryptoKey = ek.getKey();
                p.put("crypto.key", cryptoKey);
            }
        } else if (keyring != null || type != null || label != null) {
            throw new IllegalArgumentException(EncodeTask.getMessage("saf.arg.not.aes", new Object[0]));
        }
        return p;
    }

    private Map<String, String> parseArgumentList(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        String arg = null;
        for (int i = 1; i < args.length; ++i) {
            arg = args[i];
            if (arg.startsWith("--")) {
                if (arg.equals("--notrim") || arg.equals("--listCustom")) {
                    result.put(arg, "true");
                } else {
                    int index = arg.indexOf(61);
                    if (index == -1) {
                        throw new IllegalArgumentException(EncodeTask.getMessage("invalidArg", arg));
                    }
                    String value = null;
                    if (index + 1 < arg.length()) {
                        value = arg.substring(index + 1);
                    }
                    if (!this.isKnownArgument(arg = arg.substring(0, index))) {
                        throw new IllegalArgumentException(EncodeTask.getMessage("invalidArg", arg));
                    }
                    if (value == null) {
                        throw new IllegalArgumentException(EncodeTask.getMessage("missingValue", arg));
                    }
                    result.put(arg, value);
                }
            } else {
                if (result.containsKey("--password")) {
                    throw new IllegalArgumentException(EncodeTask.getMessage("invalidArg", arg));
                }
                result.put("--password", arg);
            }
            this.validateMutuallyExclusiveArgs(arg, result);
        }
        return result;
    }

    @Override
    boolean isKnownArgument(String arg) {
        boolean value = false;
        if (arg != null && !(value = ARG_TABLE.contains(arg)) && ProductInfo.getBetaEdition()) {
            value = BETA_ARG_TABLE.contains(arg);
        }
        return value;
    }

    @Override
    void checkRequiredArguments(String[] args) {
    }

    protected String getAlgorithm(JSONArray customInfoArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < customInfoArray.size(); ++i) {
            JSONObject customInfo = (JSONObject)customInfoArray.get(i);
            sb.append("|").append(customInfo.get((Object)ATTR_NAME));
        }
        return sb.toString();
    }

    protected String getDescription(JSONArray customInfoArray) {
        StringBuffer sb = new StringBuffer();
        sb.append(EncodeTask.getMessage("encode.option-custom.encryption", new Object[0]));
        for (int i = 0; i < customInfoArray.size(); ++i) {
            JSONObject customInfo = (JSONObject)customInfoArray.get(i);
            String name = (String)customInfo.get((Object)ATTR_NAME);
            sb.append(EncodeTask.getMessage("encode.option-desc.custom.feature", name));
            sb.append((String)customInfo.get((Object)"featurename"));
            sb.append(EncodeTask.getMessage("encode.option-desc.custom.description", name));
            sb.append((String)customInfo.get((Object)"description"));
        }
        return sb.toString();
    }

    @Override
    protected List<String> getBetaOptions() {
        return BETA_OPTS;
    }

    @Override
    protected List<Set<String>> getExclusiveArguments() {
        return EXCLUSIVE_ARGUMENTS;
    }
}

