/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.tasks;

import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.crypto.util.AesConfigFileParser;
import com.ibm.ws.crypto.util.UnsupportedConfigurationException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.security.utility.SecurityUtilityTask;
import com.ibm.ws.security.utility.utils.CommandUtils;
import com.ibm.ws.security.utility.utils.ConsoleWrapper;
import com.ibm.wsspi.security.crypto.PasswordEncryptException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class BaseCommandTask
implements SecurityUtilityTask {
    public static final String NL = System.getProperty("line.separator");
    protected final String scriptName;
    static final String ARG_AES_CONFIG_FILE = "--aesConfigFile";
    static final String ARG_PASSWORD_BASE64_KEY = "--passwordBase64Key";
    static final String ARG_PASSWORD_KEY = "--passwordKey";
    static final String ARG_PASSWORD_ENCODING = "--passwordEncoding";
    static final String ARG_KEY_LABEL = "--keyLabel";
    static final String ARG_KEYRING_TYPE = "--keyringType";
    static final String ARG_KEYRING = "--keyring";
    static final String ARG_HASH_ENCODED = "--encoded";
    static final String ARG_HASH_ALGORITHM = "--algorithm";
    static final String ARG_HASH_ITERATION = "--iteration";
    static final String ARG_HASH_SALT = "--salt";
    static final String ARG_LIST_CUSTOM = "--listCustom";
    static final String ARG_NO_TRIM = "--notrim";
    static final String ARG_PASSWORD = "--password";
    static final String ARG_ENCODING = "--encoding";
    public static final String ARG_BASE64_KEY = "--base64Key";
    public static final String ARG_KEY = "--key";

    public BaseCommandTask(String scriptName) {
        this.scriptName = scriptName;
    }

    protected static String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    protected String getOption(String key, boolean forceFormat, Object ... args) {
        return CommandUtils.getOption(key, forceFormat, args);
    }

    protected String buildScriptOptions(String optionKeyPrefix, String optionDescPrefix) {
        StringBuilder scriptOptions = new StringBuilder();
        if (optionKeyPrefix != null && !optionKeyPrefix.isEmpty() && optionDescPrefix != null && !optionDescPrefix.isEmpty()) {
            Enumeration<String> keys = CommandUtils.getOptions().getKeys();
            TreeSet<String> optionKeys = new TreeSet<String>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(optionKeyPrefix) || this.isBetaOption(key)) continue;
                optionKeys.add(key);
            }
            if (optionKeys.size() > 0) {
                for (String optionKey : optionKeys) {
                    String option = optionKey.substring(optionKeyPrefix.length());
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionKey));
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionDescPrefix + option));
                    scriptOptions.append(NL);
                }
            }
        }
        return scriptOptions.toString();
    }

    protected String getTaskHelp(String desc, String usage, String requiredKeyPrefix, String requiredDescPrefix, String optionKeyPrefix, String optionDescPrefix, String addonKey, String footer, Object ... args) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(this.getOption("global.usage", false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(usage, false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("global.description", false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(desc, false, new Object[0]));
        scriptHelp.append(NL);
        String requireds = this.buildScriptOptions(requiredKeyPrefix, requiredDescPrefix);
        if (!requireds.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.required", false, new Object[0]));
            scriptHelp.append(requireds);
        }
        scriptHelp.append(NL);
        String options = this.buildScriptOptions(optionKeyPrefix, optionDescPrefix);
        if (!options.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.options", false, new Object[0]));
            scriptHelp.append(options);
        }
        if (addonKey != null && !addonKey.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption(addonKey, false, new Object[0]));
        }
        if (footer != null && !footer.isEmpty()) {
            scriptHelp.append(footer);
        }
        return MessageFormat.format(scriptHelp.toString(), args);
    }

    protected String getValue(String arg) {
        String[] split = arg.split("=");
        if (split.length == 1) {
            return null;
        }
        if (split.length == 2) {
            return split[1];
        }
        StringBuffer value = new StringBuffer();
        for (int i = 1; i < split.length; ++i) {
            value.append(split[i]);
            if (i >= split.length - 1) continue;
            value.append("=");
        }
        return value.toString();
    }

    protected String promptForPassword(ConsoleWrapper stdin, PrintStream stdout) {
        return this.promptForText(stdin, stdout, "password.enterText", "password.reenterText", "password.readError", "password.entriesDidNotMatch");
    }

    protected String promptForText(ConsoleWrapper stdin, PrintStream stdout) {
        return this.promptForText(stdin, stdout, "encode.enterText", "encode.reenterText", "encode.readError", "encode.entriesDidNotMatch");
    }

    private String promptForText(ConsoleWrapper stdin, PrintStream stdout, String enterText, String reenterText, String readError, String entriesDidNotMatch) {
        String read1 = stdin.readMaskedText(BaseCommandTask.getMessage(enterText, new Object[0]) + " ");
        String read2 = stdin.readMaskedText(BaseCommandTask.getMessage(reenterText, new Object[0]) + " ");
        if (read1 == null && read2 == null) {
            throw new IllegalArgumentException("Unable to read either entry. Aborting prompt.");
        }
        if (read1 == null || read2 == null) {
            stdout.println(BaseCommandTask.getMessage(readError, new Object[0]));
            return this.promptForText(stdin, stdout, enterText, reenterText, readError, entriesDidNotMatch);
        }
        if (read1.equals(read2)) {
            return read1;
        }
        stdout.println(BaseCommandTask.getMessage(entriesDidNotMatch, new Object[0]));
        return this.promptForText(stdin, stdout, enterText, reenterText, readError, entriesDidNotMatch);
    }

    protected String getArgumentValue(String arg, String[] args, String defalt, String passwordArgKey, ConsoleWrapper stdin, PrintStream stdout) {
        for (int i = 1; i < args.length; ++i) {
            String key = args[i].split("=")[0];
            if (!key.equals(arg)) continue;
            String value = this.getValue(args[i]);
            if (arg.equals(passwordArgKey) && value == null) {
                return this.promptForPassword(stdin, stdout);
            }
            return value;
        }
        return defalt;
    }

    abstract boolean isKnownArgument(String var1);

    abstract void checkRequiredArguments(String[] var1) throws IllegalArgumentException;

    protected void validateArgumentList(String[] args, List<String> keyOnlyArgs) {
        this.checkRequiredArguments(args);
        HashMap<String, String> inputMap = new HashMap<String, String>();
        for (int i = 1; i < args.length; ++i) {
            String argPair = args[i];
            String arg = null;
            String value = null;
            if (argPair.contains("=")) {
                arg = argPair.split("=")[0];
                value = this.getValue(argPair);
            } else {
                arg = argPair;
            }
            if (!this.isKnownArgument(arg)) {
                throw new IllegalArgumentException(BaseCommandTask.getMessage("invalidArg", arg));
            }
            if (!keyOnlyArgs.contains(arg) && value == null) {
                throw new IllegalArgumentException(BaseCommandTask.getMessage("missingValue", arg));
            }
            inputMap.put(arg, value);
            this.validateMutuallyExclusiveArgs(arg, inputMap);
        }
    }

    protected static Map<String, String> convertToProperties(Map<String, String> argMap, PrintStream stdout) throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        String value = argMap.get(ARG_KEY);
        if (value != null) {
            props.put("crypto.key", value);
        }
        if ((value = argMap.get(ARG_PASSWORD_KEY)) != null) {
            props.put("crypto.key", value);
        }
        if (argMap.containsKey(ARG_NO_TRIM)) {
            props.put("option.notrim", "true");
        }
        if ((value = argMap.get(ARG_HASH_SALT)) != null) {
            props.put("hash.salt", value);
        }
        if ((value = argMap.get(ARG_HASH_ITERATION)) != null) {
            props.put("hash.iteration", value);
        }
        if ((value = argMap.get(ARG_HASH_ALGORITHM)) != null) {
            props.put("hash.algorithm", value);
        }
        if ((value = argMap.get(ARG_HASH_ENCODED)) != null) {
            props.put("hash.encoded", value);
        }
        if ((value = argMap.get(ARG_KEYRING)) != null) {
            props.put("keyring", value);
        }
        if ((value = argMap.get(ARG_KEYRING_TYPE)) != null) {
            props.put("keyring.type", value);
        }
        if ((value = argMap.get(ARG_KEY_LABEL)) != null) {
            props.put("key.label", value);
        }
        if ((value = argMap.get(ARG_BASE64_KEY)) != null) {
            props.put("aes.key", value);
        }
        if ((value = argMap.get(ARG_PASSWORD_BASE64_KEY)) != null) {
            props.put("aes.key", value);
        }
        if ((value = argMap.get(ARG_AES_CONFIG_FILE)) != null) {
            BaseCommandTask.handleAesConfigFile(props, value);
        }
        return props;
    }

    protected static void handleAesConfigFile(HashMap<String, String> props, String value) throws PasswordEncryptException {
        try {
            props.putAll(AesConfigFileParser.parseAesEncryptionFile((String)value));
        }
        catch (PasswordEncryptException e) {
            throw e;
        }
        catch (UnsupportedCryptoAlgorithmException e) {
            throw new IllegalArgumentException(BaseCommandTask.getMessage("encode.aesConfigFileMissingEncryptionVariables", "wlp.aes.encryption.key", "wlp.password.encryption.key"), e);
        }
        catch (UnsupportedConfigurationException e) {
            throw new IllegalArgumentException(BaseCommandTask.getMessage("encode.aesConfigFileEncryptionAmbiguous", "wlp.aes.encryption.key", "wlp.password.encryption.key"), e);
        }
    }

    protected void validateMutuallyExclusiveArgs(String arg, Map<String, String> inputMap) {
        for (Set<String> group : this.getExclusiveArguments()) {
            if (!group.contains(arg)) continue;
            for (String key : group) {
                if (key.equals(arg) || !inputMap.containsKey(key)) continue;
                throw new IllegalArgumentException(BaseCommandTask.getMessage("exclusiveArg", key, arg));
            }
        }
    }

    protected List<String> getBetaOptions() {
        return new ArrayList<String>();
    }

    private boolean isBetaOption(String option) {
        if (ProductInfo.getBetaEdition()) {
            return false;
        }
        return this.getBetaOptions().stream().anyMatch(p -> option.endsWith((String)p));
    }

    protected List<Set<String>> getExclusiveArguments() {
        return new ArrayList<Set<String>>();
    }
}

