/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.util;

import com.ibm.ws.crypto.util.HashedData;
import com.ibm.ws.crypto.util.InvalidPasswordCipherException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordHashGenerator {
    private static final String OLD_DEFAULT_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final String LATEST_DEFAULT_ALGORITHM = "PBKDF2WithHmacSHA512";
    private static final int DEFAULT_ITERATION = 6384;
    private static final int DEFAULT_OUTPUT_LENGTH = 256;
    private static final int SALT_LENGTH = 32;
    private static final Class<?> CLASS_NAME = PasswordHashGenerator.class;
    private static final Logger logger = Logger.getLogger(CLASS_NAME.getCanonicalName());

    public static byte[] generateSalt(String saltString) {
        byte[] output = null;
        if (saltString == null || saltString.length() < 1) {
            output = new byte[32];
            SecureRandom rand = new SecureRandom();
            rand.setSeed(rand.generateSeed(32));
            rand.nextBytes(output);
        } else {
            output = saltString.getBytes(StandardCharsets.UTF_8);
        }
        return output;
    }

    public static int getDefaultIteration() {
        return 6384;
    }

    public static String getDefaultAlgorithm() {
        return OLD_DEFAULT_ALGORITHM;
    }

    public static int getDefaultOutputLength() {
        return 256;
    }

    public static byte[] digest(HashedData input) throws InvalidPasswordCipherException {
        if (input != null) {
            return PasswordHashGenerator.digest(input.getPlain(), input.getSalt(), input.getAlgorithm(), input.getIteration(), input.getOutputLength());
        }
        throw new InvalidPasswordCipherException("HashedData object is null.");
    }

    public static byte[] digest(char[] plainBytes, byte[] salt, String algorithm, int iteration, int length) throws InvalidPasswordCipherException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("algorithm : " + algorithm + " iteration : " + iteration);
            logger.fine("input length: " + plainBytes.length);
            logger.fine("salt length: " + salt.length);
            logger.fine("output length: " + length);
        }
        byte[] oBytes = null;
        if (plainBytes != null && plainBytes.length > 0 && algorithm != null && algorithm.length() > 0 && iteration > 0) {
            long begin = 0L;
            if (logger.isLoggable(Level.FINE)) {
                begin = System.nanoTime();
            }
            try {
                SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
                PBEKeySpec ks = new PBEKeySpec(plainBytes, salt, iteration, length);
                SecretKey s = skf.generateSecret(ks);
                oBytes = s.getEncoded();
            }
            catch (Exception e) {
                throw (InvalidPasswordCipherException)new InvalidPasswordCipherException(e.getMessage()).initCause(e);
            }
            if (logger.isLoggable(Level.FINE)) {
                long elapsed = System.nanoTime() - begin;
                logger.fine("Elapsed time : " + elapsed + " ns " + elapsed / 1000000L + " ms");
            }
        }
        if (logger.isLoggable(Level.FINE) && oBytes != null) {
            logger.fine("digest length: " + oBytes.length);
            logger.fine(PasswordHashGenerator.hexDump(oBytes));
        }
        return oBytes;
    }

    public static String hexDump(byte[] input) {
        String outputString = null;
        if (input != null) {
            int length = input.length;
            StringBuffer output = new StringBuffer();
            output.append("\n");
            for (int i = 0; i < length; i += 16) {
                int j;
                output.append(String.format("%04x: ", i));
                for (j = 0; j < 16; ++j) {
                    if (j + i < length) {
                        output.append(String.format("%02X ", input[j + i]));
                    } else {
                        output.append("   ");
                    }
                    if (j != 7) continue;
                    output.append(" ");
                }
                output.append(" : ");
                for (j = i; j < i + 16 && j < length; ++j) {
                    String str = ".";
                    str = input[j] > 32 && Character.isDefined(input[j]) ? new String(input, j, 1) : ".";
                    output.append(str);
                }
                output.append("\n");
            }
            outputString = output.toString();
        }
        return outputString;
    }
}

