/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.kernel;

import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.repository.common.enums.InstallPolicy;
import com.ibm.ws.repository.resolver.internal.kernel.CapabilityMatching;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverRequirement;
import com.ibm.ws.repository.resources.EsaResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.Version;

public class KernelResolverEsa
implements ProvisioningFeatureDefinition {
    private final EsaResource esaResource;

    public KernelResolverEsa(EsaResource esaResource) {
        if (esaResource == null) {
            throw new NullPointerException();
        }
        this.esaResource = esaResource;
    }

    public EsaResource getResource() {
        return this.esaResource;
    }

    public String getSymbolicName() {
        return this.esaResource.getProvideFeature();
    }

    public String getFeatureName() {
        String name = this.esaResource.getShortName();
        if (name == null) {
            name = this.esaResource.getProvideFeature();
        }
        return name;
    }

    public EnumSet<ProcessType> getProcessTypes() {
        return EnumSet.of(ProcessType.SERVER);
    }

    public Visibility getVisibility() {
        if (this.esaResource.getVisibility() == null) {
            return Visibility.PRIVATE;
        }
        switch (this.esaResource.getVisibility()) {
            case PUBLIC: {
                return Visibility.PUBLIC;
            }
            case PROTECTED: {
                return Visibility.PROTECTED;
            }
            case INSTALL: {
                return Visibility.INSTALL;
            }
            case PRIVATE: {
                return Visibility.PRIVATE;
            }
        }
        throw new IllegalArgumentException("Invalid visibility: " + this.esaResource.getVisibility());
    }

    public String getBundleRepositoryType() {
        return "";
    }

    public Collection<FeatureResource> getConstituents(SubsystemContentType type) {
        if (type != SubsystemContentType.FEATURE_TYPE) {
            return Collections.emptySet();
        }
        if (this.esaResource.getRequireFeatureWithTolerates() == null) {
            return Collections.emptySet();
        }
        ArrayList<FeatureResource> result = new ArrayList<FeatureResource>();
        for (Map.Entry requirement : this.esaResource.getRequireFeatureWithTolerates().entrySet()) {
            String symbolicName = (String)requirement.getKey();
            List<String> tolerates = (List<String>)requirement.getValue();
            if (tolerates == null) {
                tolerates = Collections.emptyList();
            }
            result.add(new KernelResolverRequirement(symbolicName, tolerates));
        }
        return result;
    }

    public String getIbmShortName() {
        return this.esaResource.getShortName();
    }

    public boolean isAutoFeature() {
        return this.esaResource.getInstallPolicy() == InstallPolicy.WHEN_SATISFIED;
    }

    public boolean isCapabilitySatisfied(Collection<ProvisioningFeatureDefinition> features) {
        return CapabilityMatching.matchCapability(this.esaResource.getProvisionCapability(), features).isCapabilitySatisfied();
    }

    public Version getVersion() {
        try {
            return Version.parseVersion((String)this.esaResource.getVersion());
        }
        catch (IllegalArgumentException ex) {
            return Version.emptyVersion;
        }
    }

    public boolean isSingleton() {
        return this.esaResource.isSingleton();
    }

    public String getApiServices() {
        throw new UnsupportedOperationException();
    }

    public AppForceRestart getAppForceRestart() {
        throw new UnsupportedOperationException();
    }

    public boolean isKernel() {
        return false;
    }

    public File getFeatureChecksumFile() {
        throw new UnsupportedOperationException();
    }

    public File getFeatureDefinitionFile() {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String arg0, Locale arg1) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Collection<HeaderElementDefinition> getHeaderElements(String arg0) {
        throw new UnsupportedOperationException();
    }

    public int getIbmFeatureVersion() {
        return 0;
    }

    public Collection<String> getIcons() {
        throw new UnsupportedOperationException();
    }

    public Collection<File> getLocalizationFiles() {
        throw new UnsupportedOperationException();
    }

    public String getSupersededBy() {
        throw new UnsupportedOperationException();
    }

    public boolean isSuperseded() {
        throw new UnsupportedOperationException();
    }

    public boolean isSupportedFeatureVersion() {
        throw new UnsupportedOperationException();
    }

    public List<String> getPlatformNames() {
        return this.esaResource.getPlatforms() == null ? new ArrayList<String>() : new ArrayList(this.esaResource.getPlatforms());
    }

    public String getPlatformName() {
        return !this.getPlatformNames().isEmpty() ? this.getPlatformNames().get(0) : null;
    }

    public boolean isVersionless() {
        if (!this.getVisibility().equals((Object)Visibility.PUBLIC) || this.getPlatformName() != null) {
            return false;
        }
        String shortName = this.getIbmShortName();
        if (shortName == null || !shortName.equals(this.getFeatureName())) {
            return false;
        }
        return this.getSymbolicName().contains(".versionless.") && !this.getSymbolicName().contains(".internal.");
    }

    public boolean isConvenience() {
        return false;
    }

    public boolean isCompatibility() {
        if (!this.getVisibility().equals((Object)Visibility.PRIVATE)) {
            return false;
        }
        if (this.getIbmShortName() != null) {
            return false;
        }
        return this.getPlatformName() != null;
    }
}

