/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;

public class Walker {
    public static <T> void walkBreadthFirst(T root, VisitFunction<? super T> visit, Function<T, Collection<? extends T>> getChildren) {
        Walker.walkCollectionBreadthFirst(Collections.singleton(root), visit, getChildren);
    }

    public static <T> void walkCollectionBreadthFirst(Collection<? extends T> roots, VisitFunction<? super T> visit, Function<T, Collection<? extends T>> getChildren) {
        ArrayDeque<WalkElement<T>> queue = new ArrayDeque<WalkElement<T>>();
        for (T root : roots) {
            queue.add(new WalkElement<T>(root, null));
        }
        while (!queue.isEmpty()) {
            WalkElement current = (WalkElement)queue.pollFirst();
            WalkDecision decision = visit.apply(current.parent(), current.item());
            if (decision != WalkDecision.WALK_CHILDREN) continue;
            for (T child : getChildren.apply(current.item())) {
                if (current.hasAncestor(child)) continue;
                queue.addLast(new WalkElement<T>(child, current));
            }
        }
    }

    public static <T> void walkDepthFirst(T root, VisitFunction<? super T> visit, Function<T, Collection<? extends T>> getChildren) {
        Walker.walkDepthFirst(root, null, visit, getChildren, new HashSet());
    }

    private static <T> void walkDepthFirst(T item, T parent, VisitFunction<? super T> visit, Function<T, Collection<? extends T>> getChildren, HashSet<T> stack) {
        stack.add(item);
        WalkDecision descision = visit.apply(parent, item);
        if (descision == WalkDecision.WALK_CHILDREN) {
            for (T child : getChildren.apply(item)) {
                if (stack.contains(child)) continue;
                Walker.walkDepthFirst(child, item, visit, getChildren, stack);
            }
        }
        stack.remove(item);
    }

    public static interface VisitFunction<T> {
        public WalkDecision apply(T var1, T var2);
    }

    private static class WalkElement<T> {
        private final T item;
        private final WalkElement<T> parent;

        public WalkElement(T item, WalkElement<T> parent) {
            this.item = item;
            this.parent = parent;
        }

        public T item() {
            return this.item;
        }

        public T parent() {
            return this.parent == null ? null : (T)this.parent.item();
        }

        public boolean hasAncestor(T search) {
            WalkElement<T> current = this;
            while (current != null) {
                if (current.item.equals(search)) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }
    }

    public static enum WalkDecision {
        WALK_CHILDREN,
        IGNORE_CHILDREN;

    }
}

