/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AtomicServiceReference<T> {
    private final String referenceName;
    private final AtomicReference<ComponentContext> contextRef = new AtomicReference();
    private final PriorityQueue<ReferenceTuple<T>> references = new PriorityQueue(2);
    private final ReadWriteLock referencesLock = new ReentrantReadWriteLock();
    static final long serialVersionUID = -5371852544883285473L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AtomicServiceReference(String name) {
        this.referenceName = name;
    }

    public void activate(ComponentContext context) {
        this.contextRef.set(context);
    }

    public void deactivate(ComponentContext context) {
        this.contextRef.set(null);
        this.referencesLock.writeLock().lock();
        try {
            this.references.forEach((Consumer<ReferenceTuple<T>>)((Consumer<ReferenceTuple>)r -> r.locatedService.set(null)));
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setReference(ServiceReference<T> reference) {
        this.referencesLock.writeLock().lock();
        try {
            if (reference == null) {
                boolean isEmpty = this.references.isEmpty();
                this.references.clear();
                boolean bl = !isEmpty;
                return bl;
            }
            Iterator<ReferenceTuple<T>> iRefs = this.references.iterator();
            ReferenceTuple<T> highest = null;
            ReferenceTuple<T> existing = null;
            while (iRefs.hasNext()) {
                ReferenceTuple<T> next = iRefs.next();
                if (highest == null) {
                    highest = next;
                }
                if (!reference.equals(next.serviceRef)) continue;
                iRefs.remove();
                existing = next;
                break;
            }
            ReferenceTuple<T> newTuple = existing != null ? existing : new ReferenceTuple<T>(reference);
            this.references.add(newTuple);
            boolean bl = highest != null && highest != this.references.peek();
            return bl;
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsetReference(ServiceReference<T> reference) {
        this.referencesLock.writeLock().lock();
        try {
            if (reference == null) {
                boolean bl = false;
                return bl;
            }
            Iterator<ReferenceTuple<T>> iRefs = this.references.iterator();
            ReferenceTuple<T> highest = null;
            while (iRefs.hasNext()) {
                ReferenceTuple<T> next = iRefs.next();
                if (highest == null) {
                    highest = next;
                }
                if (!reference.equals(next.serviceRef)) continue;
                iRefs.remove();
                break;
            }
            boolean bl = highest != null && highest.serviceRef.equals(reference);
            return bl;
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
    }

    public ServiceReference<T> getReference() {
        this.referencesLock.readLock().lock();
        try {
            ReferenceTuple<T> highest = this.references.peek();
            ServiceReference serviceReference = highest == null ? null : highest.serviceRef;
            return serviceReference;
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
    }

    public T getService() {
        return this.getService(false);
    }

    public T getServiceWithException() {
        return this.getService(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getService(boolean throwException) {
        ReferenceTuple<T> highest;
        final ComponentContext currentContext = this.contextRef.get();
        if (currentContext == null) {
            if (throwException) {
                throw new IllegalStateException("Not activated yet: " + this.toString());
            }
            return null;
        }
        this.referencesLock.readLock().lock();
        try {
            highest = this.references.peek();
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        if (highest == null) {
            if (throwException) {
                throw new IllegalStateException("No service reference available: " + this.toString());
            }
            return null;
        }
        Object svc = highest.locatedService.get();
        if (svc != null) {
            return svc;
        }
        SecurityManager sm = System.getSecurityManager();
        svc = sm != null ? AccessController.doPrivileged(new PrivilegedAction<T>(){
            static final long serialVersionUID = 7508872053942085389L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public T run() {
                return currentContext.locateService(AtomicServiceReference.this.referenceName, highest.serviceRef);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.kernel.service.utils.AtomicServiceReference$1", 1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
            }
        }) : currentContext.locateService(this.referenceName, highest.serviceRef);
        if (svc == null && throwException) {
            throw new IllegalStateException("Located service is null," + this.toString());
        }
        highest.locatedService.set(svc);
        return svc;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.referenceName + "," + this.references + "]";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.kernel.service.utils.AtomicServiceReference", AtomicServiceReference.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ReferenceTuple<T>
    implements Comparable<ReferenceTuple<T>> {
        final ServiceReference<T> serviceRef;
        final AtomicReference<T> locatedService = new AtomicReference();
        static final long serialVersionUID = -551585656540776204L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ReferenceTuple(ServiceReference<T> ref) {
            this.serviceRef = ref;
        }

        public String toString() {
            return "ref=" + this.serviceRef + ",svc=" + this.locatedService;
        }

        @Override
        public int compareTo(ReferenceTuple<T> o) {
            return -this.serviceRef.compareTo(o.serviceRef);
        }

        public boolean equals(Object o) {
            if (o instanceof ReferenceTuple) {
                return this.serviceRef.equals(((ReferenceTuple)o).serviceRef);
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.kernel.service.utils.AtomicServiceReference$ReferenceTuple", ReferenceTuple.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }
}

