/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import wlp.lib.extract.Content;
import wlp.lib.extract.ContentLicenseProvider;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;

public class ZipLicenseProvider
implements LicenseProvider {
    private static LicenseProvider instance;

    public static ReturnCode buildInstance(ZipFile zipFile, String laPrefix, String liPrefix) {
        JarFile jar;
        try {
            jar = ZipLicenseProvider.getJarFile(zipFile);
        }
        catch (IOException e) {
            return new ReturnCode(3);
        }
        ReturnCode status = ContentLicenseProvider.buildInstance(new Content.JarContent(jar), laPrefix, liPrefix);
        instance = ContentLicenseProvider.getInstance();
        return status;
    }

    public static LicenseProvider getInstance() {
        return instance;
    }

    private static JarFile getJarFile(ZipFile zipFile) throws IOException {
        if (zipFile instanceof JarFile) {
            return (JarFile)zipFile;
        }
        if (zipFile == null) {
            return null;
        }
        return new JarFile(zipFile.getName());
    }

    public static LicenseProvider createInstance(ZipFile zipFile, String laPrefix) {
        JarFile jar = null;
        try {
            jar = ZipLicenseProvider.getJarFile(zipFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (jar == null) {
            return null;
        }
        return ContentLicenseProvider.createInstance(new Content.JarContent(jar), laPrefix);
    }

    @Override
    public InputStream getLicenseAgreement() {
        return null;
    }

    @Override
    public InputStream getLicenseInformation() {
        return null;
    }

    @Override
    public String getProgramName() {
        return null;
    }

    @Override
    public String getLicenseName() {
        return null;
    }
}

