/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.json.JsonNumber;
import javax.json.JsonValue;

abstract class JsonNumberImpl
implements JsonNumber {
    private static final String MAX_BIGINTEGER_SCALE = "org.eclipse.parsson.maxBigIntegerScale";
    private static final int DEFAULT_MAX_BIGINTEGER_SCALE = 100000;

    JsonNumberImpl() {
    }

    static JsonNumber getJsonNumber(int num) {
        return new JsonIntNumber(num);
    }

    static JsonNumber getJsonNumber(long num) {
        return new JsonLongNumber(num);
    }

    static JsonNumber getJsonNumber(BigInteger value) {
        return new JsonBigDecimalNumber(new BigDecimal(value));
    }

    static JsonNumber getJsonNumber(double value) {
        return new JsonBigDecimalNumber(BigDecimal.valueOf(value));
    }

    static JsonNumber getJsonNumber(BigDecimal value) {
        return new JsonBigDecimalNumber(value);
    }

    public boolean isIntegral() {
        return this.bigDecimalValue().scale() == 0;
    }

    public int intValue() {
        return this.bigDecimalValue().intValue();
    }

    public int intValueExact() {
        return this.bigDecimalValue().intValueExact();
    }

    public long longValue() {
        return this.bigDecimalValue().longValue();
    }

    public long longValueExact() {
        return this.bigDecimalValue().longValueExact();
    }

    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    public BigInteger bigIntegerValue() {
        int limit;
        BigDecimal bd = this.bigDecimalValue();
        int scale = Math.abs(bd.scale());
        if (scale <= (limit = JsonNumberImpl.propertyStringToInt(MAX_BIGINTEGER_SCALE, 100000))) {
            return bd.toBigInteger();
        }
        throw new UnsupportedOperationException(String.format("Scale value %d of this BigInteger exceeded maximal allowed value of %d", scale, limit));
    }

    public BigInteger bigIntegerValueExact() {
        int limit;
        BigDecimal bd = this.bigDecimalValue();
        int scale = Math.abs(bd.scale());
        if (scale <= (limit = JsonNumberImpl.propertyStringToInt(MAX_BIGINTEGER_SCALE, 100000))) {
            return bd.toBigIntegerExact();
        }
        throw new UnsupportedOperationException(String.format("Scale value %d of this BigInteger exceeded maximal allowed value of %d", scale, limit));
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonNumber)) {
            return false;
        }
        JsonNumber other = (JsonNumber)obj;
        return this.bigDecimalValue().equals(other.bigDecimalValue());
    }

    public String toString() {
        return this.bigDecimalValue().toString();
    }

    static int propertyStringToInt(final String propertyName, final int defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(propertyName, defaultValue);
            }
        });
    }

    private static final class JsonBigDecimalNumber
    extends JsonNumberImpl {
        private final BigDecimal bigDecimal;

        JsonBigDecimalNumber(BigDecimal value) {
            this.bigDecimal = value;
        }

        public BigDecimal bigDecimalValue() {
            return this.bigDecimal;
        }
    }

    private static final class JsonLongNumber
    extends JsonNumberImpl {
        private final long num;
        private BigDecimal bigDecimal;

        JsonLongNumber(long num) {
            this.num = num;
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public long longValueExact() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        public BigDecimal bigDecimalValue() {
            BigDecimal bd = this.bigDecimal;
            if (bd == null) {
                this.bigDecimal = bd = new BigDecimal(this.num);
            }
            return bd;
        }

        @Override
        public String toString() {
            return Long.toString(this.num);
        }
    }

    private static final class JsonIntNumber
    extends JsonNumberImpl {
        private final int num;
        private BigDecimal bigDecimal;

        JsonIntNumber(int num) {
            this.num = num;
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public int intValue() {
            return this.num;
        }

        @Override
        public int intValueExact() {
            return this.num;
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public long longValueExact() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        public BigDecimal bigDecimalValue() {
            BigDecimal bd = this.bigDecimal;
            if (bd == null) {
                this.bigDecimal = bd = new BigDecimal(this.num);
            }
            return bd;
        }

        @Override
        public String toString() {
            return Integer.toString(this.num);
        }
    }
}

