/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.connections.liberty;

import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.exceptions.RepositoryBackendIOException;
import com.ibm.ws.repository.exceptions.RepositoryHttpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class MainRepository {
    private static final String REPOSITORY_URL_PROP = "repository.url";
    private static final String API_KEY_PROP = "apiKey";
    private static final String USERID_PROP = "userId";
    private static final String PASSWORD_PROP = "password";
    private static final String SOFTLAYER_USERID_PROP = "softlayerUserId";
    private static final String SOFTLAYER_PASSWORD_PROP = "softlayerPassword";
    private static final String ATTACHMENT_BASIC_AUTH_USERID_PROP = "attachmentBasicAuthUserId";
    private static final String ATTACHMENT_BASIC_AUTH_PASSWORD_PROP = "attachmentBasicAuthPassword";
    public static final String LOCATION_OVERRIDE_SYS_PROP_NAME = "repository.description.url";
    private static final String DEFAULT_PROPERTIES_FILE_LOCATION = "https://public.dhe.ibm.com/ibmdl/export/pub/software/websphere/wasdev/downloads/assetservicelocation.props";
    private static volatile Properties repoProperties;

    private MainRepository() {
    }

    public static RestRepositoryConnection createConnection() throws RepositoryBackendIOException {
        return MainRepository.createConnection(null);
    }

    public static RestRepositoryConnection createConnection(RestRepositoryConnectionProxy proxy) throws RepositoryBackendIOException {
        MainRepository.readRepoProperties(proxy);
        RestRepositoryConnection connection = new RestRepositoryConnection(repoProperties.getProperty(REPOSITORY_URL_PROP).trim());
        connection.setProxy(proxy);
        if (repoProperties.containsKey(API_KEY_PROP)) {
            connection.setApiKey(repoProperties.getProperty(API_KEY_PROP).trim());
        }
        if (repoProperties.containsKey(USERID_PROP)) {
            connection.setUserId(repoProperties.getProperty(USERID_PROP).trim());
        }
        if (repoProperties.containsKey(PASSWORD_PROP)) {
            connection.setPassword(repoProperties.getProperty(PASSWORD_PROP).trim());
        }
        if (repoProperties.containsKey(SOFTLAYER_USERID_PROP)) {
            connection.setSoftlayerUserId(repoProperties.getProperty(SOFTLAYER_USERID_PROP).trim());
        }
        if (repoProperties.containsKey(SOFTLAYER_PASSWORD_PROP)) {
            connection.setSoftlayerPassword(repoProperties.getProperty(SOFTLAYER_PASSWORD_PROP).trim());
        }
        if (repoProperties.containsKey(ATTACHMENT_BASIC_AUTH_USERID_PROP)) {
            connection.setAttachmentBasicAuthUserId(repoProperties.getProperty(ATTACHMENT_BASIC_AUTH_USERID_PROP).trim());
        }
        if (repoProperties.containsKey(ATTACHMENT_BASIC_AUTH_PASSWORD_PROP)) {
            connection.setAttachmentBasicAuthPassword(repoProperties.getProperty(ATTACHMENT_BASIC_AUTH_PASSWORD_PROP).trim());
        }
        return connection;
    }

    public static void clearCachedRepoProperties() {
        repoProperties = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean repositoryDescriptionFileExists(RestRepositoryConnectionProxy proxy) {
        boolean exists = false;
        try {
            URL propertiesFileURL = MainRepository.getPropertiesFileLocation();
            if (proxy == null) {
                InputStream is = propertiesFileURL.openStream();
                exists = true;
                is.close();
                return exists;
            }
            if (proxy.isHTTPorHTTPS()) {
                Proxy javaNetProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getProxyURL().getHost(), proxy.getProxyURL().getPort()));
                URLConnection connection = propertiesFileURL.openConnection(javaNetProxy);
                InputStream is = connection.getInputStream();
                exists = true;
                is.close();
                if (!(connection instanceof HttpURLConnection)) return exists;
                ((HttpURLConnection)connection).disconnect();
                return exists;
            }
            UnsupportedOperationException ue = new UnsupportedOperationException("Non-HTTP proxy not supported");
            throw new IOException(ue);
        }
        catch (MalformedURLException malformedURLException) {
            return exists;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readRepoProperties(RestRepositoryConnectionProxy proxy) throws RepositoryBackendIOException {
        Class<MainRepository> clazz = MainRepository.class;
        synchronized (MainRepository.class) {
            if (repoProperties != null) return;
            URL propertiesFileURL = null;
            try {
                propertiesFileURL = MainRepository.getPropertiesFileLocation();
                Properties props = null;
                if (proxy != null) {
                    if (!proxy.isHTTPorHTTPS()) {
                        UnsupportedOperationException ue = new UnsupportedOperationException("Non-HTTP proxy not supported");
                        throw new IOException(ue);
                    }
                    Proxy javaNetProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getProxyURL().getHost(), proxy.getProxyURL().getPort()));
                    URLConnection connection = propertiesFileURL.openConnection(javaNetProxy);
                    MainRepository.checkHttpResponseCodeValid(connection);
                    props = new Properties();
                    try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
                        props.load(reader);
                    }
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).disconnect();
                    }
                } else {
                    URLConnection connection = propertiesFileURL.openConnection();
                    MainRepository.checkHttpResponseCodeValid(connection);
                    props = new Properties();
                    try (InputStreamReader reader = new InputStreamReader(propertiesFileURL.openStream(), StandardCharsets.UTF_8);){
                        props.load(reader);
                    }
                }
                if (!props.containsKey(REPOSITORY_URL_PROP)) {
                    throw new IllegalArgumentException(REPOSITORY_URL_PROP);
                }
                if (!props.containsKey(API_KEY_PROP)) {
                    throw new IllegalArgumentException(API_KEY_PROP);
                }
                repoProperties = props;
            }
            catch (IOException e) {
                throw new RepositoryBackendIOException("Failed to read properties file " + propertiesFileURL, (Throwable)e, null);
            }
            return;
        }
    }

    private static URL getPropertiesFileLocation() throws MalformedURLException {
        URL url;
        final String overrideLocation = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(MainRepository.LOCATION_OVERRIDE_SYS_PROP_NAME);
            }
        });
        try {
            url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    if (overrideLocation != null && overrideLocation.length() > 0) {
                        return new URL(overrideLocation);
                    }
                    return new URL(MainRepository.DEFAULT_PROPERTIES_FILE_LOCATION);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getCause();
        }
        return url;
    }

    private static void checkHttpResponseCodeValid(URLConnection connection) throws RepositoryHttpException, IOException {
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection conn = (HttpURLConnection)connection;
            conn.setRequestMethod("GET");
            int respCode = conn.getResponseCode();
            if (respCode < 200 || respCode >= 300) {
                throw new RepositoryHttpException("HTTP connection returned error code " + respCode, respCode, null);
            }
        }
    }
}

