/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractUtils;

public class ShutdownHook
implements Runnable {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(SelfExtract.class.getName() + "Messages");
    private static final String hookLog = "shutdownHook.log";
    final int platformType;
    final String dir;
    final String serverName;
    final boolean extractDirPredefined;

    public ShutdownHook(int platformType, String dir, String serverName, boolean extractDirPredefined) {
        this.serverName = serverName;
        this.dir = dir;
        this.platformType = platformType;
        this.extractDirPredefined = extractDirPredefined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPID(String dir, String serverName) {
        Object pid;
        block6: {
            pid = null;
            if (this.platformType == 3) {
                String string;
                String pidFile = dir + File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + ".pid" + File.separator + serverName + ".pid";
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pidFile), StandardCharsets.UTF_8));
                try {
                    string = br.readLine();
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        pid = null;
                        if (pid != null) break block6;
                        Object[] substitution = new Object[]{dir};
                        System.out.println(MessageFormat.format(resourceBundle.getString("UNABLE_TO_FIND_PID"), substitution));
                    }
                }
                br.close();
                return string;
            }
        }
        return pid;
    }

    private void stopServer() throws IOException {
        String cmd = this.dir + File.separator + "wlp" + File.separator + "bin" + File.separator + "server stop " + this.serverName;
        if (this.platformType != 1 && this.platformType != 4) {
            if (this.platformType == 2) {
                cmd = "cmd /c " + cmd;
            } else if (this.platformType == 3) {
                cmd = "bash -c  \"" + cmd.replace('\\', '/') + '\"';
            }
        }
        Process stopProcess = Runtime.getRuntime().exec(cmd, SelfExtractUtils.runEnv(this.dir), null);
        try {
            this.waitAndCloseStreams(stopProcess);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void startAsyncDelete() throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        File scriptFile = null;
        if (this.platformType == 1) {
            scriptFile = this.writeCleanupFile(1);
            Process proc = rt.exec("chmod 750 " + scriptFile.getAbsolutePath());
            this.waitAndCloseStreams(proc);
            ProcessBuilder job = new ProcessBuilder(new String[0]).command("sh", "-c", scriptFile.getAbsolutePath());
            job.redirectErrorStream(true);
            proc = job.start();
            this.waitAndCloseStreams(proc);
        } else if (this.platformType == 4) {
            scriptFile = this.writeCleanupFile(4);
            rt.exec("chmod 750 " + scriptFile.getAbsolutePath());
            rt.exec("/usr/bin/qsh -c " + scriptFile.getAbsolutePath() + " &");
        } else if (this.platformType == 2) {
            scriptFile = this.writeCleanupFile(2);
            rt.exec("cmd /k start /B " + scriptFile.getAbsolutePath() + " >/NUL 2>/NUL");
        } else if (this.platformType == 3) {
            scriptFile = this.writeCleanupFile(3);
            rt.exec("bash -c " + scriptFile.getAbsolutePath().replace('\\', '/') + " &");
        }
    }

    private void waitAndCloseStreams(Process proc) throws IOException, InterruptedException {
        this.waitAndCloseStreams(proc, false, true);
    }

    private void waitAndCloseStreams(Process proc, boolean writeStdoutToHookLog, boolean writeStderrToHookLog) throws IOException, InterruptedException {
        String line;
        StringBuilder stdOut = new StringBuilder();
        StringBuilder stdErr = new StringBuilder();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
            while ((line = reader.readLine()) != null) {
                stdOut.append(line + "\n");
            }
        }
        reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        try {
            while ((line = reader.readLine()) != null) {
                stdErr.append(line + "\n");
            }
        }
        finally {
            reader.close();
        }
        boolean stdoutEmpty = stdOut.toString().isEmpty();
        boolean stderrEmpty = stdErr.toString().isEmpty();
        proc.waitFor();
        if (writeStdoutToHookLog && !stdoutEmpty) {
            output.append(stdOut.toString());
        }
        if (writeStderrToHookLog && !stderrEmpty) {
            if (!stdoutEmpty) {
                output.append("\nStderr:\n");
            }
            output.append(stdErr.toString());
        }
        File outputFile = this.getHookLog().toFile();
        if (!output.toString().isEmpty()) {
            try (FileWriter writer = new FileWriter(outputFile, true);
                 BufferedWriter bufferedWriter = new BufferedWriter(writer);){
                bufferedWriter.write(output.toString());
            }
        }
        proc.getInputStream().close();
        proc.getOutputStream().close();
        proc.getErrorStream().close();
    }

    private void writeWindowsCleanup(File file, BufferedWriter bw) throws IOException {
        String logDir = this.dir + File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + this.serverName + File.separator + "logs";
        File tempDir = Files.createTempDirectory("logs", new FileAttribute[0]).toFile();
        bw.write("set max=30\n");
        bw.write("set cnt=0\n");
        bw.write("set dir=" + this.dir + "\n");
        bw.write("set tempDir=" + tempDir.getAbsolutePath() + "\n");
        bw.write("set logDir=" + logDir + "\n");
        bw.write("echo delete %dir%\n");
        bw.write("sleep 5\n");
        bw.write(":while\n");
        bw.write("   if exist %dir% (\n");
        bw.write("      xcopy /E/H/C/I %logDir% %tempDir% \n");
        bw.write("      rmdir /s /q %dir%\\wlp\n");
        bw.write("      mkdir %logDir%\n");
        bw.write("      xcopy /E/H/C/I %tempDir% %logDir%\n");
        bw.write("      timeout 1\n");
        bw.write("      set /a cnt+=1\n");
        bw.write("      if %cnt% leq %max% (\n");
        bw.write("         goto :while \n");
        bw.write("      )\n");
        bw.write("   )\n ");
        bw.write("erase " + file.getAbsoluteFile() + "\n");
        bw.write("erase " + tempDir.getAbsolutePath() + "\n");
    }

    private void writeUnixCleanup(File file, BufferedWriter bw) throws IOException {
        String logDir = this.dir + File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + this.serverName + File.separator + "logs";
        String serverDir = this.dir + File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + this.serverName + File.separator;
        File tempDir = Files.createTempDirectory("logs", new FileAttribute[0]).toFile();
        String logDirNormalized = logDir.replace('\\', '/');
        String dirNormalized = this.dir.replace('\\', '/');
        String tempDirNormalized = tempDir.getAbsolutePath().replace('\\', '/');
        String fileNormalized = file.getAbsolutePath().replace('\\', '/');
        bw.write("echo begin delete\n");
        bw.write("n=0\n");
        bw.write("while [ $n -ne 1 ]; do\n");
        bw.write("  if [ -e " + dirNormalized + "/wlp ]; then\n");
        bw.write("    cp -r " + logDirNormalized + " " + tempDirNormalized + "\n");
        bw.write("    rm -rf " + dirNormalized + "/wlp/ \n");
        bw.write("  else\n");
        bw.write("    echo file " + dirNormalized + "/wlp was deleted. Exiting loop.\n");
        bw.write("    n=1\n");
        bw.write("  fi\n");
        bw.write("done\n");
        bw.write("mkdir -p " + logDirNormalized + "\n");
        bw.write("cp -r " + tempDirNormalized + "/logs/ " + serverDir.replace('\\', '/') + "\n");
        bw.write("echo log directory restored to: " + logDirNormalized + "\n");
        bw.write("chmod -R 755 " + dirNormalized + "\n");
        bw.write("rm -rf " + fileNormalized + "\n");
        bw.write("rm -rf " + tempDirNormalized + "\n");
        bw.write("echo end delete\n");
    }

    private void writeCygwinCleanup(File file, BufferedWriter bw) throws IOException {
        String pid = this.getPID(this.dir, this.serverName);
        if (pid != null) {
            bw.write("kill " + pid + "\n");
        }
        this.writeUnixCleanup(file, bw);
    }

    private File writeCleanupFile(int platformType) throws IOException {
        boolean success;
        File file;
        String fileSuffix = ".sh";
        if (platformType == 2) {
            fileSuffix = ".bat";
        }
        if (!(file = File.createTempFile("wlpDelete", fileSuffix)).exists() && !(success = file.createNewFile())) {
            throw new IOException("Failed to create file " + file.getName());
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsoluteFile()), StandardCharsets.UTF_8));
        if (platformType == 1 || platformType == 4) {
            this.writeUnixCleanup(file, bw);
        } else if (platformType == 2) {
            this.writeWindowsCleanup(file, bw);
        } else if (platformType == 3) {
            this.writeCygwinCleanup(file, bw);
        }
        bw.close();
        return file;
    }

    @Override
    public void run() {
        try {
            this.stopServer();
            if (!this.extractDirPredefined) {
                this.startAsyncDelete();
            }
        }
        catch (Exception e) {
            try {
                Files.write(this.getHookLog(), (e.getMessage() + "\n" + Arrays.toString(e.getStackTrace())).getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            throw new RuntimeException("Shutdown hook failed with exception " + e.getMessage());
        }
    }

    private Path getHookLog() {
        String logDir = this.dir + File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + this.serverName + File.separator + "logs";
        return Paths.get(logDir, hookLog);
    }
}

