/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import wlp.lib.extract.Content;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractor;
import wlp.lib.extract.platform.PlatformUtils;

public class SelfExtractUtils {
    private static final int LINE_WRAP_COLUMNS = 72;
    public static final String DOWNLOAD_URL = "download.url";
    public static final String DOWNLOAD_TARGET = "download.target";
    public static final String DOWNLOAD_TARGET_FILE = "download.target.file";
    public static final String DOWNLOAD_CONTENT_SIZE = "download.content.size";
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("win") >= 0;
    private static final String SUBSYSTEM_CONTENT = "Subsystem-Content";
    private static final String LOCATION_DIRECTIVE = "location:=";
    private static final String EXECUTABLE_DIRECTIVE = "ibm.executable:=";
    public static final int PlatformType_UNIX = 1;
    public static final int PlatformType_WINDOWS = 2;
    public static final int PlatformType_CYGWIN = 3;
    public static final int PlatformType_OS400 = 4;

    public static final File getSelf() {
        File s;
        block3: {
            URL url;
            s = null;
            ProtectionDomain pd = SelfExtract.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null && (url = cs.getLocation()) != null) {
                try {
                    s = new File(new URI(url.toString()));
                }
                catch (URISyntaxException ex) {
                    if (!url.getProtocol().equals("file")) break block3;
                    s = new File(url.getPath());
                }
            }
        }
        return s;
    }

    static final Content.Entry getLicenseFile(Content container, String prefix) {
        if (!prefix.endsWith("_")) {
            prefix = prefix + "_";
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        Content.Entry entry = null;
        String[] suffixes = new String[]{lang + '_' + country, lang, "en"};
        for (int i = 0; i < suffixes.length && (entry = container.getEntry(prefix + suffixes[i])) == null; ++i) {
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception showLicenseFile(InputStream in) {
        ArrayList lines = new ArrayList();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_16));
            while ((line = reader.readLine()) != null) {
                SelfExtractUtils.wordWrap(line, lines);
            }
            for (int i = 0; i < lines.size(); ++i) {
                System.out.println(lines.get(i));
            }
            System.out.flush();
            System.out.println();
            Exception i = null;
            SelfExtractUtils.tryToClose(reader);
            return i;
        }
        catch (Exception e) {
            Exception exception = e;
            return exception;
        }
        finally {
            SelfExtractUtils.tryToClose(reader);
        }
    }

    static List wordWrap(String line, List lines) {
        if (lines == null) {
            lines = new ArrayList<String>();
        }
        if (line.length() == 0) {
            lines.add("");
            return lines;
        }
        int begin = 0;
        while (begin < line.length()) {
            int tryEnd;
            int end;
            if (begin + 72 >= line.length()) {
                lines.add(line.substring(begin));
                break;
            }
            for (end = tryEnd = Math.min(line.length(), begin + 72); end > begin && !Character.isWhitespace(line.charAt(end - 1)); --end) {
            }
            while (end > begin && Character.isWhitespace(line.charAt(end - 1))) {
                --end;
            }
            if (end == begin) {
                for (end = tryEnd; end < line.length() && !Character.isWhitespace(line.charAt(end)); ++end) {
                }
            }
            lines.add(line.substring(begin, end));
            for (begin = end; begin < line.length() && Character.isWhitespace(line.charAt(begin)); ++begin) {
            }
        }
        return lines;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final Exception makeExecutable(List scripts, ExtractProgress ep) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("chmod");
        cmd.add("+x");
        cmd.addAll(scripts);
        ep.commandRun(cmd);
        try {
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[cmd.size()]));
            Thread stdout = SelfExtractUtils.copyAsync(p.getInputStream(), System.out);
            Thread stderr = SelfExtractUtils.copyAsync(p.getErrorStream(), System.err);
            stdout.join();
            stderr.join();
            p.waitFor();
            return null;
        }
        catch (IOException e) {
            if (!e.getMessage().contains("Cannot run program \"chmod\"")) return null;
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    private static Thread copyAsync(final InputStream in, final OutputStream out) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                byte[] buf = new byte[4096];
                try {
                    int read;
                    while ((read = in.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                }
                catch (IOException | IllegalStateException ex) {
                    ex.printStackTrace();
                }
            }
        };
        thread.start();
        return thread;
    }

    public static final void tryToClose(ZipFile f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void tryToClose(Reader c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void tryToClose(InputStream c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void tryToClose(OutputStream c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static List getEmptyDirectories(Attributes attribs) {
        String value;
        if (attribs != null && (value = attribs.getValue("Empty-Dirs")) != null) {
            return Arrays.asList(value.split(","));
        }
        return Arrays.asList("usr/shared/apps", "usr/shared/config", "usr/shared/resources", "templates/servers/defaultServer/apps", "templates/servers/defaultServer/dropins");
    }

    static void delete(File outputDir, boolean keepDir) {
        File[] files;
        if (outputDir.isDirectory() && (files = outputDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                SelfExtractUtils.delete(files[i], false);
            }
        }
        if (!keepDir) {
            outputDir.delete();
        }
    }

    static int tryGetContentLengthOfURL(URL url) {
        try {
            return url.openConnection().getContentLength();
        }
        catch (Exception e) {
            return -1;
        }
    }

    static List convertDependenciesListToMapsList(SelfExtractor.ExternalDependencies deps) {
        List depsList = deps.getDependencies();
        ArrayList depsMapsList = new ArrayList();
        for (int i = 0; i < depsList.size(); ++i) {
            SelfExtractor.ExternalDependency thisDep = (SelfExtractor.ExternalDependency)depsList.get(i);
            HashMap<String, Object> depMap = new HashMap<String, Object>();
            depMap.put(DOWNLOAD_URL, thisDep.getSourceUrl());
            depMap.put(DOWNLOAD_TARGET, thisDep.getTargetPath());
            depsMapsList.add(depMap);
        }
        return depsMapsList;
    }

    static boolean trackedMkdirs(File dir, List allDirectories) {
        if (dir.exists()) {
            return false;
        }
        File potentialNewDirRoot = dir.getParentFile();
        File lastPotentialRoot = dir;
        while (!potentialNewDirRoot.exists()) {
            lastPotentialRoot = potentialNewDirRoot;
            potentialNewDirRoot = potentialNewDirRoot.getParentFile();
        }
        allDirectories.add(lastPotentialRoot);
        return dir.mkdirs();
    }

    public static void rollbackExtract(List filesAndDirectories) {
        for (int i = 0; i < filesAndDirectories.size(); ++i) {
            File target = (File)filesAndDirectories.get(i);
            if (!target.exists()) continue;
            SelfExtractUtils.delete(target, false);
        }
    }

    private static void collectScripts(File[] files, List scripts) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            File[] childFiles = file.listFiles();
            if (childFiles != null) {
                SelfExtractUtils.collectScripts(childFiles, scripts);
                continue;
            }
            if (file.getName().indexOf(46) != -1) continue;
            scripts.add(file.getPath());
        }
    }

    public static ReturnCode fixScriptPermissions(ExtractProgress ep, File outputDir, ZipFile filter) {
        if (!isWindows) {
            File zOutputDir;
            File properties;
            Object binFiles = new File(outputDir, "bin").listFiles();
            if (binFiles != null && filter != null) {
                ArrayList<File> filteredBinFiles = new ArrayList<File>();
                for (int i = 0; i < ((File[])binFiles).length; ++i) {
                    File currBinFile = binFiles[i];
                    if (filter.getEntry("bin/" + currBinFile.getName()) == null) continue;
                    filteredBinFiles.add(currBinFile);
                }
                binFiles = filteredBinFiles.size() == 0 ? null : filteredBinFiles.toArray(new File[filteredBinFiles.size()]);
            }
            if (binFiles != null) {
                ArrayList scripts = new ArrayList();
                SelfExtractUtils.collectScripts(binFiles, scripts);
                Exception e = SelfExtractUtils.makeExecutable(scripts, ep);
                if (e != null) {
                    return new ReturnCode(4, "chmodError", e.getMessage());
                }
            }
            if ((properties = new File(zOutputDir = new File(outputDir, "lib" + File.separator + "native" + File.separator + "zos" + File.separator + "s390x"), "extattr.properties")).exists()) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(properties), "IBM-1047"));
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        String[] props = line.split(" ");
                        attrs.put(props[0], props[1]);
                    }
                    br.close();
                    properties.delete();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File[] execFiles = zOutputDir.listFiles();
                ArrayList<String> scripts = new ArrayList<String>();
                for (int i = 0; i < execFiles.length; ++i) {
                    scripts.add(execFiles[i].getPath());
                }
                Exception e = SelfExtractUtils.makeExecutable(scripts, ep);
                if (e != null) {
                    return new ReturnCode(4, "chmodError", e.getMessage());
                }
                Set attrset = attrs.entrySet();
                for (Map.Entry entry : attrset) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    ArrayList<String> execlist = new ArrayList<String>();
                    execlist.add(SelfExtractUtils.getExtAttrsToSet(v));
                    execlist.add(SelfExtractUtils.getExtAttrsToUnset(v));
                    execlist.add(zOutputDir.getPath() + File.separator + k);
                    e = SelfExtractUtils.setExtAttrs(execlist, ep);
                    if (e == null) continue;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String getExtAttrsToSet(String attrs) {
        String result = "+";
        if (attrs.contains("a")) {
            result = result + "a";
        }
        if (attrs.contains("p")) {
            result = result + "p";
        }
        if (attrs.contains("s")) {
            result = result + "s";
        }
        if (attrs.contains("l")) {
            result = result + "l";
        }
        return result;
    }

    private static String getExtAttrsToUnset(String attrs) {
        String result = "-";
        if (!attrs.contains("a")) {
            result = result + "a";
        }
        if (!attrs.contains("p")) {
            result = result + "p";
        }
        if (!attrs.contains("s")) {
            result = result + "s";
        }
        if (!attrs.contains("l")) {
            result = result + "l";
        }
        return result;
    }

    static final Exception setExtAttrs(List parameters, ExtractProgress ep) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("extattr");
        cmd.addAll(parameters);
        ep.commandRun(cmd);
        try {
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[cmd.size()]));
            Thread stdout = SelfExtractUtils.copyAsync(p.getInputStream(), System.out);
            Thread stderr = SelfExtractUtils.copyAsync(p.getErrorStream(), System.err);
            stdout.join();
            stderr.join();
            p.waitFor();
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    private static File[] findAllFeatureManifests(File outputDir) {
        final File featureDir = new File(outputDir, "lib" + File.separator + "features");
        if (!featureDir.isDirectory()) {
            return new File[0];
        }
        File[] manifestFiles = (File[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] manifestFiles = featureDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        boolean result = false;
                        if (pathname.getName().toLowerCase().endsWith(".mf")) {
                            result = true;
                        }
                        return result;
                    }
                });
                return manifestFiles;
            }
        });
        return manifestFiles;
    }

    private static String[] getSubSystemContentFromManifest(final File manifestFile) throws PrivilegedActionException {
        Manifest manifest = (Manifest)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws FileNotFoundException, IOException {
                FileInputStream fin = null;
                Manifest mf = new Manifest();
                try {
                    fin = new FileInputStream(manifestFile);
                    mf.read(fin);
                }
                catch (Throwable throwable) {
                    SelfExtractUtils.tryToClose(fin);
                    throw throwable;
                }
                SelfExtractUtils.tryToClose(fin);
                return mf;
            }
        });
        Attributes attributes = manifest.getMainAttributes();
        String value = attributes.getValue(SUBSYSTEM_CONTENT);
        return null != value && !value.isEmpty() ? value.split(",") : new String[]{};
    }

    public static ReturnCode processExecutableDirective(File outputDir) throws Exception {
        File[] manifestfiles = SelfExtractUtils.findAllFeatureManifests(outputDir);
        HashSet<String> executableFiles = new HashSet<String>();
        for (int i = 0; i < manifestfiles.length; ++i) {
            String[] subSystemContent;
            try {
                subSystemContent = SelfExtractUtils.getSubSystemContentFromManifest(manifestfiles[i]);
            }
            catch (PrivilegedActionException e) {
                return new ReturnCode(2, "exception.reading.manifest", manifestfiles[i].getAbsolutePath(), e.getCause().getMessage());
            }
            for (int j = 0; j < subSystemContent.length; ++j) {
                File exeFile;
                String[] values = subSystemContent[j].split(";");
                String location = "";
                boolean executable = false;
                for (int k = 0; k < values.length && (location.isEmpty() || !executable); ++k) {
                    String value = values[k].trim();
                    if (value.startsWith(LOCATION_DIRECTIVE)) {
                        location = value.substring(LOCATION_DIRECTIVE.length() + 1, value.length() - 1);
                        continue;
                    }
                    if (!value.startsWith(EXECUTABLE_DIRECTIVE)) continue;
                    executable = "true".equalsIgnoreCase(value.substring(EXECUTABLE_DIRECTIVE.length() + 1, value.length() - 1));
                }
                if (location.isEmpty() || !executable || !(exeFile = new File(outputDir, location)).exists()) continue;
                executableFiles.add(exeFile.getAbsolutePath());
            }
        }
        return PlatformUtils.setExecutePermissionAccordingToUmask(executableFiles.toArray(new String[executableFiles.size()]));
    }

    public static String[] runEnv(String extractDirectory) {
        Map<String, String> envmap = System.getenv();
        Iterator<String> iKeys = envmap.keySet().iterator();
        ArrayList<String> envList = new ArrayList<String>(envmap.size() + 1);
        boolean javaHomeSet = false;
        while (iKeys.hasNext()) {
            String key = iKeys.next();
            String val = envmap.get(key);
            if (key.equals("WLP_USER_DIR")) {
                envList.add("WLP_USER_DIR=" + extractDirectory + File.separator + "wlp" + File.separator + "usr");
            } else {
                envList.add(key + "=" + val);
            }
            if (!key.equals("JAVA_HOME")) continue;
            javaHomeSet = true;
        }
        if (!javaHomeSet) {
            String javaHome = System.getProperty("java.home");
            SelfExtract.out("RUN_IN_CHILD_JVM_SET_JAVA_HOME", javaHome);
            envList.add("JAVA_HOME=" + javaHome);
        }
        return envList.toArray(new String[0]);
    }

    private static boolean isCygwin() {
        String cygwin = System.getenv("WLP_JAR_CYGWIN");
        return cygwin != null;
    }

    public static int getPlatform() {
        if (System.getProperty("os.name").startsWith("Win")) {
            if (SelfExtractUtils.isCygwin()) {
                return 3;
            }
            return 2;
        }
        if (System.getProperty("os.name").equalsIgnoreCase("os/400")) {
            return 4;
        }
        return 1;
    }
}

