/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot;

import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;

public enum ReturnCode implements ExitCode
{
    OK(0),
    REDUNDANT_ACTION_STATUS(1),
    SERVER_NOT_EXIST_STATUS(2),
    SERVER_ACTIVE_STATUS(3),
    SERVER_INACTIVE_STATUS(4),
    SERVER_UNKNOWN_STATUS(5),
    SERVER_COMMAND_PORT_DISABLED_STATUS(6),
    BAD_ARGUMENT(20),
    ERROR_SERVER_STOP(21),
    ERROR_SERVER_START(22),
    LOCATION_EXCEPTION(23),
    LAUNCH_EXCEPTION(24),
    RUNTIME_EXCEPTION(25),
    UNKNOWN_EXCEPTION(26),
    PROCESS_CLIENT_EXCEPTION(27),
    ERROR_SERVER_PACKAGE(28),
    ERROR_SERVER_DUMP(29),
    ERROR_BAD_JAVA_VERSION(31),
    ERROR_BAD_JAVA_BITMODE(31),
    ERROR_BAD_JVM_OPTION(32),
    CONNECTION_FAILED(33),
    ERROR_COMMUNICATE_SERVER(34),
    CLIENT_RUNNER_EXCEPTION(35),
    ERROR_SERVER_PAUSE(36),
    ERROR_SERVER_RESUME(37),
    MESSAGE_ACTION(-1),
    HELP_ACTION(-2),
    STOP_ACTION(-3, "stop.log"),
    STATUS_ACTION(-4, "status.log"),
    STARTING_STATUS_ACTION(-5, "start.log"),
    START_STATUS_ACTION(-6, "start.log"),
    VERSION_ACTION(-7),
    PACKAGE_ACTION(-8, "package.log"),
    DUMP_ACTION(-9, "dump.log"),
    JAVADUMP_ACTION(-10, "javadump.log"),
    CREATE_ACTION(-11, "create.log"),
    LIST_ACTION(-12),
    CHECKPOINT_ACTION(-13),
    INVALID(13),
    PACKAGE_WLP_ACTION(-15, "package.log"),
    PAUSE_ACTION(-16),
    RESUME_ACTION(-17);

    final int val;
    final String logName;

    private ReturnCode(int val, String logName) {
        this.val = val;
        this.logName = logName;
    }

    private ReturnCode(int val) {
        this(val, null);
    }

    boolean readInitialConfig() {
        return this.val < 20 && this != HELP_ACTION && this != CREATE_ACTION && this != VERSION_ACTION && this != STATUS_ACTION && this != MESSAGE_ACTION;
    }

    @Override
    public int getValue() {
        return this.val;
    }

    public boolean defaultServerNameMessage() {
        return this == OK || this == CREATE_ACTION;
    }

    public BootstrapConstants.VerifyServer getVerifyServer() {
        switch (this) {
            case OK: {
                return BootstrapConstants.VerifyServer.CREATE_DEFAULT;
            }
            case CREATE_ACTION: {
                return BootstrapConstants.VerifyServer.CREATE;
            }
            case HELP_ACTION: 
            case VERSION_ACTION: 
            case LIST_ACTION: 
            case MESSAGE_ACTION: 
            case PACKAGE_WLP_ACTION: {
                return BootstrapConstants.VerifyServer.SKIP;
            }
            case START_STATUS_ACTION: {
                return BootstrapConstants.VerifyServer.SKIP;
            }
        }
        if (this.val < 20) {
            return BootstrapConstants.VerifyServer.EXISTS;
        }
        return BootstrapConstants.VerifyServer.SKIP;
    }

    public static ReturnCode maxRc(ReturnCode oldRc, ReturnCode newRc) {
        return oldRc.val > newRc.val ? oldRc : newRc;
    }

    public static ReturnCode getEnum(int i) {
        ReturnCode[] codes;
        for (ReturnCode code : codes = ReturnCode.values()) {
            if (code.getValue() != i) continue;
            return code;
        }
        return INVALID;
    }
}

