/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.IoEvent;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoHandle;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.UnixChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringIoEvent;
import io.netty.channel.uring.IoUringIoHandle;
import io.netty.channel.uring.IoUringIoOps;
import io.netty.channel.uring.IoUringRecvByteAllocatorHandle;
import io.netty.channel.uring.LinuxSocket;
import io.netty.channel.uring.MsgHdrMemory;
import io.netty.channel.uring.MsgHdrMemoryArray;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.SockaddrIn;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.internal.CleanableDirectBuffer;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

abstract class AbstractIoUringChannel
extends AbstractChannel
implements UnixChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractIoUringChannel.class);
    final LinuxSocket socket;
    protected volatile boolean active;
    private static final int POLL_IN_SCHEDULED = 1;
    private static final int POLL_OUT_SCHEDULED = 4;
    private static final int POLL_RDHUP_SCHEDULED = 8;
    private static final int WRITE_SCHEDULED = 16;
    private static final int READ_SCHEDULED = 32;
    private static final int CONNECT_SCHEDULED = 64;
    private short opsId = Short.MIN_VALUE;
    private long pollInId;
    private long pollOutId;
    private long pollRdhupId;
    private long connectId;
    private byte ioState;
    private short numOutstandingWrites;
    private short numOutstandingReads;
    private boolean readPending;
    private boolean inReadComplete;
    private boolean socketHasMoreData;
    private DelayedClose delayedClose;
    private boolean inputClosedSeenErrorOnRead;
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private CleanableDirectBuffer cleanable;
    private ByteBuffer remoteAddressMemory;
    private MsgHdrMemoryArray msgHdrMemoryArray;
    private IoRegistration registration;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;

    AbstractIoUringChannel(Channel parent, LinuxSocket socket, boolean active) {
        super(parent);
        this.socket = (LinuxSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)socket), (String)"fd"));
        if (active) {
            this.active = true;
            this.local = socket.localAddress();
            this.remote = socket.remoteAddress();
        }
        logger.trace("Create {} Socket: {}", (Object)(this instanceof ServerChannel ? "Server" : "Channel"), (Object)socket.intValue());
    }

    AbstractIoUringChannel(Channel parent, LinuxSocket fd, SocketAddress remote) {
        super(parent);
        this.socket = (LinuxSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)fd), (String)"fd"));
        this.active = true;
        this.remote = remote;
        this.local = fd.localAddress();
    }

    final void autoReadCleared() {
        if (!this.isRegistered()) {
            return;
        }
        IoRegistration registration = this.registration;
        if (registration == null || !registration.isValid()) {
            return;
        }
        if (this.eventLoop().inEventLoop()) {
            this.clearRead();
        } else {
            this.eventLoop().execute(this::clearRead);
        }
    }

    private void clearRead() {
        assert (this.eventLoop().inEventLoop());
        this.readPending = false;
        IoRegistration registration = this.registration;
        if (registration == null || !registration.isValid()) {
            return;
        }
        this.cancelOutstandingReads(this.registration(), this.numOutstandingReads);
    }

    protected final short nextOpsId() {
        short s = this.opsId;
        this.opsId = (short)(s + 1);
        short id = s;
        if (id == 0) {
            short s2 = this.opsId;
            this.opsId = (short)(s2 + 1);
            id = s2;
        }
        return id;
    }

    public final boolean isOpen() {
        return this.socket.isOpen();
    }

    public boolean isActive() {
        return this.active;
    }

    public final FileDescriptor fd() {
        return this.socket;
    }

    private AbstractUringUnsafe ioUringUnsafe() {
        return (AbstractUringUnsafe)this.unsafe();
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof IoEventLoop && ((IoEventLoop)loop).isCompatible(AbstractUringUnsafe.class);
    }

    protected final ByteBuf newDirectBuffer(ByteBuf buf) {
        return this.newDirectBuffer(buf, buf);
    }

    protected boolean allowMultiShotPollIn() {
        return IoUring.isPollAddMultishotEnabled();
    }

    protected final ByteBuf newDirectBuffer(Object holder, ByteBuf buf) {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            ReferenceCountUtil.release((Object)holder);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator alloc = this.alloc();
        if (alloc.isDirectBufferPooled()) {
            return AbstractIoUringChannel.newDirectBuffer0(holder, buf, alloc, readableBytes);
        }
        ByteBuf directBuf = ByteBufUtil.threadLocalDirectBuffer();
        if (directBuf == null) {
            return AbstractIoUringChannel.newDirectBuffer0(holder, buf, alloc, readableBytes);
        }
        directBuf.writeBytes(buf, buf.readerIndex(), readableBytes);
        ReferenceCountUtil.safeRelease((Object)holder);
        return directBuf;
    }

    private static ByteBuf newDirectBuffer0(Object holder, ByteBuf buf, ByteBufAllocator alloc, int capacity) {
        ByteBuf directBuf = alloc.directBuffer(capacity);
        directBuf.writeBytes(buf, buf.readerIndex(), capacity);
        ReferenceCountUtil.safeRelease((Object)holder);
        return directBuf;
    }

    protected abstract void cancelOutstandingReads(IoRegistration var1, int var2);

    protected abstract void cancelOutstandingWrites(IoRegistration var1, int var2);

    protected void doDisconnect() throws Exception {
    }

    private void freeRemoteAddressMemory() {
        if (this.remoteAddressMemory != null) {
            this.cleanable.clean();
            this.cleanable = null;
            this.remoteAddressMemory = null;
        }
    }

    private void freeMsgHdrArray() {
        if (this.msgHdrMemoryArray != null) {
            this.msgHdrMemoryArray.release();
            this.msgHdrMemoryArray = null;
        }
    }

    protected void doClose() throws Exception {
        this.active = false;
        if (this.registration != null) {
            if (this.socket.markClosed()) {
                int fd = this.fd().intValue();
                IoUringIoOps ops = IoUringIoOps.newClose(fd, (byte)0, this.nextOpsId());
                this.registration.submit((IoOps)ops);
            }
        } else {
            this.socket.close();
            this.ioUringUnsafe().freeResourcesNowIfNeeded(null);
        }
    }

    protected final void doBeginRead() {
        if (this.inputClosedSeenErrorOnRead) {
            return;
        }
        if (this.readPending) {
            return;
        }
        this.readPending = true;
        if (this.inReadComplete || !this.isActive()) {
            return;
        }
        this.doBeginReadNow();
    }

    private void doBeginReadNow() {
        if (this.inputClosedSeenErrorOnRead) {
            return;
        }
        if (!this.isPollInFirst() || this.socketHasMoreData) {
            this.ioUringUnsafe().scheduleFirstReadIfNeeded();
        } else if ((this.ioState & 1) == 0) {
            this.ioUringUnsafe().schedulePollIn();
        }
    }

    protected void doWrite(ChannelOutboundBuffer in) {
        this.scheduleWriteIfNeeded(in, true);
    }

    protected void scheduleWriteIfNeeded(ChannelOutboundBuffer in, boolean submitAndRunNow) {
        if ((this.ioState & 0x10) != 0) {
            return;
        }
        if (this.scheduleWrite(in) > 0) {
            this.ioState = (byte)(this.ioState | 0x10);
            if (submitAndRunNow && !this.isWritable()) {
                this.submitAndRunNow();
            }
        }
    }

    protected void submitAndRunNow() {
    }

    private int scheduleWrite(ChannelOutboundBuffer in) {
        if (this.delayedClose != null || this.numOutstandingWrites == Short.MAX_VALUE) {
            return 0;
        }
        if (in == null) {
            return 0;
        }
        int msgCount = in.size();
        if (msgCount == 0) {
            return 0;
        }
        Object msg = in.current();
        this.numOutstandingWrites = msgCount > 1 && in.current() instanceof ByteBuf ? (short)this.ioUringUnsafe().scheduleWriteMultiple(in) : (msg instanceof ByteBuf && ((ByteBuf)msg).nioBufferCount() > 1 || msg instanceof ByteBufHolder && ((ByteBufHolder)msg).content().nioBufferCount() > 1 ? (short)this.ioUringUnsafe().scheduleWriteMultiple(in) : (short)this.ioUringUnsafe().scheduleWriteSingle(msg));
        assert (this.numOutstandingWrites > 0);
        return this.numOutstandingWrites;
    }

    protected final IoRegistration registration() {
        assert (this.registration != null);
        return this.registration;
    }

    private void schedulePollOut() {
        this.pollOutId = this.schedulePollAdd(4, Native.POLLOUT, false);
    }

    final void schedulePollRdHup() {
        this.pollRdhupId = this.schedulePollAdd(8, Native.POLLRDHUP, false);
    }

    private long schedulePollAdd(int ioMask, int mask, boolean multishot) {
        IoUringIoOps ops;
        assert ((this.ioState & ioMask) == 0);
        int fd = this.fd().intValue();
        IoRegistration registration = this.registration();
        long id = registration.submit((IoOps)(ops = IoUringIoOps.newPollAdd(fd, (byte)0, mask, multishot ? 1 : 0, this.nextOpsId())));
        if (id != 0L) {
            this.ioState = (byte)(this.ioState | (byte)ioMask);
        }
        return id;
    }

    final void resetCachedAddresses() {
        this.local = this.socket.localAddress();
        this.remote = this.socket.remoteAddress();
    }

    private void submitConnect(InetSocketAddress inetSocketAddress) {
        this.cleanable = Buffer.allocateDirectBufferWithNativeOrder((int)Native.SIZEOF_SOCKADDR_STORAGE);
        this.remoteAddressMemory = this.cleanable.buffer();
        SockaddrIn.set(this.socket.isIpv6(), this.remoteAddressMemory, inetSocketAddress);
        int fd = this.fd().intValue();
        IoRegistration registration = this.registration();
        IoUringIoOps ops = IoUringIoOps.newConnect(fd, (byte)0, Buffer.memoryAddress((ByteBuffer)this.remoteAddressMemory), this.nextOpsId());
        this.connectId = registration.submit((IoOps)ops);
        if (this.connectId == 0L) {
            this.freeRemoteAddressMemory();
        }
    }

    private void submitConnect(DomainSocketAddress unixDomainSocketAddress) {
        this.cleanable = Buffer.allocateDirectBufferWithNativeOrder((int)Native.SIZEOF_SOCKADDR_UN);
        this.remoteAddressMemory = this.cleanable.buffer();
        SockaddrIn.setUds(this.remoteAddressMemory, unixDomainSocketAddress);
        int fd = this.fd().intValue();
        IoRegistration registration = this.registration();
        long addr = Buffer.memoryAddress((ByteBuffer)this.remoteAddressMemory);
        IoUringIoOps ops = IoUringIoOps.newConnect(fd, (byte)0, addr, Native.SIZEOF_SOCKADDR_UN, this.nextOpsId());
        this.connectId = registration.submit((IoOps)ops);
        if (this.connectId == 0L) {
            this.freeRemoteAddressMemory();
        }
    }

    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)buf) ? this.newDirectBuffer(buf) : buf;
        }
        throw new UnsupportedOperationException("unsupported message type");
    }

    protected void doRegister(ChannelPromise promise) {
        IoEventLoop eventLoop = (IoEventLoop)this.eventLoop();
        eventLoop.register((IoHandle)this.ioUringUnsafe()).addListener(f -> {
            if (f.isSuccess()) {
                this.registration = (IoRegistration)f.getNow();
                promise.setSuccess();
            } else {
                promise.setFailure(f.cause());
            }
        });
    }

    protected final void doDeregister() {
        this.ioUringUnsafe().cancelOps(this.connectPromise != null);
    }

    protected void doBind(SocketAddress local) throws Exception {
        if (local instanceof InetSocketAddress) {
            AbstractIoUringChannel.checkResolvable((InetSocketAddress)local);
        }
        this.socket.bind(local);
        this.local = this.socket.localAddress();
    }

    protected static void checkResolvable(InetSocketAddress addr) {
        if (addr.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final SocketAddress localAddress0() {
        return this.local;
    }

    protected final SocketAddress remoteAddress0() {
        return this.remote;
    }

    private static boolean isAllowHalfClosure(ChannelConfig config) {
        return config instanceof SocketChannelConfig && ((SocketChannelConfig)config).isAllowHalfClosure();
    }

    private void cancelConnectTimeoutFuture() {
        if (this.connectTimeoutFuture != null) {
            this.connectTimeoutFuture.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    private void computeRemote() {
        if (this.requestedRemoteAddress instanceof InetSocketAddress) {
            this.remote = UnixChannelUtil.computeRemoteAddr((InetSocketAddress)((InetSocketAddress)this.requestedRemoteAddress), (InetSocketAddress)this.socket.remoteAddress());
        }
    }

    private boolean shouldBreakIoUringInReady(ChannelConfig config) {
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractIoUringChannel.isAllowHalfClosure(config));
    }

    protected abstract boolean socketIsEmpty(int var1);

    abstract boolean isPollInFirst();

    protected abstract class AbstractUringUnsafe
    extends AbstractChannel.AbstractUnsafe
    implements IoUringIoHandle {
        private IoUringRecvByteAllocatorHandle allocHandle;
        private boolean closed;
        private boolean freed;
        private boolean socketIsEmpty;

        protected AbstractUringUnsafe() {
            super((AbstractChannel)AbstractIoUringChannel.this);
        }

        protected abstract int scheduleWriteMultiple(ChannelOutboundBuffer var1);

        protected abstract int scheduleWriteSingle(Object var1);

        public final void handle(IoRegistration registration, IoEvent ioEvent) {
            IoUringIoEvent event = (IoUringIoEvent)ioEvent;
            byte op = event.opcode();
            int res = event.res();
            int flags = event.flags();
            short data = event.data();
            switch (op) {
                case 10: 
                case 13: 
                case 22: 
                case 27: {
                    this.readComplete(op, res, flags, data);
                    break;
                }
                case 2: 
                case 9: 
                case 23: 
                case 26: 
                case 30: 
                case 47: 
                case 48: {
                    this.writeComplete(op, res, flags, data);
                    break;
                }
                case 6: {
                    this.pollAddComplete(res, flags, data);
                    break;
                }
                case 14: {
                    this.cancelComplete0(op, res, flags, data);
                    break;
                }
                case 16: {
                    this.connectComplete(op, res, flags, data);
                    AbstractIoUringChannel.this.freeMsgHdrArray();
                    AbstractIoUringChannel.this.freeRemoteAddressMemory();
                    break;
                }
                case 19: {
                    if (res == Native.ERRNO_ECANCELED_NEGATIVE) break;
                    if (AbstractIoUringChannel.this.delayedClose != null) {
                        AbstractIoUringChannel.this.delayedClose.promise.setSuccess();
                    }
                    this.closed = true;
                    break;
                }
            }
            this.handleDelayedClosed();
            if (AbstractIoUringChannel.this.ioState == 0 && this.closed) {
                this.freeResourcesNowIfNeeded(registration);
            }
        }

        private void freeResourcesNowIfNeeded(IoRegistration reg) {
            if (!this.freed) {
                this.freed = true;
                this.freeResourcesNow(reg);
            }
        }

        protected void freeResourcesNow(IoRegistration reg) {
            AbstractIoUringChannel.this.freeMsgHdrArray();
            AbstractIoUringChannel.this.freeRemoteAddressMemory();
            if (reg != null) {
                reg.cancel();
            }
        }

        private void handleDelayedClosed() {
            if (AbstractIoUringChannel.this.delayedClose != null && this.canCloseNow()) {
                this.closeNow();
            }
        }

        private void pollAddComplete(int res, int flags, short data) {
            if ((res & Native.POLLOUT) != 0) {
                this.pollOut(res);
            }
            if ((res & Native.POLLIN) != 0) {
                this.pollIn(res, flags, data);
            }
            if ((res & Native.POLLRDHUP) != 0) {
                this.pollRdHup(res);
            }
        }

        public final void close() throws Exception {
            this.close(this.voidPromise());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close(ChannelPromise promise, Throwable cause, ClosedChannelException closeCause) {
            if (AbstractIoUringChannel.this.closeFuture().isDone()) {
                this.safeSetSuccess(promise);
                return;
            }
            if (AbstractIoUringChannel.this.delayedClose != null) {
                AbstractIoUringChannel.this.delayedClose.promise.addListener((GenericFutureListener)new PromiseNotifier(false, new Promise[]{promise}));
                return;
            }
            AbstractIoUringChannel.this.delayedClose = new DelayedClose(promise.isVoid() ? AbstractIoUringChannel.this.newPromise() : promise, cause, closeCause);
            boolean cancelConnect = false;
            try {
                ChannelPromise connectPromise = AbstractIoUringChannel.this.connectPromise;
                if (connectPromise != null) {
                    connectPromise.tryFailure((Throwable)new ClosedChannelException());
                    AbstractIoUringChannel.this.connectPromise = null;
                    cancelConnect = true;
                }
                AbstractIoUringChannel.this.cancelConnectTimeoutFuture();
            }
            finally {
                this.cancelOps(cancelConnect);
            }
            if (this.canCloseNow()) {
                this.closeNow();
            }
        }

        private void cancelOps(boolean cancelConnect) {
            long id;
            if (AbstractIoUringChannel.this.registration == null || !AbstractIoUringChannel.this.registration.isValid()) {
                return;
            }
            byte flags = 0;
            if ((AbstractIoUringChannel.this.ioState & 8) != 0 && AbstractIoUringChannel.this.pollRdhupId != 0L) {
                id = AbstractIoUringChannel.this.registration.submit((IoOps)IoUringIoOps.newAsyncCancel(flags, AbstractIoUringChannel.this.pollRdhupId, (short)6));
                assert (id != 0L);
                AbstractIoUringChannel.this.pollRdhupId = 0L;
            }
            if ((AbstractIoUringChannel.this.ioState & 1) != 0 && AbstractIoUringChannel.this.pollInId != 0L) {
                id = AbstractIoUringChannel.this.registration.submit((IoOps)IoUringIoOps.newAsyncCancel(flags, AbstractIoUringChannel.this.pollInId, (short)6));
                assert (id != 0L);
                AbstractIoUringChannel.this.pollInId = 0L;
            }
            if ((AbstractIoUringChannel.this.ioState & 4) != 0 && AbstractIoUringChannel.this.pollOutId != 0L) {
                id = AbstractIoUringChannel.this.registration.submit((IoOps)IoUringIoOps.newAsyncCancel(flags, AbstractIoUringChannel.this.pollOutId, (short)6));
                assert (id != 0L);
                AbstractIoUringChannel.this.pollOutId = 0L;
            }
            if (cancelConnect && AbstractIoUringChannel.this.connectId != 0L) {
                id = AbstractIoUringChannel.this.registration.submit((IoOps)IoUringIoOps.newAsyncCancel(flags, AbstractIoUringChannel.this.connectId, (short)16));
                assert (id != 0L);
                AbstractIoUringChannel.this.connectId = 0L;
            }
            AbstractIoUringChannel.this.cancelOutstandingReads(AbstractIoUringChannel.this.registration, AbstractIoUringChannel.this.numOutstandingReads);
            AbstractIoUringChannel.this.cancelOutstandingWrites(AbstractIoUringChannel.this.registration, AbstractIoUringChannel.this.numOutstandingWrites);
        }

        private boolean canCloseNow() {
            return this.canCloseNow0() && (AbstractIoUringChannel.this.ioState & 0x30) == 0;
        }

        protected boolean canCloseNow0() {
            return true;
        }

        private void closeNow() {
            super.close(AbstractIoUringChannel.this.newPromise(), AbstractIoUringChannel.this.delayedClose.cause, AbstractIoUringChannel.this.delayedClose.closeCause);
        }

        protected final void flush0() {
            if ((AbstractIoUringChannel.this.ioState & 4) == 0) {
                super.flush0();
            }
        }

        private void fulfillConnectPromise(ChannelPromise promise, Throwable cause) {
            if (promise == null) {
                return;
            }
            promise.tryFailure(cause);
            this.closeIfClosed();
        }

        private void fulfillConnectPromise(ChannelPromise promise, boolean wasActive) {
            if (promise == null) {
                return;
            }
            AbstractIoUringChannel.this.active = true;
            if (AbstractIoUringChannel.this.local == null) {
                AbstractIoUringChannel.this.local = AbstractIoUringChannel.this.socket.localAddress();
            }
            AbstractIoUringChannel.this.computeRemote();
            AbstractIoUringChannel.this.schedulePollRdHup();
            boolean active = AbstractIoUringChannel.this.isActive();
            boolean promiseSet = promise.trySuccess();
            if (!wasActive && active) {
                AbstractIoUringChannel.this.pipeline().fireChannelActive();
            }
            if (!promiseSet) {
                this.close(this.voidPromise());
            }
        }

        public final IoUringRecvByteAllocatorHandle recvBufAllocHandle() {
            if (this.allocHandle == null) {
                this.allocHandle = new IoUringRecvByteAllocatorHandle((RecvByteBufAllocator.ExtendedHandle)super.recvBufAllocHandle());
            }
            return this.allocHandle;
        }

        final void shutdownInput(boolean allDataRead) {
            logger.trace("shutdownInput Fd: {}", (Object)AbstractIoUringChannel.this.fd().intValue());
            if (!AbstractIoUringChannel.this.socket.isInputShutdown()) {
                if (AbstractIoUringChannel.isAllowHalfClosure(AbstractIoUringChannel.this.config())) {
                    try {
                        AbstractIoUringChannel.this.socket.shutdown(true, false);
                    }
                    catch (IOException ignored) {
                        this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                        return;
                    }
                    catch (NotYetConnectedException notYetConnectedException) {
                        // empty catch block
                    }
                    AbstractIoUringChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
                } else {
                    AbstractIoUringChannel.this.inputClosedSeenErrorOnRead = true;
                    this.close(this.voidPromise());
                    return;
                }
            }
            if (allDataRead && !AbstractIoUringChannel.this.inputClosedSeenErrorOnRead) {
                AbstractIoUringChannel.this.inputClosedSeenErrorOnRead = true;
                AbstractIoUringChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        private void fireEventAndClose(Object evt) {
            AbstractIoUringChannel.this.pipeline().fireUserEventTriggered(evt);
            this.close(this.voidPromise());
        }

        final void schedulePollIn() {
            assert ((AbstractIoUringChannel.this.ioState & 1) == 0);
            if (!AbstractIoUringChannel.this.isActive() || AbstractIoUringChannel.this.shouldBreakIoUringInReady(AbstractIoUringChannel.this.config())) {
                return;
            }
            AbstractIoUringChannel.this.pollInId = AbstractIoUringChannel.this.schedulePollAdd(1, Native.POLLIN, AbstractIoUringChannel.this.allowMultiShotPollIn());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readComplete(byte op, int res, int flags, short data) {
            boolean rearm;
            assert (AbstractIoUringChannel.this.numOutstandingReads > 0 || AbstractIoUringChannel.this.numOutstandingReads == -1) : AbstractIoUringChannel.access$1400(AbstractIoUringChannel.this);
            boolean multishot = AbstractIoUringChannel.this.numOutstandingReads == -1;
            boolean bl = rearm = (flags & 2) == 0;
            if (rearm) {
                AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState & -33);
            }
            boolean pending = AbstractIoUringChannel.this.readPending;
            if (multishot) {
                AbstractIoUringChannel.this.readPending = false;
            } else if ((AbstractIoUringChannel.this.numOutstandingReads = (short)(AbstractIoUringChannel.this.numOutstandingReads - 1)) == 0) {
                AbstractIoUringChannel.this.readPending = false;
                AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState & -33);
            }
            AbstractIoUringChannel.this.inReadComplete = true;
            try {
                this.socketIsEmpty = AbstractIoUringChannel.this.socketIsEmpty(flags);
                AbstractIoUringChannel.this.socketHasMoreData = IoUring.isCqeFSockNonEmptySupported() && (flags & 4) != 0;
                this.readComplete0(op, res, flags, data, AbstractIoUringChannel.this.numOutstandingReads);
            }
            finally {
                try {
                    if (this.recvBufAllocHandle().isReadComplete()) {
                        this.recvBufAllocHandle().reset(AbstractIoUringChannel.this.config());
                        if (!multishot) {
                            if (AbstractIoUringChannel.this.readPending) {
                                AbstractIoUringChannel.this.doBeginReadNow();
                            }
                        } else if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                            if (pending) {
                                AbstractIoUringChannel.this.doBeginReadNow();
                            }
                        } else if (rearm) {
                            AbstractIoUringChannel.this.doBeginReadNow();
                        } else if (!AbstractIoUringChannel.this.readPending) {
                            AbstractIoUringChannel.this.cancelOutstandingReads(AbstractIoUringChannel.this.registration, AbstractIoUringChannel.this.numOutstandingReads);
                        }
                    } else if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                        if (pending) {
                            AbstractIoUringChannel.this.doBeginReadNow();
                        }
                    } else if (multishot && rearm) {
                        AbstractIoUringChannel.this.doBeginReadNow();
                    }
                }
                finally {
                    AbstractIoUringChannel.this.inReadComplete = false;
                    this.socketIsEmpty = false;
                }
            }
        }

        protected abstract void readComplete0(byte var1, int var2, int var3, short var4, int var5);

        private void pollRdHup(int res) {
            AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState & -9);
            AbstractIoUringChannel.this.pollRdhupId = 0L;
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                return;
            }
            this.recvBufAllocHandle().rdHupReceived();
            if (AbstractIoUringChannel.this.isActive()) {
                this.scheduleFirstReadIfNeeded();
            } else {
                this.shutdownInput(false);
            }
        }

        private void pollIn(int res, int flags, short data) {
            boolean rearm;
            boolean bl = rearm = (flags & 2) == 0;
            if (rearm) {
                AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState & -2);
                AbstractIoUringChannel.this.pollInId = 0L;
            }
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                return;
            }
            if (!AbstractIoUringChannel.this.readPending) {
                AbstractIoUringChannel.this.socketHasMoreData = true;
                return;
            }
            this.scheduleFirstReadIfNeeded();
        }

        private void scheduleFirstReadIfNeeded() {
            if ((AbstractIoUringChannel.this.ioState & 0x20) == 0) {
                this.scheduleFirstRead();
            }
        }

        private void scheduleFirstRead() {
            ChannelConfig config = AbstractIoUringChannel.this.config();
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            this.scheduleRead(true);
        }

        protected final void scheduleRead(boolean first) {
            if (AbstractIoUringChannel.this.delayedClose == null && AbstractIoUringChannel.this.fd().isOpen() && (AbstractIoUringChannel.this.ioState & 0x20) == 0) {
                AbstractIoUringChannel.this.numOutstandingReads = (short)this.scheduleRead0(first, this.socketIsEmpty);
                if (AbstractIoUringChannel.this.numOutstandingReads > 0 || AbstractIoUringChannel.this.numOutstandingReads == -1) {
                    AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState | 32);
                }
            }
        }

        protected abstract int scheduleRead0(boolean var1, boolean var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pollOut(int res) {
            AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState & -5);
            AbstractIoUringChannel.this.pollOutId = 0L;
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                return;
            }
            if (AbstractIoUringChannel.this.connectPromise != null) {
                assert (AbstractIoUringChannel.this.eventLoop().inEventLoop());
                boolean connectStillInProgress = false;
                try {
                    boolean wasActive = AbstractIoUringChannel.this.isActive();
                    if (!AbstractIoUringChannel.this.socket.finishConnect()) {
                        connectStillInProgress = true;
                        return;
                    }
                    this.fulfillConnectPromise(AbstractIoUringChannel.this.connectPromise, wasActive);
                }
                catch (Throwable t) {
                    this.fulfillConnectPromise(AbstractIoUringChannel.this.connectPromise, this.annotateConnectException(t, AbstractIoUringChannel.this.requestedRemoteAddress));
                }
                finally {
                    if (!connectStillInProgress) {
                        AbstractIoUringChannel.this.cancelConnectTimeoutFuture();
                        AbstractIoUringChannel.this.connectPromise = null;
                    } else {
                        AbstractIoUringChannel.this.schedulePollOut();
                    }
                }
            } else if (!AbstractIoUringChannel.this.socket.isOutputShutdown()) {
                super.flush0();
            }
        }

        private void writeComplete(byte op, int res, int flags, short data) {
            boolean writtenAll;
            if ((AbstractIoUringChannel.this.ioState & 0x40) != 0) {
                AbstractIoUringChannel.this.freeMsgHdrArray();
                if (res > 0) {
                    this.outboundBuffer().removeBytes((long)res);
                    this.connectComplete(op, 0, flags, data);
                } else if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE || res == 0) {
                    AbstractIoUringChannel.this.submitConnect((InetSocketAddress)AbstractIoUringChannel.this.requestedRemoteAddress);
                } else {
                    this.connectComplete(op, res, flags, data);
                }
                return;
            }
            if ((flags & 8) == 0) {
                assert (AbstractIoUringChannel.this.numOutstandingWrites > 0);
                AbstractIoUringChannel.this.numOutstandingWrites = (short)(AbstractIoUringChannel.this.numOutstandingWrites - 1);
            }
            if (!(writtenAll = this.writeComplete0(op, res, flags, data, AbstractIoUringChannel.this.numOutstandingWrites)) && (AbstractIoUringChannel.this.ioState & 4) == 0) {
                AbstractIoUringChannel.this.schedulePollOut();
            }
            if (AbstractIoUringChannel.this.numOutstandingWrites == 0) {
                AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState & -17);
                if (writtenAll && (AbstractIoUringChannel.this.ioState & 4) == 0) {
                    AbstractIoUringChannel.this.scheduleWriteIfNeeded(AbstractIoUringChannel.this.unsafe().outboundBuffer(), false);
                }
            }
        }

        abstract boolean writeComplete0(byte var1, int var2, int var3, short var4, int var5);

        void cancelComplete0(byte op, int res, int flags, short data) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connectComplete(byte op, int res, int flags, short data) {
            AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState & -65);
            AbstractIoUringChannel.this.freeRemoteAddressMemory();
            if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE || res == Errors.ERROR_EALREADY_NEGATIVE) {
                AbstractIoUringChannel.this.schedulePollOut();
            } else {
                try {
                    if (res == 0) {
                        this.fulfillConnectPromise(AbstractIoUringChannel.this.connectPromise, AbstractIoUringChannel.this.active);
                        if (AbstractIoUringChannel.this.readPending) {
                            AbstractIoUringChannel.this.doBeginReadNow();
                        }
                    } else {
                        try {
                            Errors.throwConnectException((String)"io_uring connect", (int)res);
                        }
                        catch (Throwable cause) {
                            this.fulfillConnectPromise(AbstractIoUringChannel.this.connectPromise, cause);
                        }
                    }
                }
                finally {
                    AbstractIoUringChannel.this.cancelConnectTimeoutFuture();
                    AbstractIoUringChannel.this.connectPromise = null;
                }
            }
        }

        public void connect(final SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (promise.isDone() || !this.ensureOpen(promise)) {
                return;
            }
            if (AbstractIoUringChannel.this.delayedClose != null) {
                promise.tryFailure(this.annotateConnectException(new ClosedChannelException(), remoteAddress));
                return;
            }
            try {
                if (AbstractIoUringChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                if (localAddress instanceof InetSocketAddress) {
                    AbstractIoUringChannel.checkResolvable((InetSocketAddress)localAddress);
                }
                if (remoteAddress instanceof InetSocketAddress) {
                    AbstractIoUringChannel.checkResolvable((InetSocketAddress)remoteAddress);
                }
                if (AbstractIoUringChannel.this.remote != null) {
                    throw new AlreadyConnectedException();
                }
                if (localAddress != null) {
                    AbstractIoUringChannel.this.socket.bind(localAddress);
                }
                if (remoteAddress instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                    ByteBuf initialData = null;
                    if (IoUring.isTcpFastOpenClientSideAvailable() && AbstractIoUringChannel.this.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT) == Boolean.TRUE) {
                        ChannelOutboundBuffer outbound = AbstractIoUringChannel.this.unsafe().outboundBuffer();
                        outbound.addFlush();
                        Object curr = outbound.current();
                        if (curr instanceof ByteBuf) {
                            initialData = (ByteBuf)curr;
                        }
                    }
                    if (initialData != null) {
                        AbstractIoUringChannel.this.msgHdrMemoryArray = new MsgHdrMemoryArray(1);
                        MsgHdrMemory hdr = AbstractIoUringChannel.this.msgHdrMemoryArray.hdr(0);
                        hdr.set(AbstractIoUringChannel.this.socket, inetSocketAddress, IoUring.memoryAddress(initialData), initialData.readableBytes(), (short)0);
                        int fd = AbstractIoUringChannel.this.fd().intValue();
                        IoRegistration registration = AbstractIoUringChannel.this.registration();
                        IoUringIoOps ops = IoUringIoOps.newSendmsg(fd, (byte)0, Native.MSG_FASTOPEN, hdr.address(), hdr.idx());
                        AbstractIoUringChannel.this.connectId = registration.submit((IoOps)ops);
                        if (AbstractIoUringChannel.this.connectId == 0L) {
                            AbstractIoUringChannel.this.freeMsgHdrArray();
                        }
                    } else {
                        AbstractIoUringChannel.this.submitConnect(inetSocketAddress);
                    }
                } else if (remoteAddress instanceof DomainSocketAddress) {
                    DomainSocketAddress unixDomainSocketAddress = (DomainSocketAddress)remoteAddress;
                    AbstractIoUringChannel.this.submitConnect(unixDomainSocketAddress);
                } else {
                    throw new Error("Unexpected SocketAddress implementation " + String.valueOf(remoteAddress));
                }
                if (AbstractIoUringChannel.this.connectId != 0L) {
                    AbstractIoUringChannel.this.ioState = (byte)(AbstractIoUringChannel.this.ioState | 64);
                }
            }
            catch (Throwable t) {
                this.closeIfClosed();
                promise.tryFailure(this.annotateConnectException(t, remoteAddress));
                return;
            }
            AbstractIoUringChannel.this.connectPromise = promise;
            AbstractIoUringChannel.this.requestedRemoteAddress = remoteAddress;
            int connectTimeoutMillis = AbstractIoUringChannel.this.config().getConnectTimeoutMillis();
            if (connectTimeoutMillis > 0) {
                AbstractIoUringChannel.this.connectTimeoutFuture = (ScheduledFuture)AbstractIoUringChannel.this.eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ChannelPromise connectPromise = AbstractIoUringChannel.this.connectPromise;
                        if (connectPromise != null && !connectPromise.isDone() && connectPromise.tryFailure((Throwable)new ConnectTimeoutException("connection timed out: " + String.valueOf(remoteAddress)))) {
                            AbstractUringUnsafe.this.close(AbstractUringUnsafe.this.voidPromise());
                        }
                    }
                }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isCancelled()) {
                        AbstractIoUringChannel.this.cancelConnectTimeoutFuture();
                        AbstractIoUringChannel.this.connectPromise = null;
                        AbstractUringUnsafe.this.close(AbstractUringUnsafe.this.voidPromise());
                    }
                }
            });
        }
    }

    private static final class DelayedClose {
        private final ChannelPromise promise;
        private final Throwable cause;
        private final ClosedChannelException closeCause;

        DelayedClose(ChannelPromise promise, Throwable cause, ClosedChannelException closeCause) {
            this.promise = promise;
            this.cause = cause;
            this.closeCause = closeCause;
        }
    }
}

