/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import monix.execution.internal.Platform$;
import monix.execution.internal.math$;
import monix.execution.internals.atomic.UnsafeAccess;
import monix.reactive.observers.buffers.ConcurrentQueue;
import org.jctools.queues.MpscArrayQueue;
import org.jctools.queues.MpscChunkedArrayQueue;
import org.jctools.queues.MpscLinkedQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jctools.queues.atomic.MpscAtomicArrayQueue;
import org.jctools.queues.atomic.MpscLinkedAtomicQueue;
import scala.math.package$;

public final class ConcurrentQueue$ {
    public static ConcurrentQueue$ MODULE$;

    static {
        new ConcurrentQueue$();
    }

    public <A> ConcurrentQueue<A> limited(int capacity) {
        ConcurrentQueue concurrentQueue;
        int maxCapacity = package$.MODULE$.max(4, math$.MODULE$.nextPowerOf2(capacity));
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            MpscArrayQueue mpscArrayQueue;
            if (maxCapacity <= Platform$.MODULE$.recommendedBatchSize()) {
                mpscArrayQueue = new MpscArrayQueue(maxCapacity);
            } else {
                int initialCapacity = package$.MODULE$.min(Platform$.MODULE$.recommendedBatchSize(), maxCapacity / 2);
                mpscArrayQueue = new MpscChunkedArrayQueue(initialCapacity, maxCapacity);
            }
            concurrentQueue = new ConcurrentQueue.FromMessagePassingQueue(mpscArrayQueue);
        } else {
            concurrentQueue = new ConcurrentQueue.FromAbstractQueue(new MpscAtomicArrayQueue(maxCapacity));
        }
        return concurrentQueue;
    }

    public <A> ConcurrentQueue<A> unbounded(boolean isBatched) {
        ConcurrentQueue concurrentQueue;
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            concurrentQueue = new ConcurrentQueue.FromMessagePassingQueue(isBatched ? new MpscUnboundedArrayQueue(Platform$.MODULE$.recommendedBatchSize()) : MpscLinkedQueue.newMpscLinkedQueue());
        } else {
            MpscLinkedAtomicQueue ref = new MpscLinkedAtomicQueue();
            concurrentQueue = new ConcurrentQueue.FromAbstractQueue(ref);
        }
        return concurrentQueue;
    }

    private ConcurrentQueue$() {
        MODULE$ = this;
    }
}

