/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.rstreams;

import monix.execution.Ack;
import monix.execution.Ack$Continue$;
import monix.execution.Scheduler;
import monix.reactive.internal.rstreams.SyncSubscriberAsReactiveSubscriber$;
import monix.reactive.observers.Subscriber;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!B\u0001\u0003\u0005!Q!AI*z]\u000e\u001cVOY:de&\u0014WM]!t%\u0016\f7\r^5wKN+(m]2sS\n,'O\u0003\u0002\u0004\t\u0005A!o\u001d;sK\u0006l7O\u0003\u0002\u0006\r\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\b\u0011\u0005A!/Z1di&4XMC\u0001\n\u0003\u0015iwN\\5y+\tYadE\u0002\u0001\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0004+iaR\"\u0001\f\u000b\u0005]A\u0012a\u0004:fC\u000e$\u0018N^3tiJ,\u0017-\\:\u000b\u0003e\t1a\u001c:h\u0013\tYbC\u0001\u0006Tk\n\u001c8M]5cKJ\u0004\"!\b\u0010\r\u0001\u0011)q\u0004\u0001b\u0001C\t\tAk\u0001\u0001\u0012\u0005\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#a\u0002(pi\"Lgn\u001a\t\u0003G%J!A\u000b\u0013\u0003\u0007\u0005s\u0017\u0010\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003)\u0019XOY:de&\u0014WM\u001d\t\u0004]QbbBA\u00183\u001b\u0005\u0001$BA\u0019\u0007\u0003%y'm]3sm\u0016\u00148/\u0003\u00024a\u0005Q1+\u001e2tGJL'-\u001a:\n\u0005U2$\u0001B*z]\u000eT!a\r\u0019\t\u0011a\u0002!\u0011!Q\u0001\ne\nAB]3rk\u0016\u001cHoQ8v]R\u0004\"a\t\u001e\n\u0005m\"#aA%oi\")Q\b\u0001C\u0005}\u00051A(\u001b8jiz\"2aP!C!\r\u0001\u0005\u0001H\u0007\u0002\u0005!)A\u0006\u0010a\u0001[!)\u0001\b\u0010a\u0001s!1A\t\u0001Q\u0001\f\u0015\u000b\u0011a\u001d\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\"\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005);%!C*dQ\u0016$W\u000f\\3s\u0011\u0019a\u0005\u0001)Q\u0005\u001b\u0006a1/\u001e2tGJL\u0007\u000f^5p]B\u0011QCT\u0005\u0003\u001fZ\u0011AbU;cg\u000e\u0014\u0018\u000e\u001d;j_:Da!\u0015\u0001!B\u0013I\u0014AD3ya\u0016\u001cG/\u001b8h\u0007>,h\u000e\u001e\u0005\u0007'\u0002\u0001\u000b\u0015\u0002+\u0002\u0015%\u001c8)\u00198dK2,G\r\u0005\u0002$+&\u0011a\u000b\n\u0002\b\u0005>|G.Z1oQ\t\u0011\u0006\f\u0005\u0002$3&\u0011!\f\n\u0002\tm>d\u0017\r^5mK\")A\f\u0001C\u0001;\u0006YqN\\*vEN\u001c'/\u001b2f)\tq\u0016\r\u0005\u0002$?&\u0011\u0001\r\n\u0002\u0005+:LG\u000fC\u0003E7\u0002\u0007Q\nC\u0003d\u0001\u0011\u0005A-\u0001\u0004p]:+\u0007\u0010\u001e\u000b\u0003=\u0016DQA\u001a2A\u0002q\tA!\u001a7f[\")\u0001\u000e\u0001C\u0001S\u00069qN\\#se>\u0014HC\u00010k\u0011\u0015Yw\r1\u0001m\u0003\t)\u0007\u0010\u0005\u0002nk:\u0011an\u001d\b\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\u0002\na\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005Q$\u0013a\u00029bG.\fw-Z\u0005\u0003m^\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005Q$\u0003\"B=\u0001\t\u0003Q\u0018AC8o\u0007>l\u0007\u000f\\3uKR\tal\u0002\u0004}\u0005!\u0005\u0001\"`\u0001#'ft7mU;cg\u000e\u0014\u0018NY3s\u0003N\u0014V-Y2uSZ,7+\u001e2tGJL'-\u001a:\u0011\u0005\u0001shAB\u0001\u0003\u0011\u0003AqpE\u0002\u007f\u0003\u0003\u00012aIA\u0002\u0013\r\t)\u0001\n\u0002\u0007\u0003:L(+\u001a4\t\rurH\u0011AA\u0005)\u0005i\bbBA\u0007}\u0012\u0005\u0011qB\u0001\u0006CB\u0004H._\u000b\u0005\u0003#\t9\u0002\u0006\u0004\u0002\u0014\u0005e\u0011Q\u0004\t\u0005+i\t)\u0002E\u0002\u001e\u0003/!aaHA\u0006\u0005\u0004\t\u0003b\u0002\u0017\u0002\f\u0001\u0007\u00111\u0004\t\u0005]Q\n)\u0002\u0003\u00059\u0003\u0017\u0001\n\u00111\u0001:\u0011%\t\tC`I\u0001\n\u0003\t\u0019#A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\t)#a\u000f\u0016\u0005\u0005\u001d\"fA\u001d\u0002*-\u0012\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003%)hn\u00195fG.,GMC\u0002\u00026\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI$a\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004 \u0003?\u0011\r!\t")
public final class SyncSubscriberAsReactiveSubscriber<T>
implements Subscriber<T> {
    private final Subscriber.Sync<T> subscriber;
    private final int requestCount;
    private final Scheduler s;
    private Subscription subscription;
    private int expectingCount;
    private volatile boolean isCanceled;

    public static <T> int apply$default$2() {
        return SyncSubscriberAsReactiveSubscriber$.MODULE$.apply$default$2();
    }

    public static <T> Subscriber<T> apply(Subscriber.Sync<T> sync, int n) {
        return SyncSubscriberAsReactiveSubscriber$.MODULE$.apply(sync, n);
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription == null && !this.isCanceled) {
            this.subscription = s;
            this.expectingCount = this.requestCount;
            s.request((long)this.requestCount);
        } else {
            s.cancel();
        }
    }

    public void onNext(T elem) {
        if (this.subscription == null) {
            throw new NullPointerException("onSubscription never happened, see rule 2.13 in the Reactive Streams spec");
        }
        if (elem == null) {
            throw new NullPointerException("onNext(null) is forbidden, see rule 2.13 in the Reactive Streams spec");
        }
        if (!this.isCanceled) {
            Ack ack;
            if (this.expectingCount > 0) {
                --this.expectingCount;
            }
            if (Ack$Continue$.MODULE$.equals(ack = this.subscriber.onNext(elem))) {
                BoxedUnit boxedUnit;
                if (this.expectingCount == 0) {
                    this.expectingCount = this.requestCount;
                    this.subscription.request((long)this.requestCount);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (Ack.Stop$.MODULE$.equals(ack)) {
                this.isCanceled = true;
                this.subscription.cancel();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)ack);
            }
        }
    }

    public void onError(Throwable ex) {
        block1: {
            if (ex == null) {
                throw new NullPointerException("onError(null) is forbidden, see rule 2.13 in the Reactive Streams spec");
            }
            if (this.isCanceled) break block1;
            this.isCanceled = true;
            this.subscriber.onError(ex);
        }
    }

    public void onComplete() {
        block0: {
            if (this.isCanceled) break block0;
            this.isCanceled = true;
            this.subscriber.onComplete();
        }
    }

    public SyncSubscriberAsReactiveSubscriber(Subscriber.Sync<T> subscriber, int requestCount) {
        this.subscriber = subscriber;
        this.requestCount = requestCount;
        Predef$.MODULE$.require(requestCount > 0, (Function0 & java.io.Serializable & Serializable)() -> "requestCount must be strictly positive, according to the Reactive Streams contract");
        this.s = subscriber.scheduler();
        this.subscription = null;
        this.expectingCount = 0;
        this.isCanceled = false;
    }
}

