/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.dynamodb.repository;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.Put;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItem;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.dynamodb.repository.ChangeEntryDynamoDB;
import io.mongock.driver.dynamodb.repository.DynamoDBChangeEntryRepositoryKt;
import io.mongock.driver.dynamodb.repository.DynamoDBTransactionItems;
import io.mongock.driver.dynamodb.repository.DynamoDbRepositoryBase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u001c\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0019H\u0016R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lio/mongock/driver/dynamodb/repository/DynamoDBChangeEntryRepository;", "Lio/mongock/driver/dynamodb/repository/DynamoDbRepositoryBase;", "Lio/mongock/driver/api/entry/ChangeEntryService;", "client", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;", "tableName", "", "indexCreation", "", "provisionedThroughput", "Lcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;", "(Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;Ljava/lang/String;ZLcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;)V", "transactionItems", "Lio/mongock/driver/dynamodb/repository/DynamoDBTransactionItems;", "getTransactionItems", "()Lio/mongock/driver/dynamodb/repository/DynamoDBTransactionItems;", "setTransactionItems", "(Lio/mongock/driver/dynamodb/repository/DynamoDBTransactionItems;)V", "cleanTransactionRequest", "", "ensureField", "field", "Ljava/lang/reflect/Field;", "getEntriesLog", "", "Lio/mongock/driver/api/entry/ChangeEntry;", "isAlreadyExecuted", "changeSetId", "author", "saveOrUpdate", "changeEntry", "dynamodb-driver"})
public final class DynamoDBChangeEntryRepository
extends DynamoDbRepositoryBase
implements ChangeEntryService {
    @Nullable
    private DynamoDBTransactionItems transactionItems;

    public DynamoDBChangeEntryRepository(@NotNull AmazonDynamoDBClient client, @NotNull String tableName, boolean indexCreation, @Nullable ProvisionedThroughput provisionedThroughput) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        super(client, tableName, Reflection.getOrCreateKotlinClass(ChangeEntryDynamoDB.class), indexCreation, provisionedThroughput);
    }

    @Nullable
    public final DynamoDBTransactionItems getTransactionItems() {
        return this.transactionItems;
    }

    public final void setTransactionItems(@Nullable DynamoDBTransactionItems dynamoDBTransactionItems) {
        this.transactionItems = dynamoDBTransactionItems;
    }

    public boolean isAlreadyExecuted(@Nullable String changeSetId, @Nullable String author) {
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"THIS WILL SOON BE DELETED. It shouldn't be used"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChangeEntry> getEntriesLog() {
        void $this$mapTo$iv$iv;
        PaginatedScanList paginatedScanList = this.getMapper().scan(ChangeEntryDynamoDB.class, new DynamoDBScanExpression(), DynamoDBMapperConfig.builder().withConsistentReads(DynamoDBMapperConfig.ConsistentReads.CONSISTENT).build());
        Intrinsics.checkNotNullExpressionValue((Object)paginatedScanList, (String)"mapper.scan(\n           \u2026ISTENT).build()\n        )");
        Iterable $this$map$iv = (Iterable)paginatedScanList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChangeEntryDynamoDB changeEntryDynamoDB = (ChangeEntryDynamoDB)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChangeEntry$dynamodb_driver());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public void saveOrUpdate(@NotNull ChangeEntry changeEntry) {
        Intrinsics.checkNotNullParameter((Object)changeEntry, (String)"changeEntry");
        ChangeEntryDynamoDB changeEntryDynamoDB = new ChangeEntryDynamoDB(changeEntry);
        if (this.transactionItems == null) {
            PutItemRequest request = new PutItemRequest().withTableName(this.getTableName()).withItem(changeEntryDynamoDB.getAttributes$dynamodb_driver());
            DynamoDBChangeEntryRepositoryKt.access$getLogger$p().debug(Intrinsics.stringPlus((String)"Upserting changeEntry: ", (Object)request));
            PutItemResult result = this.getClient().putItem(request);
            DynamoDBChangeEntryRepositoryKt.access$getLogger$p().debug(Intrinsics.stringPlus((String)"Upsert performed: ", (Object)result));
        } else {
            Put put = new Put().withTableName(this.getTableName()).withItem(changeEntryDynamoDB.getAttributes$dynamodb_driver());
            DynamoDBChangeEntryRepositoryKt.access$getLogger$p().debug(Intrinsics.stringPlus((String)"Added element to transactionItems: ", (Object)put));
            DynamoDBTransactionItems dynamoDBTransactionItems = this.transactionItems;
            Intrinsics.checkNotNull((Object)dynamoDBTransactionItems);
            TransactWriteItem transactWriteItem = new TransactWriteItem().withPut(put);
            Intrinsics.checkNotNullExpressionValue((Object)transactWriteItem, (String)"TransactWriteItem().withPut(put)");
            dynamoDBTransactionItems.addChangeEntry$dynamodb_driver(transactWriteItem);
        }
    }

    public void ensureField(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
    }

    public final void cleanTransactionRequest() {
        this.transactionItems = null;
    }
}

