/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.dynamodb.driver;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsResult;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.Transactional;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.core.driver.TransactionalConnectionDriverBase;
import io.mongock.driver.core.lock.LockRepository;
import io.mongock.driver.dynamodb.driver.DynamoDBDriverBase;
import io.mongock.driver.dynamodb.driver.DynamoDBDriverBaseKt;
import io.mongock.driver.dynamodb.repository.DynamoDBChangeEntryRepository;
import io.mongock.driver.dynamodb.repository.DynamoDBLockRepository;
import io.mongock.driver.dynamodb.repository.DynamoDBTransactionItems;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B'\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120'H\u0016J\b\u0010(\u001a\u00020)H\u0014J\u0012\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0+H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0016J\b\u0010/\u001a\u00020!H\u0016J\b\u00100\u001a\u00020!H\u0014R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/mongock/driver/dynamodb/driver/DynamoDBDriverBase;", "Lio/mongock/driver/core/driver/TransactionalConnectionDriverBase;", "Lio/mongock/driver/api/driver/Transactional;", "client", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;", "lockAcquiredForMillis", "", "lockQuitTryingAfterMillis", "lockTryFrequencyMillis", "(Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;JJJ)V", "_changeEntryService", "Lio/mongock/driver/dynamodb/repository/DynamoDBChangeEntryRepository;", "get_changeEntryService", "()Lio/mongock/driver/dynamodb/repository/DynamoDBChangeEntryRepository;", "_changeEntryService$delegate", "Lkotlin/Lazy;", "_dependencies", "", "Lio/mongock/driver/api/driver/ChangeSetDependency;", "_lockRepository", "Lio/mongock/driver/dynamodb/repository/DynamoDBLockRepository;", "get_lockRepository", "()Lio/mongock/driver/dynamodb/repository/DynamoDBLockRepository;", "_lockRepository$delegate", "provisionedThroughput", "Lcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;", "getProvisionedThroughput", "()Lcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;", "setProvisionedThroughput", "(Lcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;)V", "transactionItems", "Lio/mongock/driver/dynamodb/repository/DynamoDBTransactionItems;", "executeInTransaction", "", "operation", "Ljava/lang/Runnable;", "getChangeEntryService", "Lio/mongock/driver/api/entry/ChangeEntryService;", "getDependencies", "", "getLockRepository", "Lio/mongock/driver/core/lock/LockRepository;", "getNonProxyableTypes", "", "Ljava/lang/Class;", "getTransactioner", "Ljava/util/Optional;", "prepareForExecutionBlock", "specificInitialization", "dynamodb-driver"})
public abstract class DynamoDBDriverBase
extends TransactionalConnectionDriverBase
implements Transactional {
    @NotNull
    private final AmazonDynamoDBClient client;
    @Nullable
    private ProvisionedThroughput provisionedThroughput;
    @NotNull
    private final Set<ChangeSetDependency> _dependencies;
    @NotNull
    private final Lazy _changeEntryService$delegate;
    @NotNull
    private final Lazy _lockRepository$delegate;
    @Nullable
    private DynamoDBTransactionItems transactionItems;

    protected DynamoDBDriverBase(@NotNull AmazonDynamoDBClient client, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
        this.client = client;
        this.provisionedThroughput = new ProvisionedThroughput(Long.valueOf(50L), Long.valueOf(50L));
        this._dependencies = new HashSet();
        this._changeEntryService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DynamoDBChangeEntryRepository>(this){
            final /* synthetic */ DynamoDBDriverBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DynamoDBChangeEntryRepository invoke() {
                AmazonDynamoDBClient amazonDynamoDBClient = DynamoDBDriverBase.access$getClient$p(this.this$0);
                String string = this.this$0.getMigrationRepositoryName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMigrationRepositoryName()");
                return new DynamoDBChangeEntryRepository(amazonDynamoDBClient, string, DynamoDBDriverBase.access$getIndexCreation$p$s-294330367(this.this$0), this.this$0.getProvisionedThroughput());
            }
        }));
        this._lockRepository$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DynamoDBLockRepository>(this){
            final /* synthetic */ DynamoDBDriverBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DynamoDBLockRepository invoke() {
                AmazonDynamoDBClient amazonDynamoDBClient = DynamoDBDriverBase.access$getClient$p(this.this$0);
                String string = this.this$0.getLockRepositoryName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLockRepositoryName()");
                return new DynamoDBLockRepository(amazonDynamoDBClient, string, DynamoDBDriverBase.access$getIndexCreation$p$s-294330367(this.this$0), this.this$0.getProvisionedThroughput() != null ? new ProvisionedThroughput(Long.valueOf(1L), Long.valueOf(1L)) : null);
            }
        }));
    }

    @Nullable
    public final ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public final void setProvisionedThroughput(@Nullable ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    private final DynamoDBChangeEntryRepository get_changeEntryService() {
        Lazy lazy = this._changeEntryService$delegate;
        return (DynamoDBChangeEntryRepository)lazy.getValue();
    }

    private final DynamoDBLockRepository get_lockRepository() {
        Lazy lazy = this._lockRepository$delegate;
        return (DynamoDBLockRepository)lazy.getValue();
    }

    protected void specificInitialization() {
        this._dependencies.add(new ChangeSetDependency(ChangeEntryService.class, (Object)this.getChangeEntryService(), false));
    }

    @NotNull
    protected LockRepository getLockRepository() {
        return this.get_lockRepository();
    }

    @NotNull
    public ChangeEntryService getChangeEntryService() {
        return this.get_changeEntryService();
    }

    @NotNull
    public Optional<Transactional> getTransactioner() {
        Optional<Transactional> optional = Optional.ofNullable(this.transactionEnabled ? this : null);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(if (transactionEnabled) this else null)");
        return optional;
    }

    @NotNull
    public Set<ChangeSetDependency> getDependencies() {
        Optional<ChangeSetDependency> currentTransactionItemsOpt = this._dependencies.stream().filter(DynamoDBDriverBase::getDependencies$lambda-0).findAny();
        if (currentTransactionItemsOpt.isPresent()) {
            this._dependencies.remove(currentTransactionItemsOpt.get());
        }
        if (this.transactionItems != null) {
            this._dependencies.add(new ChangeSetDependency(DynamoDBTransactionItems.class, (Object)this.transactionItems, true));
        }
        return this._dependencies;
    }

    @NotNull
    public List<Class<?>> getNonProxyableTypes() {
        Object[] objectArray = new Class[]{DynamoDBMapper.class, DynamoDBTransactionItems.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void prepareForExecutionBlock() {
        this.transactionItems = new DynamoDBTransactionItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInTransaction(@NotNull Runnable operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        try {
            this.get_changeEntryService().setTransactionItems(this.transactionItems);
            operation.run();
            DynamoDBTransactionItems dynamoDBTransactionItems = this.transactionItems;
            Intrinsics.checkNotNull((Object)dynamoDBTransactionItems);
            if (!dynamoDBTransactionItems.containsUserTransactions()) {
                DynamoDBDriverBaseKt.access$getLogger$p().debug((Function0)executeInTransaction.1.INSTANCE);
            }
            DynamoDBTransactionItems dynamoDBTransactionItems2 = this.transactionItems;
            Intrinsics.checkNotNull((Object)dynamoDBTransactionItems2);
            if (dynamoDBTransactionItems2.containsAnyTransaction()) {
                TransactWriteItemsRequest transactWriteItemsRequest = new TransactWriteItemsRequest();
                DynamoDBTransactionItems dynamoDBTransactionItems3 = this.transactionItems;
                Intrinsics.checkNotNull((Object)dynamoDBTransactionItems3);
                TransactWriteItemsResult result = this.client.transactWriteItems(transactWriteItemsRequest.withTransactItems((Collection)dynamoDBTransactionItems3.getItems$dynamodb_driver()).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL));
                DynamoDBDriverBaseKt.access$getLogger$p().debug((Function0)new Function0<Object>(result){
                    final /* synthetic */ TransactWriteItemsResult $result;
                    {
                        this.$result = $result;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return Intrinsics.stringPlus((String)"DynamoDB transaction successful: ", (Object)this.$result);
                    }
                });
            }
        }
        catch (Throwable ex) {
            throw new MongockException(ex);
        }
        finally {
            this.get_changeEntryService().cleanTransactionRequest();
            this.transactionItems = null;
            this.removeDependencyIfAssignableFrom(this._dependencies, DynamoDBTransactionItems.class);
        }
    }

    private static final boolean getDependencies$lambda-0(ChangeSetDependency it) {
        return Intrinsics.areEqual((Object)it.getType(), DynamoDBTransactionItems.class);
    }

    public static final /* synthetic */ AmazonDynamoDBClient access$getClient$p(DynamoDBDriverBase $this) {
        return $this.client;
    }

    public static final /* synthetic */ boolean access$getIndexCreation$p$s-294330367(DynamoDBDriverBase $this) {
        return $this.indexCreation;
    }
}

