/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.DefaultMcpStatelessServerHandler;
import io.modelcontextprotocol.server.McpStatelessRequestHandler;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.spec.JsonSchemaValidator;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.DeafaultMcpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.McpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.Utils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class McpStatelessAsyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpStatelessAsyncServer.class);
    private final McpStatelessServerTransport mcpTransportProvider;
    private final ObjectMapper objectMapper;
    private final McpSchema.ServerCapabilities serverCapabilities;
    private final McpSchema.Implementation serverInfo;
    private final String instructions;
    private final CopyOnWriteArrayList<McpStatelessServerFeatures.AsyncToolSpecification> tools = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.AsyncResourceSpecification> resources = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.AsyncPromptSpecification> prompts = new ConcurrentHashMap();
    private final ConcurrentHashMap<McpSchema.CompleteReference, McpStatelessServerFeatures.AsyncCompletionSpecification> completions = new ConcurrentHashMap();
    private List<String> protocolVersions;
    private McpUriTemplateManagerFactory uriTemplateManagerFactory = new DeafaultMcpUriTemplateManagerFactory();
    private final JsonSchemaValidator jsonSchemaValidator;

    McpStatelessAsyncServer(McpStatelessServerTransport mcpTransport, ObjectMapper objectMapper, McpStatelessServerFeatures.Async features, Duration requestTimeout, McpUriTemplateManagerFactory uriTemplateManagerFactory, JsonSchemaValidator jsonSchemaValidator) {
        this.mcpTransportProvider = mcpTransport;
        this.objectMapper = objectMapper;
        this.serverInfo = features.serverInfo();
        this.serverCapabilities = features.serverCapabilities();
        this.instructions = features.instructions();
        this.tools.addAll(McpStatelessAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, features.tools()));
        this.resources.putAll(features.resources());
        this.resourceTemplates.addAll(features.resourceTemplates());
        this.prompts.putAll(features.prompts());
        this.completions.putAll(features.completions());
        this.uriTemplateManagerFactory = uriTemplateManagerFactory;
        this.jsonSchemaValidator = jsonSchemaValidator;
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("ping", (ctx, params) -> Mono.just(Map.of()));
        requestHandlers.put("initialize", this.asyncInitializeRequestHandler());
        if (this.serverCapabilities.tools() != null) {
            requestHandlers.put("tools/list", this.toolsListRequestHandler());
            requestHandlers.put("tools/call", this.toolsCallRequestHandler());
        }
        if (this.serverCapabilities.resources() != null) {
            requestHandlers.put("resources/list", this.resourcesListRequestHandler());
            requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
            requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
        }
        if (this.serverCapabilities.prompts() != null) {
            requestHandlers.put("prompts/list", this.promptsListRequestHandler());
            requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
        }
        if (this.serverCapabilities.completions() != null) {
            requestHandlers.put("completion/complete", this.completionCompleteRequestHandler());
        }
        this.protocolVersions = new ArrayList<String>(mcpTransport.protocolVersions());
        DefaultMcpStatelessServerHandler handler = new DefaultMcpStatelessServerHandler(requestHandlers, Map.of());
        mcpTransport.setMcpHandler(handler);
    }

    private McpStatelessRequestHandler<McpSchema.InitializeResult> asyncInitializeRequestHandler() {
        return (ctx, req) -> Mono.defer(() -> {
            McpSchema.InitializeRequest initializeRequest = (McpSchema.InitializeRequest)this.objectMapper.convertValue(req, McpSchema.InitializeRequest.class);
            logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.protocolVersion(), initializeRequest.capabilities(), initializeRequest.clientInfo()});
            String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
            if (this.protocolVersions.contains(initializeRequest.protocolVersion())) {
                serverProtocolVersion = initializeRequest.protocolVersion();
            } else {
                logger.warn("Client requested unsupported protocol version: {}, so the server will suggest the {} version instead", (Object)initializeRequest.protocolVersion(), (Object)serverProtocolVersion);
            }
            return Mono.just((Object)new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, this.instructions));
        });
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.serverCapabilities;
    }

    public McpSchema.Implementation getServerInfo() {
        return this.serverInfo;
    }

    public Mono<Void> closeGracefully() {
        return this.mcpTransportProvider.closeGracefully();
    }

    public void close() {
        this.mcpTransportProvider.close();
    }

    private static List<McpStatelessServerFeatures.AsyncToolSpecification> withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, List<McpStatelessServerFeatures.AsyncToolSpecification> tools) {
        if (Utils.isEmpty(tools)) {
            return tools;
        }
        return tools.stream().map(tool -> McpStatelessAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, tool)).toList();
    }

    private static McpStatelessServerFeatures.AsyncToolSpecification withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, McpStatelessServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification.callHandler() instanceof StructuredOutputCallToolHandler) {
            return toolSpecification;
        }
        if (toolSpecification.tool().outputSchema() == null) {
            return toolSpecification;
        }
        return new McpStatelessServerFeatures.AsyncToolSpecification(toolSpecification.tool(), new StructuredOutputCallToolHandler(jsonSchemaValidator, toolSpecification.tool().outputSchema(), toolSpecification.callHandler()));
    }

    public Mono<Void> addTool(McpStatelessServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool specification must not be null"));
        }
        if (toolSpecification.tool() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool must not be null"));
        }
        if (toolSpecification.callHandler() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool call handler must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        McpStatelessServerFeatures.AsyncToolSpecification wrappedToolSpecification = McpStatelessAsyncServer.withStructuredOutputHandling(this.jsonSchemaValidator, toolSpecification);
        return Mono.defer(() -> {
            if (this.tools.stream().anyMatch(th -> th.tool().name().equals(wrappedToolSpecification.tool().name()))) {
                return Mono.error((Throwable)new McpError((Object)("Tool with name '" + wrappedToolSpecification.tool().name() + "' already exists")));
            }
            this.tools.add(wrappedToolSpecification);
            logger.debug("Added tool handler: {}", (Object)wrappedToolSpecification.tool().name());
            return Mono.empty();
        });
    }

    public Mono<Void> removeTool(String toolName) {
        if (toolName == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool name must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        return Mono.defer(() -> {
            boolean removed = this.tools.removeIf(toolSpecification -> toolSpecification.tool().name().equals(toolName));
            if (removed) {
                logger.debug("Removed tool handler: {}", (Object)toolName);
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolName + "' not found")));
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Tool> tools = this.tools.stream().map(McpStatelessServerFeatures.AsyncToolSpecification::tool).toList();
            return Mono.just((Object)new McpSchema.ListToolsResult(tools, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
        return (ctx, params) -> {
            McpSchema.CallToolRequest callToolRequest = (McpSchema.CallToolRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.CallToolRequest>(){});
            Optional<McpStatelessServerFeatures.AsyncToolSpecification> toolSpecification = this.tools.stream().filter(tr -> callToolRequest.name().equals(tr.tool().name())).findAny();
            if (toolSpecification.isEmpty()) {
                return Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.name())));
            }
            return toolSpecification.map(tool -> tool.callHandler().apply(ctx, callToolRequest)).orElse(Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.name()))));
        };
    }

    public Mono<Void> addResource(McpStatelessServerFeatures.AsyncResourceSpecification resourceSpecification) {
        if (resourceSpecification == null || resourceSpecification.resource() == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            if (this.resources.putIfAbsent(resourceSpecification.resource().uri(), resourceSpecification) != null) {
                return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceSpecification.resource().uri() + "' already exists")));
            }
            logger.debug("Added resource handler: {}", (Object)resourceSpecification.resource().uri());
            return Mono.empty();
        });
    }

    public Mono<Void> removeResource(String resourceUri) {
        if (resourceUri == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource URI must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncResourceSpecification removed = this.resources.remove(resourceUri);
            if (removed != null) {
                logger.debug("Removed resource handler: {}", (Object)resourceUri);
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Resource> resourceList = this.resources.values().stream().map(McpStatelessServerFeatures.AsyncResourceSpecification::resource).toList();
            return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
        return (ctx, params) -> Mono.just((Object)new McpSchema.ListResourceTemplatesResult(this.getResourceTemplates(), null));
    }

    private List<McpSchema.ResourceTemplate> getResourceTemplates() {
        ArrayList<McpSchema.ResourceTemplate> list = new ArrayList<McpSchema.ResourceTemplate>(this.resourceTemplates);
        List<McpSchema.ResourceTemplate> resourceTemplates = this.resources.keySet().stream().filter(uri -> uri.contains("{")).map(uri -> {
            McpSchema.Resource resource = this.resources.get(uri).resource();
            McpSchema.ResourceTemplate template = new McpSchema.ResourceTemplate(resource.uri(), resource.name(), resource.title(), resource.description(), resource.mimeType(), resource.annotations());
            return template;
        }).toList();
        list.addAll(resourceTemplates);
        return list;
    }

    private McpStatelessRequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
        return (ctx, params) -> {
            McpSchema.ReadResourceRequest resourceRequest = (McpSchema.ReadResourceRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.ReadResourceRequest>(){});
            String resourceUri = resourceRequest.uri();
            McpStatelessServerFeatures.AsyncResourceSpecification specification = this.resources.values().stream().filter(resourceSpecification -> this.uriTemplateManagerFactory.create(resourceSpecification.resource().uri()).matches(resourceUri)).findFirst().orElseThrow(() -> new McpError((Object)("Resource not found: " + resourceUri)));
            return specification.readHandler().apply(ctx, resourceRequest);
        };
    }

    public Mono<Void> addPrompt(McpStatelessServerFeatures.AsyncPromptSpecification promptSpecification) {
        if (promptSpecification == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt specification must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncPromptSpecification specification = this.prompts.putIfAbsent(promptSpecification.prompt().name(), promptSpecification);
            if (specification != null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptSpecification.prompt().name() + "' already exists")));
            }
            logger.debug("Added prompt handler: {}", (Object)promptSpecification.prompt().name());
            return Mono.empty();
        });
    }

    public Mono<Void> removePrompt(String promptName) {
        if (promptName == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt name must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncPromptSpecification removed = this.prompts.remove(promptName);
            if (removed != null) {
                logger.debug("Removed prompt handler: {}", (Object)promptName);
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptName + "' not found")));
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Prompt> promptList = this.prompts.values().stream().map(McpStatelessServerFeatures.AsyncPromptSpecification::prompt).toList();
            return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
        return (ctx, params) -> {
            McpSchema.GetPromptRequest promptRequest = (McpSchema.GetPromptRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.GetPromptRequest>(){});
            McpStatelessServerFeatures.AsyncPromptSpecification specification = this.prompts.get(promptRequest.name());
            if (specification == null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptRequest.name())));
            }
            return specification.promptHandler().apply(ctx, promptRequest);
        };
    }

    private McpStatelessRequestHandler<McpSchema.CompleteResult> completionCompleteRequestHandler() {
        return (ctx, params) -> {
            McpStatelessServerFeatures.AsyncCompletionSpecification specification;
            McpSchema.CompleteReference patt23336$temp;
            McpSchema.CompleteReference patt22798$temp;
            McpSchema.CompleteRequest request = this.parseCompletionParams(params);
            if (request.ref() == null) {
                return Mono.error((Throwable)new McpError((Object)"ref must not be null"));
            }
            if (request.ref().type() == null) {
                return Mono.error((Throwable)new McpError((Object)"type must not be null"));
            }
            String type = request.ref().type();
            String argumentName = request.argument().name();
            if (type.equals("ref/prompt") && (patt22798$temp = request.ref()) instanceof McpSchema.PromptReference) {
                McpSchema.PromptReference promptReference = (McpSchema.PromptReference)patt22798$temp;
                McpStatelessServerFeatures.AsyncPromptSpecification promptSpec = this.prompts.get(promptReference.name());
                if (promptSpec == null) {
                    return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptReference.name())));
                }
                if (promptSpec.prompt().arguments().stream().noneMatch(arg -> arg.name().equals(argumentName))) {
                    return Mono.error((Throwable)new McpError((Object)("Argument not found: " + argumentName)));
                }
            }
            if (type.equals("ref/resource") && (patt23336$temp = request.ref()) instanceof McpSchema.ResourceReference) {
                McpSchema.ResourceReference resourceReference = (McpSchema.ResourceReference)patt23336$temp;
                McpStatelessServerFeatures.AsyncResourceSpecification resourceSpec = this.resources.get(resourceReference.uri());
                if (resourceSpec == null) {
                    return Mono.error((Throwable)new McpError((Object)("Resource not found: " + resourceReference.uri())));
                }
                if (!this.uriTemplateManagerFactory.create(resourceSpec.resource().uri()).getVariableNames().contains(argumentName)) {
                    return Mono.error((Throwable)new McpError((Object)("Argument not found: " + argumentName)));
                }
            }
            if ((specification = this.completions.get(request.ref())) == null) {
                return Mono.error((Throwable)new McpError((Object)("AsyncCompletionSpecification not found: " + String.valueOf(request.ref()))));
            }
            return specification.completionHandler().apply(ctx, request);
        };
    }

    private McpSchema.CompleteRequest parseCompletionParams(Object object) {
        String refType;
        Map params = (Map)object;
        Map refMap = (Map)params.get("ref");
        Map argMap = (Map)params.get("argument");
        Record ref = switch (refType = (String)refMap.get("type")) {
            case "ref/prompt" -> new McpSchema.PromptReference(refType, (String)refMap.get("name"), refMap.get("title") != null ? (String)refMap.get("title") : null);
            case "ref/resource" -> new McpSchema.ResourceReference(refType, (String)refMap.get("uri"));
            default -> throw new IllegalArgumentException("Invalid ref type: " + refType);
        };
        String argName = (String)argMap.get("name");
        String argValue = (String)argMap.get("value");
        McpSchema.CompleteRequest.CompleteArgument argument = new McpSchema.CompleteRequest.CompleteArgument(argName, argValue);
        return new McpSchema.CompleteRequest((McpSchema.CompleteReference)((Object)ref), argument);
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    private static class StructuredOutputCallToolHandler
    implements BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> {
        private final BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateHandler;
        private final JsonSchemaValidator jsonSchemaValidator;
        private final Map<String, Object> outputSchema;

        public StructuredOutputCallToolHandler(JsonSchemaValidator jsonSchemaValidator, Map<String, Object> outputSchema, BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateHandler) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            Assert.notNull(delegateHandler, "Delegate call tool result handler must not be null");
            this.delegateHandler = delegateHandler;
            this.outputSchema = outputSchema;
            this.jsonSchemaValidator = jsonSchemaValidator;
        }

        @Override
        public Mono<McpSchema.CallToolResult> apply(McpTransportContext transportContext, McpSchema.CallToolRequest request) {
            return this.delegateHandler.apply(transportContext, request).map(result -> {
                if (this.outputSchema == null) {
                    if (result.structuredContent() != null) {
                        logger.warn("Tool call with no outputSchema is not expected to have a result with structured content, but got: {}", result.structuredContent());
                    }
                    return result;
                }
                if (result.structuredContent() == null) {
                    logger.warn("Response missing structured content which is expected when calling tool with non-empty outputSchema");
                    return new McpSchema.CallToolResult("Response missing structured content which is expected when calling tool with non-empty outputSchema", (Boolean)true);
                }
                JsonSchemaValidator.ValidationResponse validation = this.jsonSchemaValidator.validate(this.outputSchema, result.structuredContent());
                if (!validation.valid()) {
                    logger.warn("Tool call result validation failed: {}", (Object)validation.errorMessage());
                    return new McpSchema.CallToolResult(validation.errorMessage(), (Boolean)true);
                }
                if (Utils.isEmpty(result.content())) {
                    return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(validation.jsonStructuredOutput())), result.isError(), result.structuredContent());
                }
                return result;
            });
        }
    }
}

