/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.restrict;

import io.mockk.impl.restrict.propertiesloader.DefaultPropertiesLoader;
import io.mockk.impl.restrict.propertiesloader.PropertiesLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/mockk/impl/restrict/RestrictMockkConfiguration;", "", "propertiesLoader", "Lio/mockk/impl/restrict/propertiesloader/PropertiesLoader;", "(Lio/mockk/impl/restrict/propertiesloader/PropertiesLoader;)V", "restrictedTypes", "", "", "getRestrictedTypes", "()Ljava/util/Set;", "throwExceptionOnBadMock", "", "getThrowExceptionOnBadMock", "()Z", "userDefinedRestrictedTypes", "getUserDefinedRestrictedTypes", "Companion", "mockk"})
public final class RestrictMockkConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> userDefinedRestrictedTypes;
    @NotNull
    private final Set<String> restrictedTypes;
    private final boolean throwExceptionOnBadMock;
    @NotNull
    private static final String RESTRICTED_MOCK_PROP_KEY = "mockk.throwExceptionOnBadMock";
    @NotNull
    private static final Set<String> DEFAULT_RESTRICTED_CLAZZ;

    public RestrictMockkConfiguration(@NotNull PropertiesLoader propertiesLoader) {
        Intrinsics.checkNotNullParameter((Object)propertiesLoader, (String)"propertiesLoader");
        Properties properties = propertiesLoader.loadProperties();
        this.userDefinedRestrictedTypes = RestrictMockkConfiguration.Companion.loadRestrictedTypesFromConfig(properties);
        this.restrictedTypes = SetsKt.plus(DEFAULT_RESTRICTED_CLAZZ, (Iterable)this.userDefinedRestrictedTypes);
        Boolean bl = RestrictMockkConfiguration.Companion.loadThrowExceptionSystemProperty();
        this.throwExceptionOnBadMock = bl != null ? bl : RestrictMockkConfiguration.Companion.loadThrowExceptionSetting(properties);
    }

    public /* synthetic */ RestrictMockkConfiguration(PropertiesLoader propertiesLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            propertiesLoader = new DefaultPropertiesLoader();
        }
        this(propertiesLoader);
    }

    @NotNull
    public final Set<String> getUserDefinedRestrictedTypes() {
        return this.userDefinedRestrictedTypes;
    }

    @NotNull
    public final Set<String> getRestrictedTypes() {
        return this.restrictedTypes;
    }

    public final boolean getThrowExceptionOnBadMock() {
        return this.throwExceptionOnBadMock;
    }

    public RestrictMockkConfiguration() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"java.lang.System", "java.util.Collection", "java.util.HashMap", "java.io.File", "java.nio.file.Path"};
        DEFAULT_RESTRICTED_CLAZZ = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000f\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/mockk/impl/restrict/RestrictMockkConfiguration$Companion;", "", "()V", "DEFAULT_RESTRICTED_CLAZZ", "", "", "RESTRICTED_MOCK_PROP_KEY", "loadRestrictedTypesFromConfig", "properties", "Ljava/util/Properties;", "loadThrowExceptionSetting", "", "loadThrowExceptionSystemProperty", "()Ljava/lang/Boolean;", "mockk"})
    @SourceDebugExtension(value={"SMAP\nRestrictMockkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestrictMockkConfiguration.kt\nio/mockk/impl/restrict/RestrictMockkConfiguration$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1563#2:55\n1634#2,3:56\n774#2:59\n865#2,2:60\n*S KotlinDebug\n*F\n+ 1 RestrictMockkConfiguration.kt\nio/mockk/impl/restrict/RestrictMockkConfiguration$Companion\n*L\n36#1:55\n36#1:56,3\n37#1:59\n37#1:60,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> loadRestrictedTypesFromConfig(Properties properties) {
            void $this$filterTo$iv$iv;
            String it;
            Iterable $this$mapTo$iv$iv;
            String string = properties.getProperty("mockk.restrictedClasses", "");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"properties.getProperty(\"\u2026k.restrictedClasses\", \"\")");
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        private final Boolean loadThrowExceptionSystemProperty() {
            String throwExceptionSystemProperty = System.getProperty(RestrictMockkConfiguration.RESTRICTED_MOCK_PROP_KEY);
            CharSequence charSequence = throwExceptionSystemProperty;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            return Boolean.parseBoolean(throwExceptionSystemProperty);
        }

        private final boolean loadThrowExceptionSetting(Properties properties) {
            return Boolean.parseBoolean(properties.getProperty(RestrictMockkConfiguration.RESTRICTED_MOCK_PROP_KEY, "false"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

