/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import io.mockk.proxy.MockKAgentLogger;
import io.mockk.proxy.MockKInstantiatior;
import io.mockk.proxy.jvm.transformation.CacheKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import org.jetbrains.annotations.NotNull;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010\u0012\u001a\u001e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0013 \n*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u000b0\u000b\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\tH\u0002J!\u0010\u0016\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\tH\u0016\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\tH\u0002\u00a2\u0006\u0002\u0010\u0018J#\u0010\u001a\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\tH\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\u0007\u001ab\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\u000b0\u000b \n*0\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\u000b0\u000b\u0018\u00010\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/mockk/proxy/jvm/ObjenesisInstantiator;", "Lio/mockk/proxy/MockKInstantiatior;", "log", "Lio/mockk/proxy/MockKAgentLogger;", "byteBuddy", "Lnet/bytebuddy/ByteBuddy;", "(Lio/mockk/proxy/MockKAgentLogger;Lnet/bytebuddy/ByteBuddy;)V", "instantiators", "", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "Lorg/objenesis/instantiator/ObjectInstantiator;", "", "objenesis", "Lorg/objenesis/ObjenesisStd;", "typeCache", "Lnet/bytebuddy/TypeCache;", "Lio/mockk/proxy/jvm/transformation/CacheKey;", "getOrCreateInstantiator", "", "T", "clazz", "instance", "cls", "(Ljava/lang/Class;)Ljava/lang/Object;", "instanceViaObjenesis", "instantiateViaProxy", "Companion", "mockk-agent"})
public final class ObjenesisInstantiator
implements MockKInstantiatior {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MockKAgentLogger log;
    @NotNull
    private final ByteBuddy byteBuddy;
    @NotNull
    private final ObjenesisStd objenesis;
    @NotNull
    private final TypeCache<CacheKey> typeCache;
    private final Map<Class<?>, ObjectInstantiator<?>> instantiators;
    @NotNull
    private static final Object bootstrapMonitor = new Object();

    public ObjenesisInstantiator(@NotNull MockKAgentLogger log, @NotNull ByteBuddy byteBuddy) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)byteBuddy, (String)"byteBuddy");
        this.log = log;
        this.byteBuddy = byteBuddy;
        this.objenesis = new ObjenesisStd(false);
        this.typeCache = new TypeCache(TypeCache.Sort.WEAK);
        this.instantiators = Collections.synchronizedMap(new WeakHashMap());
    }

    public <T> T instance(@NotNull Class<T> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        if (Intrinsics.areEqual(cls, Object.class)) {
            return (T)new Object();
        }
        if (!Modifier.isFinal(cls.getModifiers())) {
            try {
                T instance = this.instantiateViaProxy(cls);
                if (instance != null) {
                    return instance;
                }
            }
            catch (Exception ex) {
                this.log.trace((Throwable)ex, "Failed to instantiate via proxy " + cls + ". Doing objenesis instantiation");
            }
        }
        return this.instanceViaObjenesis(cls);
    }

    private final <T> T instantiateViaProxy(Class<T> cls) {
        Class clazz;
        if (!Modifier.isAbstract(cls.getModifiers())) {
            this.log.trace("Skipping instantiation subsclassing " + cls + " because class is not abstract.");
            clazz = cls;
        } else {
            this.log.trace("Instantiating " + cls + " via subclass proxy");
            ClassLoader classLoader = cls.getClassLoader();
            CacheKey cacheKey = new CacheKey(cls, SetsKt.emptySet());
            Callable<Class> callable = () -> ObjenesisInstantiator.instantiateViaProxy$lambda$0(this, cls, classLoader);
            Object object = classLoader;
            if (object == null) {
                object = bootstrapMonitor;
            }
            clazz = this.typeCache.findOrInsert(classLoader, (Object)cacheKey, callable, object);
        }
        Class proxyCls = clazz;
        Intrinsics.checkNotNullExpressionValue(proxyCls, (String)"proxyCls");
        return cls.cast(this.instanceViaObjenesis(proxyCls));
    }

    private final <T> T instanceViaObjenesis(Class<T> clazz) {
        this.log.trace("Creating new empty instance of " + clazz);
        return clazz.cast(this.getOrCreateInstantiator(clazz).newInstance());
    }

    private final <T> ObjectInstantiator<? extends Object> getOrCreateInstantiator(Class<T> clazz) {
        ObjectInstantiator objectInstantiator = this.instantiators.get(clazz);
        if (objectInstantiator == null) {
            ObjectInstantiator objectInstantiator2;
            ObjenesisInstantiator it = this;
            boolean bl = false;
            ObjectInstantiator it2 = objectInstantiator2 = this.objenesis.getInstantiatorOf(clazz);
            boolean bl2 = false;
            Map<Class<?>, ObjectInstantiator<?>> map = this.instantiators;
            Intrinsics.checkNotNullExpressionValue(map, (String)"instantiators");
            map.put(clazz, it2);
            objectInstantiator = objectInstantiator2;
        }
        return objectInstantiator;
    }

    private static final Class instantiateViaProxy$lambda$0(ObjenesisInstantiator this$0, Class $cls, ClassLoader $classLoader) {
        Annotation[] annotationArray = $cls.getAnnotations();
        return this$0.byteBuddy.subclass($cls).annotateType(Arrays.copyOf(annotationArray, annotationArray.length)).make().load($classLoader).getLoaded();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"Lio/mockk/proxy/jvm/ObjenesisInstantiator$Companion;", "", "()V", "bootstrapMonitor", "mockk-agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

