/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.rbac;

import io.milvus.grpc.CreateCredentialRequest;
import io.milvus.grpc.CreatePrivilegeGroupRequest;
import io.milvus.grpc.CreateRoleRequest;
import io.milvus.grpc.DeleteCredentialRequest;
import io.milvus.grpc.DropPrivilegeGroupRequest;
import io.milvus.grpc.DropRoleRequest;
import io.milvus.grpc.GrantEntity;
import io.milvus.grpc.GrantorEntity;
import io.milvus.grpc.ListCredUsersRequest;
import io.milvus.grpc.ListCredUsersResponse;
import io.milvus.grpc.ListPrivilegeGroupsRequest;
import io.milvus.grpc.ListPrivilegeGroupsResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.ObjectEntity;
import io.milvus.grpc.OperatePrivilegeGroupRequest;
import io.milvus.grpc.OperatePrivilegeGroupType;
import io.milvus.grpc.OperatePrivilegeRequest;
import io.milvus.grpc.OperatePrivilegeType;
import io.milvus.grpc.OperatePrivilegeV2Request;
import io.milvus.grpc.OperateUserRoleRequest;
import io.milvus.grpc.OperateUserRoleType;
import io.milvus.grpc.PrivilegeEntity;
import io.milvus.grpc.RoleEntity;
import io.milvus.grpc.SelectGrantRequest;
import io.milvus.grpc.SelectGrantResponse;
import io.milvus.grpc.SelectRoleRequest;
import io.milvus.grpc.SelectRoleResponse;
import io.milvus.grpc.SelectUserRequest;
import io.milvus.grpc.SelectUserResponse;
import io.milvus.grpc.Status;
import io.milvus.grpc.UpdateCredentialRequest;
import io.milvus.grpc.UserEntity;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.rbac.PrivilegeGroup;
import io.milvus.v2.service.rbac.request.AddPrivilegesToGroupReq;
import io.milvus.v2.service.rbac.request.CreatePrivilegeGroupReq;
import io.milvus.v2.service.rbac.request.CreateRoleReq;
import io.milvus.v2.service.rbac.request.CreateUserReq;
import io.milvus.v2.service.rbac.request.DescribeRoleReq;
import io.milvus.v2.service.rbac.request.DescribeUserReq;
import io.milvus.v2.service.rbac.request.DropPrivilegeGroupReq;
import io.milvus.v2.service.rbac.request.DropRoleReq;
import io.milvus.v2.service.rbac.request.DropUserReq;
import io.milvus.v2.service.rbac.request.GrantPrivilegeReq;
import io.milvus.v2.service.rbac.request.GrantPrivilegeReqV2;
import io.milvus.v2.service.rbac.request.GrantRoleReq;
import io.milvus.v2.service.rbac.request.ListPrivilegeGroupsReq;
import io.milvus.v2.service.rbac.request.RemovePrivilegesFromGroupReq;
import io.milvus.v2.service.rbac.request.RevokePrivilegeReq;
import io.milvus.v2.service.rbac.request.RevokePrivilegeReqV2;
import io.milvus.v2.service.rbac.request.RevokeRoleReq;
import io.milvus.v2.service.rbac.request.UpdatePasswordReq;
import io.milvus.v2.service.rbac.response.DescribeRoleResp;
import io.milvus.v2.service.rbac.response.DescribeUserResp;
import io.milvus.v2.service.rbac.response.ListPrivilegeGroupsResp;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RBACService
extends BaseService {
    public List<String> listRoles(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        String title = "listRoles";
        SelectRoleRequest request = SelectRoleRequest.newBuilder().build();
        SelectRoleResponse response = blockingStub.selectRole(request);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response.getResultsList().stream().map(roleResult -> roleResult.getRole().getName()).collect(Collectors.toList());
    }

    public Void createRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateRoleReq request) {
        String title = "createRole";
        CreateRoleRequest createRoleRequest = CreateRoleRequest.newBuilder().setEntity(RoleEntity.newBuilder().setName(request.getRoleName()).build()).build();
        Status status = blockingStub.createRole(createRoleRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public DescribeRoleResp describeRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeRoleReq request) {
        String title = "describeRole";
        GrantEntity.Builder builder = GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(request.getRoleName()).build());
        if (StringUtils.isNotEmpty((CharSequence)request.getDbName())) {
            builder.setDbName(request.getDbName());
        }
        SelectGrantRequest selectGrantRequest = SelectGrantRequest.newBuilder().setEntity(builder.build()).build();
        SelectGrantResponse response = blockingStub.selectGrant(selectGrantRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        Object describeRoleResp = ((DescribeRoleResp.DescribeRoleRespBuilder)DescribeRoleResp.builder().grantInfos(response.getEntitiesList().stream().map(entity -> ((DescribeRoleResp.GrantInfo.GrantInfoBuilder)((DescribeRoleResp.GrantInfo.GrantInfoBuilder)((DescribeRoleResp.GrantInfo.GrantInfoBuilder)((DescribeRoleResp.GrantInfo.GrantInfoBuilder)((DescribeRoleResp.GrantInfo.GrantInfoBuilder)DescribeRoleResp.GrantInfo.builder().dbName(entity.getDbName())).objectName(entity.getObjectName())).objectType(entity.getObject().getName())).privilege(entity.getGrantor().getPrivilege().getName())).grantor(entity.getGrantor().getUser().getName())).build()).collect(Collectors.toList()))).build();
        return describeRoleResp;
    }

    public Void dropRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropRoleReq request) {
        String title = "dropRole";
        DropRoleRequest dropRoleRequest = DropRoleRequest.newBuilder().setRoleName(request.getRoleName()).build();
        Status status = blockingStub.dropRole(dropRoleRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void grantPrivilege(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GrantPrivilegeReq request) {
        String title = "grantPrivilege";
        GrantEntity entity = GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(request.getRoleName()).build()).setObjectName(request.getObjectName()).setObject(ObjectEntity.newBuilder().setName(request.getObjectType()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(request.getPrivilege()).build()).build()).build();
        OperatePrivilegeRequest operatePrivilegeRequest = OperatePrivilegeRequest.newBuilder().setEntity(entity).setType(OperatePrivilegeType.Grant).build();
        Status status = blockingStub.operatePrivilege(operatePrivilegeRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void revokePrivilege(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RevokePrivilegeReq request) {
        String title = "revokePrivilege";
        GrantEntity entity = GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(request.getRoleName()).build()).setObjectName(request.getObjectName()).setObject(ObjectEntity.newBuilder().setName(request.getObjectType()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(request.getPrivilege()).build()).build()).build();
        OperatePrivilegeRequest operatePrivilegeRequest = OperatePrivilegeRequest.newBuilder().setEntity(entity).setType(OperatePrivilegeType.Revoke).build();
        Status status = blockingStub.operatePrivilege(operatePrivilegeRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void grantRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GrantRoleReq request) {
        String title = "grantRole";
        OperateUserRoleRequest operateUserRoleRequest = OperateUserRoleRequest.newBuilder().setUsername(request.getUserName()).setRoleName(request.getRoleName()).setType(OperateUserRoleType.AddUserToRole).build();
        Status status = blockingStub.operateUserRole(operateUserRoleRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void revokeRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RevokeRoleReq request) {
        String title = "grantRole";
        OperateUserRoleRequest operateUserRoleRequest = OperateUserRoleRequest.newBuilder().setUsername(request.getUserName()).setRoleName(request.getRoleName()).setType(OperateUserRoleType.RemoveUserFromRole).build();
        Status status = blockingStub.operateUserRole(operateUserRoleRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public List<String> listUsers(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        String title = "list users";
        ListCredUsersRequest request = ListCredUsersRequest.newBuilder().build();
        ListCredUsersResponse response = blockingStub.listCredUsers(request);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response.getUsernamesList();
    }

    public DescribeUserResp describeUser(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeUserReq request) {
        String title = String.format("describe user %s", request.getUserName());
        SelectUserRequest selectUserRequest = SelectUserRequest.newBuilder().setUser(UserEntity.newBuilder().setName(request.getUserName()).build()).setIncludeRoleInfo(Boolean.TRUE).build();
        SelectUserResponse response = blockingStub.selectUser(selectUserRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        Object describeUserResp = ((DescribeUserResp.DescribeUserRespBuilder)DescribeUserResp.builder().roles(response.getResultsList().isEmpty() ? null : response.getResultsList().get(0).getRolesList().stream().map(RoleEntity::getName).collect(Collectors.toList()))).build();
        return describeUserResp;
    }

    public Void createUser(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateUserReq request) {
        String title = String.format("create user %s", request.getUserName());
        CreateCredentialRequest createCredentialRequest = CreateCredentialRequest.newBuilder().setUsername(request.getUserName()).setPassword(Base64.getEncoder().encodeToString(request.getPassword().getBytes(StandardCharsets.UTF_8))).build();
        Status response = blockingStub.createCredential(createCredentialRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void updatePassword(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, UpdatePasswordReq request) {
        String title = String.format("update password for user %s", request.getUserName());
        UpdateCredentialRequest updateCredentialRequest = UpdateCredentialRequest.newBuilder().setUsername(request.getUserName()).setOldPassword(Base64.getEncoder().encodeToString(request.getPassword().getBytes(StandardCharsets.UTF_8))).setNewPassword(Base64.getEncoder().encodeToString(request.getNewPassword().getBytes(StandardCharsets.UTF_8))).build();
        Status response = blockingStub.updateCredential(updateCredentialRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropUser(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropUserReq request) {
        String title = String.format("drop user %s", request.getUserName());
        DeleteCredentialRequest deleteCredentialRequest = DeleteCredentialRequest.newBuilder().setUsername(request.getUserName()).build();
        Status response = blockingStub.deleteCredential(deleteCredentialRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void createPrivilegeGroup(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreatePrivilegeGroupReq request) {
        String title = String.format("create privilege group %s", request.getGroupName());
        CreatePrivilegeGroupRequest createPrivilegeGroupRequest = CreatePrivilegeGroupRequest.newBuilder().setGroupName(request.getGroupName()).build();
        Status response = blockingStub.createPrivilegeGroup(createPrivilegeGroupRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropPrivilegeGroup(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropPrivilegeGroupReq request) {
        String title = String.format("drop privilege group %s", request.getGroupName());
        DropPrivilegeGroupRequest dropPrivilegeGroupRequest = DropPrivilegeGroupRequest.newBuilder().setGroupName(request.getGroupName()).build();
        Status response = blockingStub.dropPrivilegeGroup(dropPrivilegeGroupRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public ListPrivilegeGroupsResp listPrivilegeGroups(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListPrivilegeGroupsReq request) {
        String title = "list privilege groups";
        ListPrivilegeGroupsRequest listPrivilegeGroupsRequest = ListPrivilegeGroupsRequest.newBuilder().build();
        ListPrivilegeGroupsResponse response = blockingStub.listPrivilegeGroups(listPrivilegeGroupsRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<PrivilegeGroup> privilegeGroups = new ArrayList<PrivilegeGroup>();
        response.getPrivilegeGroupsList().forEach(privilegeGroupInfo -> {
            ArrayList<String> privileges = new ArrayList<String>();
            privilegeGroupInfo.getPrivilegesList().forEach(privilege -> privileges.add(privilege.getName()));
            privilegeGroups.add((PrivilegeGroup)((PrivilegeGroup.PrivilegeGroupBuilder)((PrivilegeGroup.PrivilegeGroupBuilder)PrivilegeGroup.builder().groupName(privilegeGroupInfo.getGroupName())).privileges(privileges)).build());
        });
        return ((ListPrivilegeGroupsResp.ListPrivilegeGroupsRespBuilder)ListPrivilegeGroupsResp.builder().privilegeGroups(privilegeGroups)).build();
    }

    public Void addPrivilegesToGroup(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AddPrivilegesToGroupReq request) {
        String title = String.format("add privilege to group %s", request.getGroupName());
        OperatePrivilegeGroupRequest.Builder builder = OperatePrivilegeGroupRequest.newBuilder().setGroupName(request.getGroupName()).setType(OperatePrivilegeGroupType.AddPrivilegesToGroup);
        for (String privilege : request.getPrivileges()) {
            builder.addPrivileges(PrivilegeEntity.newBuilder().setName(privilege).build());
        }
        Status response = blockingStub.operatePrivilegeGroup(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void removePrivilegesFromGroup(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RemovePrivilegesFromGroupReq request) {
        String title = String.format("remove privilege from group %s", request.getGroupName());
        OperatePrivilegeGroupRequest.Builder builder = OperatePrivilegeGroupRequest.newBuilder().setGroupName(request.getGroupName()).setType(OperatePrivilegeGroupType.RemovePrivilegesFromGroup);
        for (String privilege : request.getPrivileges()) {
            builder.addPrivileges(PrivilegeEntity.newBuilder().setName(privilege).build());
        }
        Status response = blockingStub.operatePrivilegeGroup(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void grantPrivilegeV2(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GrantPrivilegeReqV2 request) {
        String title = "grantPrivilegeV2";
        OperatePrivilegeV2Request.Builder builder = OperatePrivilegeV2Request.newBuilder().setRole(RoleEntity.newBuilder().setName(request.getRoleName()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(request.getPrivilege()).build()).build()).setDbName(request.getDbName()).setCollectionName(request.getCollectionName()).setType(OperatePrivilegeType.Grant);
        Status response = blockingStub.operatePrivilegeV2(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void revokePrivilegeV2(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RevokePrivilegeReqV2 request) {
        String title = "revokePrivilegeV2";
        OperatePrivilegeV2Request.Builder builder = OperatePrivilegeV2Request.newBuilder().setRole(RoleEntity.newBuilder().setName(request.getRoleName()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(request.getPrivilege()).build()).build()).setDbName(request.getDbName()).setCollectionName(request.getCollectionName()).setType(OperatePrivilegeType.Revoke);
        Status response = blockingStub.operatePrivilegeV2(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }
}

