/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.orm.iterator;

import io.milvus.response.QueryResultsWrapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IteratorCache {
    private final AtomicInteger cacheId = new AtomicInteger(0);
    private final Map<Integer, List<QueryResultsWrapper.RowRecord>> cacheMap = new ConcurrentHashMap<Integer, List<QueryResultsWrapper.RowRecord>>();

    public int cache(int cacheId, List<QueryResultsWrapper.RowRecord> result) {
        if (cacheId == -1) {
            cacheId = this.cacheId.incrementAndGet();
        }
        this.cacheMap.put(cacheId, result);
        return cacheId;
    }

    public List<QueryResultsWrapper.RowRecord> fetchCache(int cacheId) {
        return this.cacheMap.getOrDefault(cacheId, null);
    }

    public void releaseCache(int cacheId) {
        this.cacheMap.remove(cacheId);
    }
}

