/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail;

import io.milton.common.StreamUtils;
import io.milton.mail.Attachment;
import io.milton.mail.InputStreamConsumer;
import io.milton.mail.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.mail.BodyPart;
import javax.mail.MessagingException;

public class FileSystemAttachment
implements Attachment,
Serializable {
    private static final long serialVersionUID = 1L;
    String name;
    String contentType;
    String disposition;
    String contentId;
    File file;

    public static FileSystemAttachment parse(BodyPart bp) {
        FileSystemAttachment fileSystemAttachment;
        InputStream in = null;
        try {
            String name = bp.getFileName();
            if (name == null) {
                name = System.currentTimeMillis() + "";
            }
            String ct = bp.getContentType();
            String[] contentIdArr = bp.getHeader("Content-ID");
            String contentId = null;
            if (contentIdArr != null && contentIdArr.length > 0) {
                contentId = contentIdArr[0];
            }
            in = bp.getInputStream();
            File outFile = File.createTempFile(name, "attachment");
            FileOutputStream fout = new FileOutputStream(outFile);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            StreamUtils.readTo((InputStream)in, (OutputStream)bout);
            bout.flush();
            fout.flush();
            Utils.close(bout);
            Utils.close(fout);
            fileSystemAttachment = new FileSystemAttachment(name, ct, outFile, contentId);
        }
        catch (IOException | MessagingException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                Utils.close(in);
                throw throwable;
            }
        }
        Utils.close(in);
        return fileSystemAttachment;
    }

    public FileSystemAttachment(String name, String contentType, InputStream in, String contentId) {
        FileOutputStream fout = null;
        try {
            this.name = name;
            this.contentType = contentType;
            this.file = File.createTempFile(name, "attachment");
            this.contentId = contentId;
            fout = new FileOutputStream(this.file);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            StreamUtils.readTo((InputStream)in, (OutputStream)bout);
            bout.flush();
            fout.flush();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Utils.close(fout);
                throw throwable;
            }
        }
        Utils.close(fout);
    }

    public FileSystemAttachment(String name, String contentType, File file, String contentId) {
        this.name = name;
        this.contentType = contentType;
        this.file = file;
        this.contentId = contentId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    @Override
    public InputStream getInputStream() {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(this.file);
            return fin;
        }
        catch (IOException e) {
            throw new RuntimeException(this.file.getAbsolutePath(), e);
        }
    }

    @Override
    public void useData(InputStreamConsumer exec) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(this.file);
            exec.execute(fin);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(this.file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                Utils.close(fin);
                throw throwable;
            }
        }
        Utils.close(fin);
    }

    @Override
    public int size() {
        long l = this.file.length();
        return (int)l;
    }
}

