/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClientFactory;
import io.micronaut.testresources.core.LazyTestResourcesPropertySourceLoader;
import io.micronaut.testresources.core.PropertyExpressionProducer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

public class TestResourcesClientPropertySourceLoader
extends LazyTestResourcesPropertySourceLoader {
    public TestResourcesClientPropertySourceLoader() {
        super((PropertyExpressionProducer)new ClientTestResourcesResolver());
    }

    public final Optional<TestResourcesClient> getClient() {
        return Optional.ofNullable(((ClientTestResourcesResolver)this.getProducer()).client);
    }

    private static class ClientTestResourcesResolver
    implements PropertyExpressionProducer {
        private final ReentrantLock lock = new ReentrantLock();
        private TestResourcesClient client;

        private ClientTestResourcesResolver() {
        }

        public List<String> getPropertyEntries() {
            return this.findClient().map(TestResourcesClient::getRequiredPropertyEntries).orElse(Collections.emptyList());
        }

        public List<String> produceKeys(ResourceLoader resourceLoader, Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
            return this.findClient().map(client -> client.getResolvableProperties(propertyEntries, testResourcesConfig)).orElse(Collections.emptyList());
        }

        private Optional<TestResourcesClient> findClient() {
            this.lock.lock();
            try {
                if (this.client == null) {
                    this.client = TestResourcesClientFactory.findByConvention().orElse(null);
                }
                Optional<TestResourcesClient> optional = Optional.ofNullable(this.client);
                return optional;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

