/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jdbc.nativeimage;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import io.micronaut.core.annotation.Internal;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
@Internal
final class JdbcFeature
implements Feature {
    private static final String H2_DRIVER = "org.h2.Driver";
    private static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    private static final String SQL_SERVER_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String MARIADB_DRIVER = "org.mariadb.jdbc.Driver";
    private static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    private static final String MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";
    private ResourcesRegistry resourcesRegistry;

    JdbcFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.handleH2(access);
        this.handlePostgres(access);
        this.handleSqlServer(access);
        this.handleMariadb(access);
        this.handleOracle(access);
        this.handleMySql(access);
    }

    private void handleH2(Feature.BeforeAnalysisAccess access) {
        Class h2Driver = access.findClassByName(H2_DRIVER);
        if (h2Driver != null) {
            this.registerAllIfPresent(access, "org.h2.mvstore.db.MVTableEngine");
            RuntimeReflection.register((Class[])new Class[]{h2Driver});
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{h2Driver});
            ResourcesRegistry resourcesRegistry = this.getResourceRegistry();
            if (resourcesRegistry != null) {
                resourcesRegistry.addResources("META-INF/services/java.sql.Driver");
                resourcesRegistry.addResources("org/h2/util/data.zip");
            }
        }
    }

    private void handlePostgres(Feature.BeforeAnalysisAccess access) {
        Class postgresDriver = access.findClassByName(POSTGRESQL_DRIVER);
        if (postgresDriver != null) {
            RuntimeReflection.register((Class[])new Class[]{postgresDriver});
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{postgresDriver});
            this.initializeAtBuildTime(access, POSTGRESQL_DRIVER, "org.postgresql.util.SharedTimer");
            this.registerAllFields(access, "org.postgresql.PGProperty");
            ResourcesRegistry resourcesRegistry = this.getResourceRegistry();
            if (resourcesRegistry != null) {
                resourcesRegistry.addResources("META-INF/services/java.sql.Driver");
            }
        }
    }

    private void handleOracle(Feature.BeforeAnalysisAccess access) {
        Class oracleDriver = access.findClassByName(ORACLE_DRIVER);
        if (oracleDriver != null) {
            this.registerAllIfPresent(access, "oracle.jdbc.driver.T4CDriverExtension");
            this.registerAllIfPresent(access, "oracle.jdbc.driver.T2CDriverExtension");
            this.registerAllIfPresent(access, "oracle.net.ano.Ano");
            this.registerAllIfPresent(access, "oracle.net.ano.AuthenticationService");
            this.registerAllIfPresent(access, "oracle.net.ano.DataIntegrityService");
            this.registerAllIfPresent(access, "oracle.net.ano.EncryptionService");
            this.registerAllIfPresent(access, "oracle.net.ano.SupervisorService");
            ResourcesRegistry resourcesRegistry = this.getResourceRegistry();
            if (resourcesRegistry != null) {
                resourcesRegistry.addResources("META-INF/services/java.sql.Driver");
                resourcesRegistry.addResources("oracle/sql/converter_xcharset/lx20002.glb");
                resourcesRegistry.addResources("oracle/sql/converter_xcharset/lx2001f.glb");
                resourcesRegistry.addResources("oracle/sql/converter_xcharset/lx200b2.glb");
                resourcesRegistry.addResourceBundles("oracle.net.jdbc.nl.mesg.NLSR");
                resourcesRegistry.addResourceBundles("oracle.net.mesg.Message");
            }
            this.initializeAtBuildTime(access, "oracle.net.jdbc.nl.mesg.NLSR_en", "oracle.jdbc.driver.DynamicByteArray", "oracle.sql.ConverterArchive", "oracle.sql.converter.CharacterConverterJDBC", "oracle.sql.converter.CharacterConverter1Byte");
            this.initializeAtRuntime(access, "java.sql.DriverManager");
        }
    }

    private void handleMariadb(Feature.BeforeAnalysisAccess access) {
        Class mariaDriver = access.findClassByName(MARIADB_DRIVER);
        if (mariaDriver != null) {
            RuntimeReflection.register((Class[])new Class[]{mariaDriver});
            this.registerAllAccess(mariaDriver);
            ResourcesRegistry resourcesRegistry = this.getResourceRegistry();
            if (resourcesRegistry != null) {
                resourcesRegistry.addResources("META-INF/services/java.sql.Driver");
            }
            this.registerAllIfPresent(access, "org.mariadb.jdbc.util.Options");
            RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.mariadb"});
            RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"org.mariadb.jdbc.credential.aws"});
            this.initializeAtRuntime(access, "org.mariadb.jdbc.internal.failover.impl.MastersSlavesListener");
            this.initializeAtRuntime(access, "org.mariadb.jdbc.internal.com.send.authentication.SendPamAuthPacket");
        }
    }

    private void initializeAtRuntime(Feature.BeforeAnalysisAccess access, String n) {
        Class t = access.findClassByName(n);
        if (t != null) {
            RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{t});
        }
    }

    private void initializeAtBuildTime(Feature.BeforeAnalysisAccess access, String ... names) {
        for (String name : names) {
            Class t = access.findClassByName(name);
            if (t == null) continue;
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{t});
        }
    }

    private void registerAllIfPresent(Feature.BeforeAnalysisAccess access, String n) {
        Class t = access.findClassByName(n);
        if (t != null) {
            this.registerAllAccess(t);
        }
    }

    private void registerAllAccess(Class<?> t) {
        Field[] fields;
        RuntimeReflection.register((Class[])new Class[]{t});
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{t});
        for (Method method : t.getMethods()) {
            RuntimeReflection.register((Executable[])new Executable[]{method});
        }
        for (Field field : fields = t.getFields()) {
            RuntimeReflection.register((Field[])new Field[]{field});
        }
    }

    private void registerAllForRuntimeReflection(Feature.BeforeAnalysisAccess access, String n) {
        Class t = access.findClassByName(n);
        if (t != null) {
            RuntimeReflection.register((Class[])new Class[]{t});
            this.registerAllFields(access, n);
            this.registerAllMethods(access, n);
            this.registerAllConstructors(access, n);
        }
    }

    private void registerAllFields(Feature.BeforeAnalysisAccess access, String n) {
        Class t = access.findClassByName(n);
        if (t != null) {
            Field[] fields;
            for (Field field : fields = t.getFields()) {
                RuntimeReflection.register((Field[])new Field[]{field});
            }
        }
    }

    private void registerAllMethods(Feature.BeforeAnalysisAccess access, String n) {
        Class t = access.findClassByName(n);
        if (t != null) {
            for (Method method : t.getMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{method});
            }
        }
    }

    private void registerAllConstructors(Feature.BeforeAnalysisAccess access, String n) {
        Class t = access.findClassByName(n);
        if (t != null) {
            for (Constructor<?> constructor : t.getConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{constructor});
            }
        }
    }

    private void handleSqlServer(Feature.BeforeAnalysisAccess access) {
        Class sqlServerDriver = access.findClassByName(SQL_SERVER_DRIVER);
        if (sqlServerDriver != null) {
            RuntimeReflection.register((Class[])new Class[]{sqlServerDriver});
            this.registerAllAccess(sqlServerDriver);
            RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{SQL_SERVER_DRIVER});
            this.initializeAtBuildTime(access, "com.microsoft.sqlserver.jdbc.Util");
            this.initializeAtBuildTime(access, "com.microsoft.sqlserver.jdbc.SQLServerException");
            this.registerAllIfPresent(access, SQL_SERVER_DRIVER);
            ResourcesRegistry resourcesRegistry = this.getResourceRegistry();
            if (resourcesRegistry != null) {
                resourcesRegistry.addResources("META-INF/services/java.sql.Driver");
                resourcesRegistry.addResources("javax.crypto.Cipher.class");
                resourcesRegistry.addResourceBundles("com.microsoft.sqlserver.jdbc.SQLServerResource");
            }
        }
    }

    private void handleMySql(Feature.BeforeAnalysisAccess access) {
        Class mysqlDriver = access.findClassByName(MYSQL_DRIVER);
        if (mysqlDriver != null) {
            this.registerAllAccess(mysqlDriver);
            this.registerAllForRuntimeReflection(access, "com.mysql.cj.log.StandardLogger");
            this.registerAllForRuntimeReflection(access, "com.mysql.cj.conf.url.SingleConnectionUrl");
            this.registerAllIfPresent(access, "com.mysql.cj.protocol.StandardSocketFactory");
            this.registerAllIfPresent(access, "com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");
            ResourcesRegistry resourcesRegistry = this.getResourceRegistry();
            if (resourcesRegistry != null) {
                resourcesRegistry.addResources("META-INF/services/java.sql.Driver");
                resourcesRegistry.addResources("com/mysql/cj/TlsSettings.properties");
                resourcesRegistry.addResources("com/mysql/cj/LocalizedErrorMessages.properties");
                resourcesRegistry.addResources("com/mysql/cj/util/TimeZoneMapping.properties");
                resourcesRegistry.addResourceBundles("com.mysql.cj.LocalizedErrorMessages");
            }
            RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{MYSQL_DRIVER});
            this.initializeAtRuntime(access, "java.sql.DriverManager");
        }
    }

    private ResourcesRegistry getResourceRegistry() {
        if (this.resourcesRegistry == null) {
            this.resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        }
        return this.resourcesRegistry;
    }
}

