/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.AbstractOpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.EndpointsConfiguration;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OpenApiEndpointVisitor
extends AbstractOpenApiEndpointVisitor
implements TypeElementVisitor<Object, Object> {
    private String id;
    private HttpMethodDesciption methodDescription;
    private Boolean enabled;
    private String path;
    private List<Server> servers;
    private List<io.swagger.v3.oas.models.tags.Tag> tags;
    private List<SecurityRequirement> securityRequirements;
    private List<AnnotationValue<Tag>> additionalTags;
    private List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> additionalSecurityRequirements;

    public OpenApiEndpointVisitor() {
    }

    public OpenApiEndpointVisitor(boolean enabled) {
        this.enabled = enabled;
    }

    public OpenApiEndpointVisitor(boolean enabled, List<AnnotationValue<Tag>> additionalTags, List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> additionalSecurityRequirements) {
        this.enabled = enabled;
        this.additionalTags = additionalTags;
        this.additionalSecurityRequirements = additionalSecurityRequirements;
    }

    @Override
    public void visitClass(ClassElement element, VisitorContext context) {
        EndpointsConfiguration cfg = OpenApiApplicationVisitor.endPointsConfiguration(context);
        if (this.enabled == null) {
            this.enabled = cfg.isEnabled();
        }
        if (this.path == null) {
            this.path = cfg.getPath();
            if (this.path == null) {
                this.path = "/";
            }
        }
        if (this.servers == null) {
            this.servers = cfg.getServers();
            if (this.servers == null) {
                this.servers = Collections.emptyList();
            }
        }
        if (this.tags == null) {
            this.tags = cfg.getTags();
            if (this.tags == null) {
                this.tags = Collections.emptyList();
            }
        }
        if (this.securityRequirements == null) {
            this.securityRequirements = cfg.getSecurityRequirements();
            if (this.securityRequirements == null) {
                this.securityRequirements = Collections.emptyList();
            }
        }
        if (this.additionalTags != null) {
            if (this.tags == null) {
                this.tags = this.readTags(this.additionalTags, context);
            } else {
                this.tags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>(this.tags);
                this.tags.addAll(this.readTags(this.additionalTags, context));
            }
        }
        if (this.additionalSecurityRequirements != null) {
            if (this.securityRequirements == null) {
                this.securityRequirements = this.readSecurityRequirements(this.additionalSecurityRequirements);
            } else {
                this.securityRequirements = new ArrayList<SecurityRequirement>(this.securityRequirements);
                this.securityRequirements.addAll(this.readSecurityRequirements(this.additionalSecurityRequirements));
            }
        }
        super.visitClass(element, context);
    }

    @Override
    protected boolean ignore(ClassElement element, VisitorContext context) {
        if (!this.enabled.booleanValue()) {
            return true;
        }
        if (element.isAnnotationPresent("io.micronaut.management.endpoint.annotation.Endpoint")) {
            AnnotationValue ann = element.getAnnotation("io.micronaut.management.endpoint.annotation.Endpoint");
            String idAnn = ann.stringValue("id").orElse(NameUtils.hyphenate((String)element.getSimpleName()));
            if (idAnn.isEmpty()) {
                idAnn = ann.stringValue("value").orElse(idAnn);
            }
            this.id = this.path + idAnn;
            if (this.id.isEmpty() || this.id.charAt(0) != '/') {
                this.id = "/" + this.id;
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean ignore(MethodElement element, VisitorContext context) {
        if (!this.enabled.booleanValue()) {
            return true;
        }
        AnnotationValue operationAnn = element.getAnnotation(Operation.class);
        boolean isHidden = operationAnn != null && operationAnn.get((CharSequence)"hidden", Boolean.class).orElse(false) != false;
        AnnotationValue jsonAnySetterAnn = element.getAnnotation(JsonAnySetter.class);
        if (isHidden || element.isAnnotationPresent(Hidden.class) || jsonAnySetterAnn != null && jsonAnySetterAnn.get((CharSequence)"enabled", Boolean.class).orElse(true).booleanValue()) {
            return true;
        }
        this.methodDescription = OpenApiEndpointVisitor.httpMethodDescription(element);
        return this.methodDescription == null;
    }

    @Override
    protected HttpMethod httpMethod(MethodElement element) {
        return this.methodDescription == null ? null : this.methodDescription.httpMethod;
    }

    @Override
    protected List<UriMatchTemplate> uriMatchTemplates(MethodElement element, VisitorContext context) {
        UriMatchTemplate uriTemplate = UriMatchTemplate.of((String)this.id);
        for (ParameterElement param : element.getParameters()) {
            if (!param.hasAnnotation("io.micronaut.management.endpoint.annotation.Selector")) continue;
            uriTemplate = uriTemplate.nest((CharSequence)("/{" + param.getName() + "}"));
        }
        return Collections.singletonList(uriTemplate);
    }

    @Override
    protected List<MediaType> consumesMediaTypes(MethodElement element) {
        return OpenApiEndpointVisitor.mediaTypes(this.methodDescription.consumes);
    }

    @Override
    protected List<MediaType> producesMediaTypes(MethodElement element) {
        return OpenApiEndpointVisitor.mediaTypes(this.methodDescription.produces);
    }

    @Override
    protected String description(MethodElement element) {
        return this.methodDescription.description;
    }

    @Override
    protected List<io.swagger.v3.oas.models.tags.Tag> classTags(ClassElement element, VisitorContext context) {
        ArrayList<io.swagger.v3.oas.models.tags.Tag> allTags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>(this.tags);
        allTags.addAll((Collection)context.get((CharSequence)"micronaut.openapi.endpoint.class.tags", List.class, Collections.emptyList()));
        return allTags;
    }

    @Override
    protected List<Server> methodServers(MethodElement element, VisitorContext context) {
        ArrayList<Server> servers = new ArrayList<Server>(this.servers);
        servers.addAll((Collection)context.get((CharSequence)"micronaut.openapi.endpoint.servers", List.class, Collections.emptyList()));
        return servers;
    }

    @Override
    protected List<SecurityRequirement> methodSecurityRequirements(MethodElement element, VisitorContext context) {
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(this.securityRequirements);
        securityRequirements.addAll((Collection)context.get((CharSequence)"micronaut.openapi.endpoint.security.requirements", List.class, Collections.emptyList()));
        return securityRequirements;
    }

    private static List<MediaType> mediaTypes(String ... arr) {
        if (ArrayUtils.isEmpty((Object[])arr)) {
            return Utils.DEFAULT_MEDIA_TYPES;
        }
        return Arrays.stream(arr).map(MediaType::of).collect(Collectors.toList());
    }

    private static HttpMethodDesciption httpMethodDescription(MethodElement element) {
        HttpMethodDesciption httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, "io.micronaut.management.endpoint.annotation.Write", HttpMethod.POST);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, "io.micronaut.management.endpoint.annotation.Read", HttpMethod.GET);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        return OpenApiEndpointVisitor.methodDescription(element, "io.micronaut.management.endpoint.annotation.Delete", HttpMethod.DELETE);
    }

    private static HttpMethodDesciption methodDescription(MethodElement element, String endpointManagementAnnName, HttpMethod httpMethod) {
        if (element.isAnnotationPresent(endpointManagementAnnName)) {
            AnnotationValue annotation = element.getAnnotation(endpointManagementAnnName);
            return new HttpMethodDesciption(httpMethod, annotation.stringValue("description").orElse(null), annotation.stringValues("produces"), annotation.stringValues("consumes"));
        }
        return null;
    }

    private static class HttpMethodDesciption {
        HttpMethod httpMethod;
        String description;
        String[] produces;
        String[] consumes;

        HttpMethodDesciption(HttpMethod httpMethod, String description, String[] produces, String[] consumes) {
            this.httpMethod = httpMethod;
            this.description = description;
            this.produces = produces;
            this.consumes = consumes;
        }

        public String toString() {
            return "HttpMethodDesciption [httpMethod=" + this.httpMethod + ", description=" + this.description + ", produces=" + Arrays.toString(this.produces) + ", consumes=" + Arrays.toString(this.consumes) + "]";
        }
    }
}

