/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanMap;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ConvertUtils {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static ObjectMapper jsonMapper = Json.mapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private static ObjectMapper convertJsonMapper = ObjectMapperFactory.buildStrictGenericObjectMapper().enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS, new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING, new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY});
    private static ObjectMapper yamlMapper = Yaml.mapper();

    private ConvertUtils() {
    }

    public static <T> T treeToValue(JsonNode jn, Class<T> clazz) throws JsonProcessingException {
        Object defaultValue;
        Object value = convertJsonMapper.treeToValue((TreeNode)jn, clazz);
        if (value == null) {
            return null;
        }
        ConvertUtils.resolveExtensions(jn).ifPresent(extensions -> BeanMap.of((Object)value).put((Object)"extensions", extensions));
        String elType = jn.has("type") ? jn.get("type").textValue() : null;
        JsonNode defaultValueNode = jn.get("defaultValue");
        JsonNode allowableValuesNode = jn.get("allowableValues");
        try {
            defaultValue = ConvertUtils.normalizeValue(defaultValueNode != null ? defaultValueNode.textValue() : null, elType);
        }
        catch (JsonProcessingException e) {
            defaultValue = defaultValueNode != null ? defaultValueNode.textValue() : null;
        }
        BeanMap beanMap = BeanMap.of((Object)value);
        if (defaultValue != null) {
            beanMap.put((Object)"default", defaultValue);
        }
        if (allowableValuesNode != null && allowableValuesNode.isArray()) {
            ArrayList<Object> allowableValues = new ArrayList<Object>(allowableValuesNode.size());
            for (JsonNode allowableValueNode : allowableValuesNode) {
                if (allowableValueNode == null) continue;
                try {
                    allowableValues.add(ConvertUtils.normalizeValue(allowableValueNode.textValue(), elType));
                }
                catch (IOException e) {
                    allowableValues.add(allowableValueNode.textValue());
                }
            }
            beanMap.put((Object)"allowableValues", allowableValues);
        }
        return (T)value;
    }

    private static Object convertJsonNodeValue(JsonNode node, String type) throws JsonProcessingException {
        if (node == null) {
            return null;
        }
        return ConvertUtils.normalizeValue(node.textValue(), type);
    }

    public static Object normalizeValue(String valueStr, String type) throws JsonProcessingException {
        if (valueStr == null) {
            return null;
        }
        if (type == null || type.equals("object")) {
            return convertJsonMapper.readValue(valueStr, Map.class);
        }
        PrimitiveType primitiveType = PrimitiveType.fromName((String)type);
        switch (primitiveType) {
            case INT: {
                return Integer.parseInt(valueStr);
            }
            case LONG: {
                return Long.parseLong(valueStr);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(valueStr));
            }
            case DOUBLE: {
                return Double.parseDouble(valueStr);
            }
            case DECIMAL: 
            case NUMBER: {
                return new BigDecimal(valueStr);
            }
            case INTEGER: {
                return new BigInteger(valueStr);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(valueStr);
            }
        }
        return valueStr;
    }

    public static Optional<Map<String, Object>> resolveExtensions(JsonNode jn) {
        try {
            JsonNode extensionsNode = jn.get("extensions");
            if (extensionsNode != null) {
                return Optional.ofNullable((Map)convertJsonMapper.convertValue((Object)extensionsNode, MAP_TYPE_REFERENCE));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static SecurityRequirement mapToSecurityRequirement(AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement> r) {
        String name = (String)r.getRequiredValue("name", String.class);
        List scopes = r.get((CharSequence)"scopes", String[].class).map(Arrays::asList).orElse(Collections.emptyList());
        SecurityRequirement securityRequirement = new SecurityRequirement();
        securityRequirement.addList(name, scopes);
        return securityRequirement;
    }

    public static ObjectMapper getJsonMapper() {
        return jsonMapper;
    }

    public static ObjectMapper getConvertJsonMapper() {
        return convertJsonMapper;
    }

    public static ObjectMapper getYamlMapper() {
        return yamlMapper;
    }
}

