/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.InjectScope;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.ConfigurationPath;
import io.micronaut.context.exceptions.CircularDependencyException;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.inject.ArgumentInjectionPoint;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.CallableInjectionPoint;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ProxyBeanDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
public abstract class AbstractBeanResolutionContext
implements BeanResolutionContext {
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    protected final DefaultBeanContext context;
    protected final BeanDefinition<?> rootDefinition;
    protected final BeanResolutionContext.Path path;
    private Map<CharSequence, Object> attributes;
    private Qualifier<?> qualifier;
    private List<BeanRegistration<?>> dependentBeans;
    private BeanRegistration<?> dependentFactory;
    private ConfigurationPath configurationPath;

    @Internal
    protected AbstractBeanResolutionContext(DefaultBeanContext context, BeanDefinition<?> rootDefinition) {
        this.context = context;
        this.rootDefinition = rootDefinition;
        this.path = new DefaultPath();
    }

    @Override
    public ConfigurationPath getConfigurationPath() {
        if (this.configurationPath != null) {
            return this.configurationPath;
        }
        this.configurationPath = ConfigurationPath.newPath();
        return this.configurationPath;
    }

    @Override
    public ConfigurationPath setConfigurationPath(ConfigurationPath configurationPath) {
        ConfigurationPath old = this.configurationPath;
        this.configurationPath = configurationPath;
        return old;
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.context.getBean((BeanResolutionContext)this, beanType, qualifier);
    }

    @Override
    @NonNull
    public <T> Collection<T> getBeansOfType(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.context.getBeansOfType(this, beanType, qualifier);
    }

    @Override
    @NonNull
    public <T> Stream<T> streamOfType(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.context.streamOfType((BeanResolutionContext)this, beanType, qualifier);
    }

    @Override
    public <V> Map<String, V> mapOfType(Argument<V> beanType, Qualifier<V> qualifier) {
        return this.context.mapOfType(this, beanType, qualifier);
    }

    @Override
    @NonNull
    public <T> Optional<T> findBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.context.findBean((BeanResolutionContext)this, beanType, qualifier);
    }

    @Override
    @NonNull
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.context.getBeanRegistrations(this, beanType, qualifier);
    }

    public void copyStateFrom(@NonNull AbstractBeanResolutionContext context) {
        this.path.addAll(context.path);
        this.qualifier = context.qualifier;
        if (context.attributes != null) {
            this.getAttributesOrCreate().putAll(context.attributes);
        }
    }

    @Override
    public <T> void addDependentBean(BeanRegistration<T> beanRegistration) {
        if (beanRegistration.getBeanDefinition() == this.rootDefinition) {
            return;
        }
        if (this.dependentBeans == null) {
            this.dependentBeans = new ArrayList(3);
        }
        this.dependentBeans.add(beanRegistration);
    }

    @Override
    public void destroyInjectScopedBeans() {
        CustomScope injectScope = this.context.getCustomScopeRegistry().findScope(InjectScope.class.getName()).orElse(null);
        if (injectScope instanceof LifeCycle) {
            LifeCycle cycle = (LifeCycle)((Object)injectScope);
            cycle.stop();
        }
    }

    @Override
    @NonNull
    public List<BeanRegistration<?>> getAndResetDependentBeans() {
        if (this.dependentBeans == null) {
            return Collections.emptyList();
        }
        List<BeanRegistration<?>> registrations = Collections.unmodifiableList(this.dependentBeans);
        this.dependentBeans = null;
        return registrations;
    }

    @Override
    public void markDependentAsFactory() {
        if (this.dependentBeans != null) {
            if (this.dependentBeans.isEmpty()) {
                return;
            }
            if (this.dependentBeans.size() != 1) {
                throw new IllegalStateException("Expected only one bean dependent!");
            }
            this.dependentFactory = this.dependentBeans.remove(0);
        }
    }

    @Override
    public BeanRegistration<?> getAndResetDependentFactoryBean() {
        BeanRegistration<?> result = this.dependentFactory;
        this.dependentFactory = null;
        return result;
    }

    @Override
    public List<BeanRegistration<?>> popDependentBeans() {
        List<BeanRegistration<?>> result = this.dependentBeans;
        this.dependentBeans = null;
        return result;
    }

    @Override
    public void pushDependentBeans(List<BeanRegistration<?>> dependentBeans) {
        if (this.dependentBeans != null && !this.dependentBeans.isEmpty()) {
            throw new IllegalStateException("Found existing dependent beans!");
        }
        this.dependentBeans = dependentBeans;
    }

    @Override
    public final BeanContext getContext() {
        return this.context;
    }

    @Override
    public final BeanDefinition getRootDefinition() {
        return this.rootDefinition;
    }

    @Override
    public final BeanResolutionContext.Path getPath() {
        return this.path;
    }

    @Override
    public final Object setAttribute(CharSequence key, Object value) {
        return this.getAttributesOrCreate().put(key, value);
    }

    @Override
    public final Object getAttribute(CharSequence key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public final Object removeAttribute(CharSequence key) {
        if (this.attributes != null && key != null) {
            return this.attributes.remove(key);
        }
        return null;
    }

    @Override
    public Map<CharSequence, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<CharSequence, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    @Nullable
    public Qualifier<?> getCurrentQualifier() {
        return this.qualifier;
    }

    @Override
    public void setCurrentQualifier(@Nullable Qualifier<?> qualifier) {
        this.qualifier = qualifier;
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        Object value = this.attributes.get(name);
        if (value != null && conversionContext.getArgument().getType().isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        Object value = this.attributes.get(name);
        if (requiredType.isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    protected void onNewSegment(BeanResolutionContext.Segment<?, ?> segment) {
    }

    @NonNull
    private Map<CharSequence, Object> getAttributesOrCreate() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<CharSequence, Object>(2);
        }
        return this.attributes;
    }

    class DefaultPath
    extends LinkedList<BeanResolutionContext.Segment<?, ?>>
    implements BeanResolutionContext.Path {
        public static final String RIGHT_ARROW = " --> ";
        private static final String CIRCULAR_ERROR_MSG = "Circular dependency detected";

        DefaultPath() {
        }

        @Override
        public String toString() {
            Iterator i = this.descendingIterator();
            StringBuilder pathString = new StringBuilder();
            while (i.hasNext()) {
                pathString.append(((BeanResolutionContext.Segment)i.next()).toString());
                if (!i.hasNext()) continue;
                pathString.append(RIGHT_ARROW);
            }
            return pathString.toString();
        }

        @Override
        public String toCircularString() {
            Iterator i = this.descendingIterator();
            StringBuilder pathString = new StringBuilder();
            String ls = CachedEnvironment.getProperty("line.separator");
            while (i.hasNext()) {
                String segmentString = ((BeanResolutionContext.Segment)i.next()).toString();
                pathString.append(segmentString);
                if (i.hasNext()) {
                    pathString.append(RIGHT_ARROW);
                    continue;
                }
                int totalLength = pathString.length() - 3;
                String spaces = String.join((CharSequence)"", Collections.nCopies(totalLength, " "));
                pathString.append(ls).append("^").append(spaces).append("|").append(ls).append("|").append(spaces).append("|").append(ls).append("|").append(spaces).append("|").append(ls).append('+');
                pathString.append(String.join((CharSequence)"", Collections.nCopies(totalLength, "-"))).append('+');
            }
            return pathString.toString();
        }

        @Override
        public Optional<BeanResolutionContext.Segment<?, ?>> currentSegment() {
            return Optional.ofNullable((BeanResolutionContext.Segment)this.peek());
        }

        @Override
        public BeanResolutionContext.Path pushConstructorResolve(BeanDefinition declaringType, Argument argument) {
            ConstructorInjectionPoint constructor = declaringType.getConstructor();
            if (constructor instanceof MethodInjectionPoint) {
                MethodInjectionPoint methodInjectionPoint = (MethodInjectionPoint)((Object)constructor);
                return this.pushConstructorResolve(declaringType, methodInjectionPoint.getName(), argument, constructor.getArguments());
            }
            return this.pushConstructorResolve(declaringType, AbstractBeanResolutionContext.CONSTRUCTOR_METHOD_NAME, argument, constructor.getArguments());
        }

        @Override
        public BeanResolutionContext.Path pushConstructorResolve(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments) {
            if (AbstractBeanResolutionContext.CONSTRUCTOR_METHOD_NAME.equals(methodName)) {
                ConstructorArgumentSegment constructorSegment = new ConstructorArgumentSegment(declaringType, methodName, argument, arguments);
                this.detectCircularDependency(declaringType, argument, constructorSegment);
            } else {
                MethodSegment ms;
                BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
                MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, methodName, argument, arguments, previous instanceof MethodSegment ? (ms = (MethodSegment)previous) : null);
                if (this.contains(methodSegment)) {
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
                }
                this.push(methodSegment);
            }
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushBeanCreate(BeanDefinition<?> declaringType, Argument<?> beanType) {
            return this.pushConstructorResolve(declaringType, beanType);
        }

        @Override
        public BeanResolutionContext.Path pushMethodArgumentResolve(BeanDefinition declaringType, MethodInjectionPoint methodInjectionPoint, Argument argument) {
            MethodSegment ms;
            BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
            MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, methodInjectionPoint.getName(), argument, methodInjectionPoint.getArguments(), previous instanceof MethodSegment ? (ms = (MethodSegment)previous) : null);
            if (this.contains(methodSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, methodInjectionPoint, argument, CIRCULAR_ERROR_MSG);
            }
            this.push(methodSegment);
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushMethodArgumentResolve(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments) {
            MethodSegment ms;
            BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
            MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, methodName, argument, arguments, previous instanceof MethodSegment ? (ms = (MethodSegment)previous) : null);
            if (this.contains(methodSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, declaringType, methodName, argument, CIRCULAR_ERROR_MSG);
            }
            this.push(methodSegment);
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushFieldResolve(BeanDefinition declaringType, FieldInjectionPoint fieldInjectionPoint) {
            FieldSegment fieldSegment = new FieldSegment(declaringType, fieldInjectionPoint.asArgument());
            if (this.contains(fieldSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, fieldInjectionPoint, CIRCULAR_ERROR_MSG);
            }
            this.push(fieldSegment);
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushFieldResolve(BeanDefinition declaringType, Argument fieldAsArgument) {
            FieldSegment fieldSegment = new FieldSegment(declaringType, fieldAsArgument);
            if (this.contains(fieldSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, declaringType, fieldAsArgument.getName(), CIRCULAR_ERROR_MSG);
            }
            this.push(fieldSegment);
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushAnnotationResolve(BeanDefinition beanDefinition, Argument annotationMemberBeanAsArgument) {
            AnnotationSegment annotationSegment = new AnnotationSegment(beanDefinition, annotationMemberBeanAsArgument);
            if (this.contains(annotationSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, beanDefinition, annotationMemberBeanAsArgument.getName(), CIRCULAR_ERROR_MSG);
            }
            this.push(annotationSegment);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void detectCircularDependency(BeanDefinition declaringType, Argument argument, BeanResolutionContext.Segment constructorSegment) {
            if (this.contains(constructorSegment)) {
                BeanResolutionContext.Segment last = (BeanResolutionContext.Segment)this.peek();
                if (last == null) throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
                BeanDefinition declaringBean = last.getDeclaringType();
                if (!declaringBean.equals(declaringType)) {
                    if (declaringType instanceof ProxyBeanDefinition) {
                        ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)declaringType;
                        if (!proxyBeanDefinition.getTargetDefinitionType().equals(declaringBean.getClass())) {
                            throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
                        }
                        this.push(constructorSegment);
                        return;
                    } else {
                        if (!(declaringBean instanceof ProxyBeanDefinition)) throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
                        ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)declaringBean;
                        if (!proxyBeanDefinition.getTargetDefinitionType().equals(declaringType.getClass())) {
                            throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
                        }
                        this.push(constructorSegment);
                    }
                    return;
                } else {
                    this.push(constructorSegment);
                }
                return;
            } else {
                this.push(constructorSegment);
            }
        }

        @Override
        public void push(BeanResolutionContext.Segment<?, ?> segment) {
            super.push(segment);
            AbstractBeanResolutionContext.this.onNewSegment(segment);
        }
    }

    static abstract class AbstractSegment<B, T>
    implements BeanResolutionContext.Segment<B, T>,
    Named {
        private final BeanDefinition<B> declaringComponent;
        private final String name;
        private final Argument<T> argument;

        AbstractSegment(BeanDefinition<B> declaringClass, String name, Argument<T> argument) {
            this.declaringComponent = declaringClass;
            this.name = name;
            this.argument = argument;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public BeanDefinition<B> getDeclaringType() {
            return this.declaringComponent;
        }

        @Override
        public Argument<T> getArgument() {
            return this.argument;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractSegment that = (AbstractSegment)o;
            return this.declaringComponent.equals(that.declaringComponent) && this.name.equals(that.name) && this.argument.equals(that.argument);
        }

        public int hashCode() {
            return ObjectUtils.hash(this.declaringComponent, (Object)this.name, this.argument);
        }

        void outputArguments(StringBuilder baseString, Argument[] arguments) {
            baseString.append('(');
            for (int i = 0; i < arguments.length; ++i) {
                Argument argument = arguments[i];
                boolean isInjectedArgument = argument.equals(this.getArgument());
                if (isInjectedArgument) {
                    baseString.append('[');
                }
                baseString.append(argument);
                if (isInjectedArgument) {
                    baseString.append(']');
                }
                if (i == arguments.length - 1) continue;
                baseString.append(',');
            }
            baseString.append(')');
        }
    }

    public static final class AnnotationSegment<B>
    extends AbstractSegment<B, B>
    implements InjectionPoint<B> {
        AnnotationSegment(BeanDefinition<B> beanDefinition, Argument<B> argument) {
            super(beanDefinition, argument.getName(), argument);
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public InjectionPoint<B> getInjectionPoint() {
            return this;
        }

        @Override
        public BeanDefinition<B> getDeclaringBean() {
            return this.getDeclaringType();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }
    }

    public static class FieldSegment<B, T>
    extends AbstractSegment<B, T>
    implements InjectionPoint<B>,
    ArgumentCoercible<T>,
    ArgumentInjectionPoint<B, T> {
        FieldSegment(BeanDefinition<B> declaringClass, Argument<T> argument) {
            super(declaringClass, argument.getName(), argument);
        }

        public String toString() {
            return this.getDeclaringType().getBeanType().getSimpleName() + "." + this.getName();
        }

        @Override
        public InjectionPoint<B> getInjectionPoint() {
            return this;
        }

        @Override
        public BeanDefinition<B> getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public CallableInjectionPoint<B> getOuterInjectionPoint() {
            throw new UnsupportedOperationException("Outer injection point not retrievable from here");
        }

        @Override
        public Argument<T> asArgument() {
            return this.getArgument();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }
    }

    public static class MethodSegment<B, T>
    extends AbstractSegment<B, T>
    implements CallableInjectionPoint<B> {
        private final Argument[] arguments;

        MethodSegment(BeanDefinition<B> declaringType, String methodName, Argument<T> argument, Argument[] arguments) {
            super(declaringType, methodName, argument);
            this.arguments = arguments;
        }

        public String toString() {
            StringBuilder baseString = new StringBuilder(this.getDeclaringType().getBeanType().getSimpleName()).append('.');
            baseString.append(this.getName());
            this.outputArguments(baseString, this.arguments);
            return baseString.toString();
        }

        @Override
        public InjectionPoint<B> getInjectionPoint() {
            return this;
        }

        @Override
        public BeanDefinition<B> getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public Argument<?>[] getArguments() {
            return this.arguments;
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }
    }

    public static class MethodArgumentSegment
    extends MethodSegment
    implements ArgumentInjectionPoint {
        private final MethodSegment outer;

        public MethodArgumentSegment(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments, MethodSegment outer) {
            super(declaringType, methodName, argument, arguments);
            this.outer = outer;
        }

        public CallableInjectionPoint getOuterInjectionPoint() {
            if (this.outer == null) {
                throw new IllegalStateException("Outer argument inaccessible");
            }
            return this.outer;
        }

        @Override
        public String toString() {
            BeanDefinition declaringBean = this.getDeclaringBean();
            if (declaringBean.hasAnnotation(Factory.class)) {
                ConstructorInjectionPoint constructor = declaringBean.getConstructor();
                StringBuilder baseString = new StringBuilder(constructor.getDeclaringBeanType().getSimpleName()).append('.');
                baseString.append(this.getName());
                this.outputArguments(baseString, this.getArguments());
                return baseString.toString();
            }
            return super.toString();
        }
    }

    public static class ConstructorSegment
    extends AbstractSegment {
        private final String methodName;
        private final Argument[] arguments;

        ConstructorSegment(BeanDefinition declaringClass, String methodName, Argument argument, Argument[] arguments) {
            super(declaringClass, declaringClass.getBeanType().getName(), argument);
            this.methodName = methodName;
            this.arguments = arguments;
        }

        public String toString() {
            StringBuilder baseString;
            if (AbstractBeanResolutionContext.CONSTRUCTOR_METHOD_NAME.equals(this.methodName)) {
                baseString = new StringBuilder("new ");
                baseString.append(this.getDeclaringType().getBeanType().getSimpleName());
            } else {
                baseString = new StringBuilder(this.getDeclaringType().getBeanType().getSimpleName()).append('.');
                baseString.append(this.methodName);
            }
            this.outputArguments(baseString, this.arguments);
            return baseString.toString();
        }

        @Override
        public InjectionPoint getInjectionPoint() {
            final ConstructorInjectionPoint constructorInjectionPoint = this.getDeclaringType().getConstructor();
            return new ArgumentInjectionPoint(){

                @NonNull
                public CallableInjectionPoint getOuterInjectionPoint() {
                    return constructorInjectionPoint;
                }

                @NonNull
                public Argument getArgument() {
                    return this.getArgument();
                }

                @Override
                public BeanDefinition getDeclaringBean() {
                    return constructorInjectionPoint.getDeclaringBean();
                }

                public AnnotationMetadata getAnnotationMetadata() {
                    return this.getArgument().getAnnotationMetadata();
                }
            };
        }
    }

    public static class ConstructorArgumentSegment
    extends ConstructorSegment
    implements ArgumentInjectionPoint {
        public ConstructorArgumentSegment(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments) {
            super(declaringType, methodName, argument, arguments);
        }

        public CallableInjectionPoint getOuterInjectionPoint() {
            throw new UnsupportedOperationException("Outer injection point inaccessible from here");
        }

        @Override
        public BeanDefinition getDeclaringBean() {
            return this.getDeclaringType();
        }
    }
}

