/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MutableAnnotationMetadata
extends DefaultAnnotationMetadata {
    private boolean hasPropertyExpressions = false;
    private boolean hasEvaluatedExpressions = false;
    @Nullable
    Map<String, Map<CharSequence, Object>> annotationDefaultValues;
    @Nullable
    private Set<String> sourceRetentionAnnotations;
    @Nullable
    private Map<String, Map<CharSequence, Object>> sourceAnnotationDefaultValues;
    @Nullable
    Map<String, String> annotationRepeatableContainer;

    public MutableAnnotationMetadata() {
    }

    private MutableAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> declaredStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations, @Nullable Map<String, List<String>> annotationsByStereotype, boolean hasPropertyExpressions) {
        this(declaredAnnotations, declaredStereotypes, allStereotypes, allAnnotations, annotationsByStereotype, hasPropertyExpressions, false);
    }

    private MutableAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> declaredStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations, @Nullable Map<String, List<String>> annotationsByStereotype, boolean hasPropertyExpressions, boolean hasEvaluatedExpressions) {
        super(declaredAnnotations, declaredStereotypes, allStereotypes, allAnnotations, annotationsByStereotype, hasPropertyExpressions);
        this.hasPropertyExpressions = hasPropertyExpressions;
        this.hasEvaluatedExpressions = hasEvaluatedExpressions;
    }

    public static MutableAnnotationMetadata of(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata.isEmpty()) {
            return new MutableAnnotationMetadata();
        }
        if ((annotationMetadata = annotationMetadata.getTargetAnnotationMetadata()) instanceof AnnotationMetadataHierarchy) {
            return ((AnnotationMetadataHierarchy)annotationMetadata).merge();
        }
        if (annotationMetadata instanceof MutableAnnotationMetadata) {
            return ((MutableAnnotationMetadata)annotationMetadata).clone();
        }
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            MutableAnnotationMetadata metadata = new MutableAnnotationMetadata();
            metadata.addAnnotationMetadata((DefaultAnnotationMetadata)annotationMetadata);
            return metadata;
        }
        throw new IllegalStateException("Unknown annotation metadata: " + annotationMetadata);
    }

    @Override
    public boolean hasPropertyExpressions() {
        return this.hasPropertyExpressions;
    }

    @Override
    public boolean hasEvaluatedExpressions() {
        return this.hasEvaluatedExpressions;
    }

    @Override
    public MutableAnnotationMetadata clone() {
        MutableAnnotationMetadata cloned = new MutableAnnotationMetadata(this.declaredAnnotations != null ? this.cloneMapOfMapValue(this.declaredAnnotations) : null, this.declaredStereotypes != null ? this.cloneMapOfMapValue(this.declaredStereotypes) : null, this.allStereotypes != null ? this.cloneMapOfMapValue(this.allStereotypes) : null, this.allAnnotations != null ? this.cloneMapOfMapValue(this.allAnnotations) : null, this.annotationsByStereotype != null ? this.cloneMapOfListValue(this.annotationsByStereotype) : null, this.hasPropertyExpressions, this.hasEvaluatedExpressions);
        if (this.annotationDefaultValues != null) {
            cloned.annotationDefaultValues = new LinkedHashMap<String, Map<CharSequence, Object>>(this.annotationDefaultValues);
        }
        if (this.annotationRepeatableContainer != null) {
            cloned.annotationRepeatableContainer = new HashMap<String, String>(this.annotationRepeatableContainer);
        }
        if (this.sourceRetentionAnnotations != null) {
            cloned.sourceRetentionAnnotations = new HashSet<String>(this.sourceRetentionAnnotations);
        }
        if (this.annotationDefaultValues != null) {
            cloned.annotationDefaultValues = this.cloneMapOfMapValue(this.annotationDefaultValues);
        }
        if (this.sourceAnnotationDefaultValues != null) {
            cloned.sourceAnnotationDefaultValues = this.cloneMapOfMapValue(this.sourceAnnotationDefaultValues);
        }
        cloned.hasPropertyExpressions = this.hasPropertyExpressions;
        cloned.hasEvaluatedExpressions = this.hasEvaluatedExpressions;
        return cloned;
    }

    @Override
    @NonNull
    public Map<CharSequence, Object> getDefaultValues(@NonNull String annotation) {
        Map<CharSequence, Object> values = super.getDefaultValues(annotation);
        if (!values.isEmpty() || this.annotationDefaultValues == null) {
            return values;
        }
        Map<CharSequence, Object> compileTimeDefaults = this.annotationDefaultValues.get(annotation);
        if (compileTimeDefaults != null && !compileTimeDefaults.isEmpty()) {
            return compileTimeDefaults.entrySet().stream().collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).toString(), Map.Entry::getValue));
        }
        return values;
    }

    private boolean computeHasPropertyExpressions(Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        return this.hasPropertyExpressions || values != null && retentionPolicy == RetentionPolicy.RUNTIME && this.hasPropertyExpressions(values);
    }

    private boolean computeHasEvaluatedExpressions(Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        return this.hasEvaluatedExpressions || values != null && retentionPolicy == RetentionPolicy.RUNTIME && this.hasEvaluatedExpressions(values);
    }

    private boolean hasPropertyExpressions(Map<CharSequence, Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return false;
        }
        return values.values().stream().anyMatch(v -> {
            if (v instanceof CharSequence) {
                return v.toString().contains("${");
            }
            if (v instanceof String[]) {
                String[] strings = (String[])v;
                return Arrays.stream(strings).anyMatch(s -> s.contains("${"));
            }
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return this.hasPropertyExpressions(annotationValue.getValues());
            }
            if (v instanceof AnnotationValue[]) {
                AnnotationValue[] annotationValues = (AnnotationValue[])v;
                if (annotationValues.length > 0) {
                    return Arrays.stream(annotationValues).anyMatch(av -> this.hasPropertyExpressions(av.getValues()));
                }
                return false;
            }
            return false;
        });
    }

    @Internal
    Set<String> getSourceRetentionAnnotations() {
        if (this.sourceRetentionAnnotations != null) {
            return Collections.unmodifiableSet(this.sourceRetentionAnnotations);
        }
        return Collections.emptySet();
    }

    public void addAnnotation(String annotation, Map<CharSequence, Object> values) {
        this.addAnnotation(annotation, values, RetentionPolicy.RUNTIME);
    }

    public void addAnnotation(String annotation, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        if (annotation == null) {
            return;
        }
        if (this.isRepeatableAnnotationContainer(annotation)) {
            Object v = values.get("value");
            if (v instanceof AnnotationValue[]) {
                AnnotationValue[] annotationValues;
                for (AnnotationValue annotationValue : annotationValues = (AnnotationValue[])v) {
                    this.addRepeatable(annotation, annotationValue);
                }
            } else if (v instanceof Iterable) {
                Iterable iterable = (Iterable)v;
                for (Object o : iterable) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue annotationValue = (AnnotationValue)o;
                    this.addRepeatable(annotation, annotationValue);
                }
            }
        } else {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
            this.addAnnotation(annotation, values, null, allAnnotations, false, retentionPolicy);
        }
    }

    public final void addDefaultAnnotationValues(String annotation, Map<CharSequence, Object> values) {
        this.addDefaultAnnotationValues(annotation, values, RetentionPolicy.RUNTIME);
    }

    public final void addDefaultAnnotationValues(String annotation, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        Map<String, Map<CharSequence, Object>> annotationDefaults;
        if (annotation == null) {
            return;
        }
        if (retentionPolicy == RetentionPolicy.RUNTIME) {
            annotationDefaults = this.annotationDefaultValues;
            if (annotationDefaults == null) {
                annotationDefaults = this.annotationDefaultValues = new LinkedHashMap<String, Map<CharSequence, Object>>();
            }
        } else {
            annotationDefaults = this.sourceAnnotationDefaultValues;
            if (annotationDefaults == null) {
                this.sourceAnnotationDefaultValues = new LinkedHashMap<String, Map<CharSequence, Object>>();
                annotationDefaults = this.sourceAnnotationDefaultValues;
            }
        }
        this.putValues(annotation, values, annotationDefaults);
    }

    public void addRepeatable(String annotationName, AnnotationValue<?> annotationValue) {
        this.addRepeatable(annotationName, annotationValue, annotationValue.getRetentionPolicy());
    }

    public void addRepeatable(String annotationName, AnnotationValue<?> annotationValue, RetentionPolicy retentionPolicy) {
        if (StringUtils.isNotEmpty((CharSequence)annotationName) && annotationValue != null) {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
            this.addRepeatableInternal(annotationName, annotationValue, allAnnotations, retentionPolicy);
        }
    }

    public void addRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue<?> annotationValue) {
        Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
        List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
        for (String parentAnnotation : parents) {
            if (annotationList.contains(parentAnnotation)) continue;
            annotationList.add(parentAnnotation);
        }
        this.addRepeatableInternal(stereotype, annotationValue, allStereotypes, RetentionPolicy.RUNTIME);
    }

    public void addDeclaredRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue<?> annotationValue) {
        Map<String, Map<CharSequence, Object>> declaredStereotypes = this.getDeclaredStereotypesInternal();
        List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
        for (String parentAnnotation : parents) {
            if (annotationList.contains(parentAnnotation)) continue;
            annotationList.add(parentAnnotation);
        }
        this.addRepeatableInternal(stereotype, annotationValue, declaredStereotypes, RetentionPolicy.RUNTIME);
        this.addRepeatableInternal(stereotype, annotationValue, this.getAllStereotypes(), RetentionPolicy.RUNTIME);
    }

    public void addDeclaredRepeatable(String annotationName, AnnotationValue<?> annotationValue) {
        this.addDeclaredRepeatable(annotationName, annotationValue, annotationValue.getRetentionPolicy());
    }

    public void addDeclaredRepeatable(String annotationName, AnnotationValue<?> annotationValue, RetentionPolicy retentionPolicy) {
        if (StringUtils.isNotEmpty((CharSequence)annotationName) && annotationValue != null) {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getDeclaredAnnotationsInternal();
            this.addRepeatableInternal(annotationName, annotationValue, allAnnotations, retentionPolicy);
            this.addRepeatable(annotationName, annotationValue);
        }
    }

    public final void addStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values) {
        this.addStereotype(parentAnnotations, stereotype, values, RetentionPolicy.RUNTIME);
    }

    public final void addStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        if (stereotype == null) {
            return;
        }
        if (this.isRepeatableAnnotationContainer(stereotype)) {
            Object v = values.get("value");
            if (v instanceof AnnotationValue[]) {
                AnnotationValue[] annotationValues;
                for (AnnotationValue annotationValue : annotationValues = (AnnotationValue[])v) {
                    this.addRepeatableStereotype(parentAnnotations, stereotype, annotationValue);
                }
            } else if (v instanceof Iterable) {
                Iterable iterable = (Iterable)v;
                for (Object o : iterable) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue annotationValue = (AnnotationValue)o;
                    this.addRepeatableStereotype(parentAnnotations, stereotype, annotationValue);
                }
            }
        } else {
            String parentAnnotation;
            Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
            List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
            if (!parentAnnotations.isEmpty() && !annotationList.contains(parentAnnotation = (String)CollectionUtils.last(parentAnnotations))) {
                annotationList.add(parentAnnotation);
            }
            this.addAnnotation(stereotype, values, null, allStereotypes, false, retentionPolicy);
        }
    }

    public void addDeclaredStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values) {
        this.addDeclaredStereotype(parentAnnotations, stereotype, values, RetentionPolicy.RUNTIME);
    }

    public void addDeclaredStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        if (stereotype == null) {
            return;
        }
        if (this.isRepeatableAnnotationContainer(stereotype)) {
            Object v = values.get("value");
            if (v instanceof AnnotationValue[]) {
                AnnotationValue[] annotationValues;
                for (AnnotationValue annotationValue : annotationValues = (AnnotationValue[])v) {
                    this.addDeclaredRepeatableStereotype(parentAnnotations, stereotype, annotationValue);
                }
            } else if (v instanceof Iterable) {
                Iterable iterable = (Iterable)v;
                for (Object o : iterable) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue annotationValue = (AnnotationValue)o;
                    this.addDeclaredRepeatableStereotype(parentAnnotations, stereotype, annotationValue);
                }
            }
        } else {
            String parentAnnotation;
            Map<String, Map<CharSequence, Object>> declaredStereotypes = this.getDeclaredStereotypesInternal();
            Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
            List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
            if (!parentAnnotations.isEmpty() && !annotationList.contains(parentAnnotation = (String)CollectionUtils.last(parentAnnotations))) {
                annotationList.add(parentAnnotation);
            }
            this.addAnnotation(stereotype, values, declaredStereotypes, allStereotypes, true, retentionPolicy);
        }
    }

    public void addDeclaredAnnotation(String annotation, Map<CharSequence, Object> values) {
        this.addDeclaredAnnotation(annotation, values, RetentionPolicy.RUNTIME);
    }

    public void addDeclaredAnnotation(String annotation, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        if (annotation == null) {
            return;
        }
        boolean hasOtherMembers = false;
        boolean repeatableAnnotationContainer = this.isRepeatableAnnotationContainer(annotation);
        if (this.isRepeatableAnnotationContainer(annotation)) {
            for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
                if (entry.getKey().equals("value")) {
                    Object v = entry.getValue();
                    if (v instanceof AnnotationValue[]) {
                        AnnotationValue[] annotationValues = (AnnotationValue[])v;
                        for (AnnotationValue annotationValue : annotationValues) {
                            this.addDeclaredRepeatable(annotation, annotationValue);
                        }
                        continue;
                    }
                    if (!(v instanceof Iterable)) continue;
                    Iterable iterable = (Iterable)v;
                    for (Object o : iterable) {
                        if (!(o instanceof AnnotationValue)) continue;
                        AnnotationValue annotationValue = (AnnotationValue)o;
                        this.addDeclaredRepeatable(annotation, annotationValue);
                    }
                    continue;
                }
                hasOtherMembers = true;
            }
        }
        if (!repeatableAnnotationContainer || hasOtherMembers) {
            Map<String, Map<CharSequence, Object>> declaredAnnotations = this.getDeclaredAnnotationsInternal();
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
            this.addAnnotation(annotation, values, declaredAnnotations, allAnnotations, true, retentionPolicy);
        }
    }

    private void addAnnotation(String annotation, Map<CharSequence, Object> values, Map<String, Map<CharSequence, Object>> declaredAnnotations, Map<String, Map<CharSequence, Object>> allAnnotations, boolean isDeclared, RetentionPolicy retentionPolicy) {
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(values, retentionPolicy);
        this.hasEvaluatedExpressions = this.computeHasEvaluatedExpressions(values, retentionPolicy);
        if (isDeclared && declaredAnnotations != null) {
            this.putValues(annotation, values, declaredAnnotations);
        }
        this.putValues(annotation, values, allAnnotations);
        if (retentionPolicy == RetentionPolicy.SOURCE || retentionPolicy == RetentionPolicy.CLASS) {
            this.addSourceRetentionAnnotation(annotation);
        }
    }

    private void addSourceRetentionAnnotation(String annotation) {
        if (this.sourceRetentionAnnotations == null) {
            this.sourceRetentionAnnotations = new HashSet<String>(5);
        }
        this.sourceRetentionAnnotations.add(annotation);
    }

    private void putValues(String annotation, Map<CharSequence, Object> values, Map<String, Map<CharSequence, Object>> currentAnnotationValues) {
        LinkedHashMap<CharSequence, Object> existing = currentAnnotationValues.get(annotation);
        boolean hasValues = CollectionUtils.isNotEmpty(values);
        if (existing != null && hasValues) {
            if (existing.isEmpty()) {
                existing = new LinkedHashMap();
                currentAnnotationValues.put(annotation, existing);
            }
            for (CharSequence key : values.keySet()) {
                if (existing.containsKey(key)) continue;
                existing.put(key, values.get(key));
            }
        } else {
            if (!hasValues) {
                existing = existing == null ? new LinkedHashMap<CharSequence, Object>(3) : existing;
            } else {
                existing = new LinkedHashMap(values.size());
                existing.putAll(values);
            }
            currentAnnotationValues.put(annotation, existing);
        }
    }

    private Map<String, Map<CharSequence, Object>> getAllStereotypes() {
        HashMap stereotypes = this.allStereotypes;
        if (stereotypes == null) {
            this.allStereotypes = stereotypes = new HashMap(3);
        }
        return stereotypes;
    }

    private Map<String, Map<CharSequence, Object>> getDeclaredStereotypesInternal() {
        HashMap stereotypes = this.declaredStereotypes;
        if (stereotypes == null) {
            this.declaredStereotypes = stereotypes = new HashMap(3);
        }
        return stereotypes;
    }

    private Map<String, Map<CharSequence, Object>> getAllAnnotations() {
        HashMap annotations = this.allAnnotations;
        if (annotations == null) {
            this.allAnnotations = annotations = new HashMap(3);
        }
        return annotations;
    }

    private Map<String, Map<CharSequence, Object>> getDeclaredAnnotationsInternal() {
        HashMap annotations = this.declaredAnnotations;
        if (annotations == null) {
            this.declaredAnnotations = annotations = new HashMap(3);
        }
        return annotations;
    }

    private List<String> getAnnotationsByStereotypeInternal(String stereotype) {
        return this.getAnnotationsByStereotypeInternal().computeIfAbsent(stereotype, s -> new ArrayList());
    }

    private Map<String, List<String>> getAnnotationsByStereotypeInternal() {
        HashMap annotations = this.annotationsByStereotype;
        if (annotations == null) {
            this.annotationsByStereotype = annotations = new HashMap(3);
        }
        return annotations;
    }

    private void addRepeatableInternal(String repeatableAnnotationContainer, AnnotationValue<?> annotationValue, Map<String, Map<CharSequence, Object>> allAnnotations, RetentionPolicy retentionPolicy) {
        Map values;
        Object v;
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(annotationValue.getValues(), retentionPolicy);
        this.hasEvaluatedExpressions = this.computeHasEvaluatedExpressions(annotationValue.getValues(), retentionPolicy);
        if (this.annotationRepeatableContainer == null) {
            this.annotationRepeatableContainer = new HashMap<String, String>(2);
        }
        this.annotationRepeatableContainer.put(annotationValue.getAnnotationName(), repeatableAnnotationContainer);
        if (retentionPolicy == RetentionPolicy.SOURCE) {
            this.addSourceRetentionAnnotation(repeatableAnnotationContainer);
        }
        if ((v = (values = allAnnotations.computeIfAbsent(repeatableAnnotationContainer, s -> new HashMap())).get("value")) != null) {
            if (v.getClass().isArray()) {
                Object[] array = (Object[])v;
                LinkedHashSet newValues = CollectionUtils.newLinkedHashSet((int)(array.length + 1));
                newValues.addAll(Arrays.asList(array));
                newValues.add(annotationValue);
                values.put("value", newValues);
            } else if (v instanceof Collection) {
                Collection collection = (Collection)v;
                collection.add(annotationValue);
            }
        } else {
            LinkedHashSet newValues = new LinkedHashSet(2);
            newValues.add(annotationValue);
            values.put("value", newValues);
        }
    }

    @Internal
    public static MutableAnnotationMetadata mutateMember(MutableAnnotationMetadata annotationMetadata, String annotationName, String member, Object value) {
        return MutableAnnotationMetadata.mutateMember(annotationMetadata, annotationName, Collections.singletonMap(member, value));
    }

    @Override
    protected <T extends Annotation> AnnotationValue<T> newAnnotationValue(String annotationType, Map<CharSequence, Object> values) {
        Map<CharSequence, Object> defaultValues = null;
        if (this.annotationDefaultValues != null) {
            defaultValues = this.annotationDefaultValues.get(annotationType);
        }
        if (defaultValues == null && this.sourceAnnotationDefaultValues != null) {
            defaultValues = this.sourceAnnotationDefaultValues.get(annotationType);
        }
        if (defaultValues == null) {
            defaultValues = AnnotationMetadataSupport.getDefaultValuesOrNull(annotationType);
        }
        return new AnnotationValue(annotationType, values, defaultValues);
    }

    @Internal
    public void addAnnotationMetadata(DefaultAnnotationMetadata annotationMetadata) {
        Map<String, List<String>> source;
        this.hasPropertyExpressions |= annotationMetadata.hasPropertyExpressions();
        this.hasEvaluatedExpressions |= annotationMetadata.hasEvaluatedExpressions();
        if (annotationMetadata.declaredAnnotations != null && !annotationMetadata.declaredAnnotations.isEmpty()) {
            if (this.declaredAnnotations == null) {
                this.declaredAnnotations = new LinkedHashMap();
            }
            for (Map.Entry<String, Map<CharSequence, Object>> entry : annotationMetadata.declaredAnnotations.entrySet()) {
                this.putValues(entry.getKey(), entry.getValue(), this.declaredAnnotations);
            }
        }
        if (annotationMetadata.declaredStereotypes != null && !annotationMetadata.declaredStereotypes.isEmpty()) {
            if (this.declaredStereotypes == null) {
                this.declaredStereotypes = new LinkedHashMap();
            }
            for (Map.Entry<String, Map<CharSequence, Object>> entry : annotationMetadata.declaredStereotypes.entrySet()) {
                this.putValues(entry.getKey(), entry.getValue(), this.declaredStereotypes);
            }
        }
        if (annotationMetadata.allStereotypes != null && !annotationMetadata.allStereotypes.isEmpty()) {
            if (this.allStereotypes == null) {
                this.allStereotypes = new LinkedHashMap();
            }
            for (Map.Entry<String, Map<CharSequence, Object>> entry : annotationMetadata.allStereotypes.entrySet()) {
                this.putValues(entry.getKey(), entry.getValue(), this.allStereotypes);
            }
        }
        if (annotationMetadata.allAnnotations != null && !annotationMetadata.allAnnotations.isEmpty()) {
            if (this.allAnnotations == null) {
                this.allAnnotations = new LinkedHashMap();
            }
            for (Map.Entry<String, Map<CharSequence, Object>> entry : annotationMetadata.allAnnotations.entrySet()) {
                this.putValues(entry.getKey(), entry.getValue(), this.allAnnotations);
            }
        }
        if ((source = annotationMetadata.annotationsByStereotype) != null && !source.isEmpty()) {
            if (this.annotationsByStereotype == null) {
                this.annotationsByStereotype = new LinkedHashMap();
            }
            for (Map.Entry<String, List<String>> entry : source.entrySet()) {
                String ann = entry.getKey();
                List prevValues = (List)this.annotationsByStereotype.get(ann);
                if (prevValues == null) {
                    this.annotationsByStereotype.put(ann, new ArrayList(entry.getValue()));
                    continue;
                }
                LinkedHashSet prevValuesSet = new LinkedHashSet(prevValues);
                prevValuesSet.addAll(entry.getValue());
                this.annotationsByStereotype.put(ann, new ArrayList(prevValuesSet));
            }
        }
    }

    @Internal
    public void addAnnotationMetadata(MutableAnnotationMetadata annotationMetadata) {
        this.addAnnotationMetadata((DefaultAnnotationMetadata)annotationMetadata);
        this.hasPropertyExpressions |= annotationMetadata.hasPropertyExpressions;
        this.hasEvaluatedExpressions |= annotationMetadata.hasEvaluatedExpressions;
        if (annotationMetadata.sourceRetentionAnnotations != null) {
            if (this.sourceRetentionAnnotations == null) {
                this.sourceRetentionAnnotations = new HashSet<String>(annotationMetadata.sourceRetentionAnnotations);
            } else {
                this.sourceRetentionAnnotations.addAll(annotationMetadata.sourceRetentionAnnotations);
            }
        }
        if (annotationMetadata.annotationDefaultValues != null) {
            if (this.annotationDefaultValues == null) {
                this.annotationDefaultValues = new LinkedHashMap<String, Map<CharSequence, Object>>(annotationMetadata.annotationDefaultValues);
            } else {
                this.annotationDefaultValues.putAll(annotationMetadata.annotationDefaultValues);
            }
        }
        if (annotationMetadata.sourceAnnotationDefaultValues != null) {
            if (this.sourceAnnotationDefaultValues == null) {
                this.sourceAnnotationDefaultValues = new LinkedHashMap<String, Map<CharSequence, Object>>(annotationMetadata.sourceAnnotationDefaultValues);
            } else {
                this.sourceAnnotationDefaultValues.putAll(annotationMetadata.sourceAnnotationDefaultValues);
            }
        }
        if (annotationMetadata.annotationRepeatableContainer != null) {
            if (this.annotationRepeatableContainer == null) {
                this.annotationRepeatableContainer = new LinkedHashMap<String, String>(annotationMetadata.annotationRepeatableContainer);
            } else {
                this.annotationRepeatableContainer.putAll(annotationMetadata.annotationRepeatableContainer);
            }
        }
    }

    @Internal
    public static void contributeDefaults(AnnotationMetadata target, AnnotationMetadata source) {
        if ((source = source.getTargetAnnotationMetadata()) instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)source;
            MutableAnnotationMetadata.contributeDefaults(target, annotationMetadataHierarchy);
            return;
        }
        if (target instanceof MutableAnnotationMetadata) {
            MutableAnnotationMetadata damTarget = (MutableAnnotationMetadata)target;
            if (source instanceof MutableAnnotationMetadata) {
                MutableAnnotationMetadata damSource = (MutableAnnotationMetadata)source;
                Map<String, Map<CharSequence, Object>> existingDefaults = damTarget.annotationDefaultValues;
                Map<String, Map<CharSequence, Object>> additionalDefaults = damSource.annotationDefaultValues;
                if (existingDefaults != null) {
                    if (additionalDefaults != null) {
                        existingDefaults.putAll(additionalDefaults);
                    }
                } else if (additionalDefaults != null) {
                    additionalDefaults.forEach(damTarget::addDefaultAnnotationValues);
                }
            }
        }
        MutableAnnotationMetadata.contributeRepeatable(target, source);
    }

    @Internal
    public static void contributeDefaults(AnnotationMetadata target, AnnotationMetadataHierarchy source) {
        for (AnnotationMetadata annotationMetadata : source) {
            if (annotationMetadata instanceof AnnotationMetadataReference) continue;
            MutableAnnotationMetadata.contributeDefaults(target, annotationMetadata);
        }
    }

    @Internal
    public static void contributeRepeatable(AnnotationMetadata target, AnnotationMetadata source) {
        if ((source = source.getTargetAnnotationMetadata()) instanceof AnnotationMetadataHierarchy) {
            source = ((AnnotationMetadataHierarchy)source).merge();
        }
        if (target instanceof MutableAnnotationMetadata) {
            MutableAnnotationMetadata damTarget = (MutableAnnotationMetadata)target;
            if (source instanceof MutableAnnotationMetadata) {
                MutableAnnotationMetadata damSource = (MutableAnnotationMetadata)source;
                if (damSource.annotationRepeatableContainer != null && !damSource.annotationRepeatableContainer.isEmpty()) {
                    if (damTarget.annotationRepeatableContainer == null) {
                        damTarget.annotationRepeatableContainer = new HashMap<String, String>(damSource.annotationRepeatableContainer);
                    } else {
                        damTarget.annotationRepeatableContainer.putAll(damSource.annotationRepeatableContainer);
                    }
                }
            }
        }
    }

    @Internal
    public static MutableAnnotationMetadata mutateMember(MutableAnnotationMetadata annotationMetadata, String annotationName, Map<CharSequence, Object> members) {
        if (StringUtils.isEmpty((CharSequence)annotationName)) {
            throw new IllegalArgumentException("Argument [annotationName] cannot be blank");
        }
        if (!members.isEmpty()) {
            for (Map.Entry<CharSequence, Object> entry : members.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getKey())) {
                    throw new IllegalArgumentException("Argument [members] cannot have a blank key");
                }
                if (entry.getValue() != null) continue;
                throw new IllegalArgumentException("Argument [members] cannot have a null value. Key [" + entry.getKey() + "]");
            }
        }
        annotationMetadata = annotationMetadata.clone();
        annotationMetadata.addDeclaredAnnotation(annotationName, members);
        return annotationMetadata;
    }

    public <A extends Annotation> void removeAnnotationIf(@NonNull Predicate<AnnotationValue<A>> predicate) {
        this.removeAnnotationsIf(predicate, this.declaredAnnotations);
        this.removeAnnotationsIf(predicate, this.allAnnotations);
    }

    private <A extends Annotation> void removeAnnotationsIf(@NonNull Predicate<AnnotationValue<A>> predicate, Map<String, Map<CharSequence, Object>> annotations) {
        if (annotations == null) {
            return;
        }
        annotations.entrySet().removeIf(entry -> {
            String annotationName = (String)entry.getKey();
            if (predicate.test(this.newAnnotationValue(annotationName, (Map)entry.getValue()))) {
                this.removeFromStereotypes(annotationName);
                return true;
            }
            return false;
        });
    }

    public void removeAnnotation(String annotationType) {
        if (annotationType == null) {
            return;
        }
        if (this.annotationDefaultValues != null) {
            this.annotationDefaultValues.remove(annotationType);
        }
        if (this.allAnnotations != null) {
            this.allAnnotations.remove(annotationType);
        }
        if (this.declaredAnnotations != null) {
            this.declaredAnnotations.remove(annotationType);
            this.removeFromStereotypes(annotationType);
        }
        if (this.annotationRepeatableContainer != null) {
            this.annotationRepeatableContainer.remove(annotationType);
        }
    }

    public void removeStereotype(String annotationType) {
        if (annotationType == null) {
            return;
        }
        if (this.annotationsByStereotype == null || this.annotationsByStereotype.remove(annotationType) == null) {
            return;
        }
        if (this.allStereotypes != null) {
            this.allStereotypes.remove(annotationType);
        }
        if (this.declaredStereotypes != null) {
            this.declaredStereotypes.remove(annotationType);
        }
        Iterator i = this.annotationsByStereotype.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            List value = (List)entry.getValue();
            if (!value.remove(annotationType) || !value.isEmpty()) continue;
            i.remove();
        }
    }

    private void removeFromStereotypes(String annotationType) {
        if (this.annotationsByStereotype == null || this.annotationsByStereotype.isEmpty()) {
            return;
        }
        Iterator i = this.annotationsByStereotype.entrySet().iterator();
        LinkedHashSet<String> removeNext = new LinkedHashSet<String>();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String stereotypeName = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (!value.remove(annotationType) || !value.isEmpty()) continue;
            removeNext.add(stereotypeName);
            i.remove();
            if (this.allStereotypes != null) {
                this.allStereotypes.remove(stereotypeName);
            }
            if (this.declaredStereotypes != null) {
                this.declaredStereotypes.remove(stereotypeName);
            }
            if (this.annotationDefaultValues != null) {
                this.annotationDefaultValues.remove(stereotypeName);
            }
            removeNext.add(stereotypeName);
        }
        for (String stereotype : removeNext) {
            this.removeFromStereotypes(stereotype);
        }
    }

    private boolean isRepeatableAnnotationContainer(String annotation) {
        return this.annotationRepeatableContainer != null && this.annotationRepeatableContainer.containsValue(annotation);
    }

    @Override
    protected String findRepeatableAnnotationContainerInternal(String annotation) {
        String repeatedName;
        if (this.annotationRepeatableContainer != null && (repeatedName = this.annotationRepeatableContainer.get(annotation)) != null) {
            return repeatedName;
        }
        return AnnotationMetadataSupport.getRepeatableAnnotation(annotation);
    }

    private boolean hasEvaluatedExpressions(Map<CharSequence, Object> annotationValues) {
        if (CollectionUtils.isEmpty(annotationValues)) {
            return false;
        }
        return annotationValues.values().stream().anyMatch(value -> {
            if (value instanceof EvaluatedExpressionReference) {
                return true;
            }
            if (value instanceof AnnotationValue) {
                AnnotationValue av = (AnnotationValue)value;
                return this.hasEvaluatedExpressions(av.getValues());
            }
            if (value instanceof AnnotationValue[]) {
                AnnotationValue[] avArray = (AnnotationValue[])value;
                return Arrays.stream(avArray).map(AnnotationValue::getValues).anyMatch(this::hasEvaluatedExpressions);
            }
            return false;
        });
    }
}

