/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.cli;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.cli.CommandLine;
import io.micronaut.core.cli.CommandLineParser;
import io.micronaut.core.cli.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Internal
class DefaultCommandLine
implements CommandLine {
    private Properties systemProperties = new Properties();
    private LinkedHashMap<String, Object> undeclaredOptions = new LinkedHashMap();
    private LinkedHashMap<Option, Object> declaredOptions = new LinkedHashMap();
    private List<String> remainingArgs = new ArrayList<String>();
    private String[] rawArguments = new String[0];

    DefaultCommandLine() {
    }

    @Override
    public CommandLine parseNew(String[] args) {
        DefaultCommandLine defaultCommandLine = new DefaultCommandLine();
        defaultCommandLine.systemProperties.putAll((Map<?, ?>)this.systemProperties);
        defaultCommandLine.undeclaredOptions.putAll(this.undeclaredOptions);
        defaultCommandLine.declaredOptions.putAll(this.declaredOptions);
        CommandLineParser parser = new CommandLineParser();
        return parser.parse(defaultCommandLine, args);
    }

    @Override
    public Map<Option, Object> getOptions() {
        return this.declaredOptions;
    }

    @Override
    public List<String> getRemainingArgs() {
        return this.remainingArgs;
    }

    @Override
    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public boolean hasOption(String name) {
        return this.declaredOptions.containsKey(new Option(name, null)) || this.undeclaredOptions.containsKey(name);
    }

    @Override
    public Object optionValue(String name) {
        Option opt = new Option(name, null);
        if (this.declaredOptions.containsKey(opt)) {
            return this.declaredOptions.get(opt);
        }
        if (this.undeclaredOptions.containsKey(name)) {
            return this.undeclaredOptions.get(name);
        }
        return null;
    }

    @Override
    public String getRemainingArgsString() {
        return this.remainingArgsToString(" ", false);
    }

    @Override
    public Map.Entry<String, Object> lastOption() {
        Iterator<Map.Entry<String, Object>> i = this.undeclaredOptions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Object> next = i.next();
            if (i.hasNext()) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getRemainingArgsWithOptionsString() {
        return this.remainingArgsToString(" ", true);
    }

    @Override
    public Map<String, Object> getUndeclaredOptions() {
        return Collections.unmodifiableMap(this.undeclaredOptions);
    }

    @Override
    public String[] getRawArguments() {
        return this.rawArguments;
    }

    void addDeclaredOption(Option option) {
        this.addDeclaredOption(option, Boolean.TRUE);
    }

    void addUndeclaredOption(String option) {
        this.undeclaredOptions.put(option, Boolean.TRUE);
    }

    void addUndeclaredOption(String option, Object value) {
        this.undeclaredOptions.put(option, value);
    }

    void addDeclaredOption(Option option, Object value) {
        this.declaredOptions.put(option, value);
    }

    void addRemainingArg(String arg) {
        this.remainingArgs.add(arg);
    }

    void addSystemProperty(String name, String value) {
        this.systemProperties.put(name, value);
    }

    void setRawArguments(String[] args) {
        this.rawArguments = args;
    }

    private String remainingArgsToString(String separator, boolean includeOptions) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        ArrayList<String> args = new ArrayList<String>(this.remainingArgs);
        if (includeOptions) {
            for (Map.Entry entry : this.undeclaredOptions.entrySet()) {
                if (entry.getValue() instanceof Boolean && ((Boolean)entry.getValue()).booleanValue()) {
                    args.add("-" + (String)entry.getKey());
                    continue;
                }
                args.add("-" + (String)entry.getKey() + "=" + entry.getValue());
            }
        }
        for (String string : args) {
            sb.append(sep).append(string);
            sep = separator;
        }
        return sb.toString();
    }
}

