/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.async;

import io.micronaut.aop.kotlin.KotlinInterceptedMethod;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.async.AsyncTransactionStatus;
import io.micronaut.transaction.interceptor.CoroutineTxHelper;
import io.micronaut.transaction.interceptor.KotlinInterceptedMethodAsyncResultSupplier;
import io.micronaut.transaction.interceptor.ReactorCoroutineTxHelper;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

@Internal
public final class AsyncUsingReactiveTransactionOperations<C>
implements AsyncTransactionOperations<C> {
    private final ReactorReactiveTransactionOperations<C> reactiveTransactionOperations;
    @Nullable
    private final CoroutineTxHelper coroutineTxHelper;
    @Nullable
    private final ReactorCoroutineTxHelper reactorCoroutineTxHelper;

    public AsyncUsingReactiveTransactionOperations(ReactorReactiveTransactionOperations<C> reactiveTransactionOperations, @Nullable CoroutineTxHelper coroutineTxHelper, @Nullable ReactorCoroutineTxHelper reactorCoroutineTxHelper) {
        this.reactiveTransactionOperations = reactiveTransactionOperations;
        this.coroutineTxHelper = coroutineTxHelper;
        this.reactorCoroutineTxHelper = reactorCoroutineTxHelper;
    }

    @Override
    public <T> CompletionStage<T> withTransaction(TransactionDefinition definition, Function<AsyncTransactionStatus<C>, CompletionStage<T>> handler) {
        try (TransactionSynchronizationManager.TransactionSynchronizationStateOp op = TransactionSynchronizationManager.withGuardedState();){
            TransactionSynchronizationManager.TransactionSynchronizationState state = op.getOrCreateState();
            ContextView previousContext = null;
            if (this.coroutineTxHelper != null && handler instanceof KotlinInterceptedMethodAsyncResultSupplier) {
                KotlinInterceptedMethod kotlinInterceptedMethod = ((KotlinInterceptedMethodAsyncResultSupplier)handler).getKotlinInterceptedMethod();
                Objects.requireNonNull(this.coroutineTxHelper).setupTxState(kotlinInterceptedMethod, state);
                if (this.reactorCoroutineTxHelper != null) {
                    previousContext = this.reactorCoroutineTxHelper.getReactorContext(kotlinInterceptedMethod);
                }
            }
            if (previousContext == null) {
                previousContext = (ContextView)TransactionSynchronizationManager.getResource(ContextView.class);
            }
            ContextView finalPreviousContext = previousContext;
            Mono result = Mono.fromDirect(this.reactiveTransactionOperations.withTransaction(definition, (ReactiveTransactionStatus<C> status) -> Mono.deferContextual(contextView -> {
                try (TransactionSynchronizationManager.TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState(state);){
                    TransactionSynchronizationManager.rebindResource(ContextView.class, contextView);
                }
                return Mono.fromCompletionStage(() -> TransactionSynchronizationManager.decorateCompletionStage(state, () -> (CompletionStage)handler.apply(new DefaultAsyncTransactionStatus(status))));
            }).doAfterTerminate(() -> {
                try (TransactionSynchronizationManager.TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState(state);){
                    TransactionSynchronizationManager.unbindResourceIfPossible(ContextView.class);
                }
                if (finalPreviousContext != null) {
                    TransactionSynchronizationManager.bindResource(ContextView.class, finalPreviousContext);
                }
            })));
            if (previousContext != null) {
                result = result.contextWrite(previousContext);
            }
            CompletableFuture<T> completableFuture = AsyncUsingReactiveTransactionOperations.onCompleteCompleteFuture(result);
            return completableFuture;
        }
    }

    private static <T> CompletableFuture<T> onCompleteCompleteFuture(Publisher<T> publisher) {
        final CompletableFuture completableFuture = new CompletableFuture();
        publisher.subscribe((Subscriber)new CoreSubscriber<T>(){
            private T result;

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(T t) {
                this.result = t;
            }

            public void onError(Throwable t) {
                completableFuture.completeExceptionally(t);
            }

            public void onComplete() {
                completableFuture.complete(this.result);
            }
        });
        return completableFuture;
    }

    private static final class DefaultAsyncTransactionStatus<T>
    implements AsyncTransactionStatus<T> {
        private final ReactiveTransactionStatus<T> status;

        private DefaultAsyncTransactionStatus(ReactiveTransactionStatus<T> status) {
            this.status = status;
        }

        @Override
        public boolean isNewTransaction() {
            return this.status.isNewTransaction();
        }

        @Override
        public void setRollbackOnly() {
            this.status.setRollbackOnly();
        }

        @Override
        public boolean isRollbackOnly() {
            return this.status.isRollbackOnly();
        }

        @Override
        public boolean isCompleted() {
            return this.status.isCompleted();
        }

        @Override
        public T getConnection() {
            return this.status.getConnection();
        }
    }
}

